/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.valuation.CommonValuationReport;
import drr.regulation.esma.emir.refit.valuation.NonReportable;
import drr.regulation.esma.emir.refit.valuation.meta.ESMAValuationReportMeta;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ESMAValuationReport", builder=ESMAValuationReportBuilderImpl.class, version="7.0.0-dev.73")
@RuneDataType(value="ESMAValuationReport", model="drr", builder=ESMAValuationReportBuilderImpl.class, version="7.0.0-dev.73")
public interface ESMAValuationReport
extends CommonValuationReport {
    public static final ESMAValuationReportMeta metaData = new ESMAValuationReportMeta();

    @Override
    public Date getEventDate();

    @Override
    public ReportLevelEnum getLevel();

    public NonReportable getNonReportable();

    @Override
    public ESMAValuationReport build();

    @Override
    public ESMAValuationReportBuilder toBuilder();

    public static ESMAValuationReportBuilder builder() {
        return new ESMAValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends ESMAValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ESMAValuationReport> getType() {
        return ESMAValuationReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
    }

    public static class ESMAValuationReportBuilderImpl
    extends CommonValuationReport.CommonValuationReportBuilderImpl
    implements ESMAValuationReportBuilder {
        protected Date eventDate;
        protected ReportLevelEnum level;
        protected NonReportable.NonReportableBuilder nonReportable;

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="level", isRequired=true)
        @RuneAttribute(value="level", isRequired=true)
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public NonReportable.NonReportableBuilder getNonReportable() {
            return this.nonReportable;
        }

        @Override
        public NonReportable.NonReportableBuilder getOrCreateNonReportable() {
            NonReportable.NonReportableBuilder result = this.nonReportable != null ? this.nonReportable : (this.nonReportable = NonReportable.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ESMAValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public ESMAValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public ESMAValuationReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public ESMAValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public ESMAValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public ESMAValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public ESMAValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public ESMAValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public ESMAValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ESMAValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="level", isRequired=true)
        @RuneAttribute(value="level", isRequired=true)
        public ESMAValuationReportBuilder setLevelOverriddenAsReportLevelEnum(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAValuationReportBuilder setLevel(ReportLevelEnum _level) {
            return this.setLevelOverriddenAsReportLevelEnum(_level);
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public ESMAValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public ESMAValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public ESMAValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public ESMAValuationReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public ESMAValuationReportBuilder setEventDateOverriddenAsDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAValuationReportBuilder setEventDate(Date _eventDate) {
            return this.setEventDateOverriddenAsDate(_eventDate);
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public ESMAValuationReportBuilder setNonReportable(NonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        public ESMAValuationReport build() {
            return new ESMAValuationReportImpl(this);
        }

        @Override
        public ESMAValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public ESMAValuationReportBuilder prune() {
            super.prune();
            if (this.nonReportable != null && !this.nonReportable.prune().hasData()) {
                this.nonReportable = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEventDate() != null) {
                return true;
            }
            if (this.getLevel() != null) {
                return true;
            }
            return this.getNonReportable() != null && this.getNonReportable().hasData();
        }

        @Override
        public ESMAValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ESMAValuationReportBuilder o = (ESMAValuationReportBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonReportable(), (RosettaModelObjectBuilder)o.getNonReportable(), this::setNonReportable);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDateOverriddenAsDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLevel(), (Object)o.getLevel(), this::setLevelOverriddenAsReportLevelEnum, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ESMAValuationReport _that = (ESMAValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.level, (Object)_that.getLevel())) {
                return false;
            }
            return Objects.equals(this.nonReportable, _that.getNonReportable());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ESMAValuationReportBuilder {eventDate=" + String.valueOf(this.eventDate) + ", level=" + String.valueOf((Object)this.level) + ", nonReportable=" + String.valueOf(this.nonReportable) + "} " + super.toString();
        }
    }

    public static interface ESMAValuationReportBuilder
    extends ESMAValuationReport,
    CommonValuationReport.CommonValuationReportBuilder {
        public NonReportable.NonReportableBuilder getOrCreateNonReportable();

        @Override
        public NonReportable.NonReportableBuilder getNonReportable();

        @Override
        public ESMAValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public ESMAValuationReportBuilder setCounterparty1(String var1);

        @Override
        public ESMAValuationReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public ESMAValuationReportBuilder setCounterparty2(String var1);

        @Override
        public ESMAValuationReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public ESMAValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public ESMAValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public ESMAValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public ESMAValuationReportBuilder setDelta(BigDecimal var1);

        @Override
        public ESMAValuationReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public ESMAValuationReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public ESMAValuationReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public ESMAValuationReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public ESMAValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public ESMAValuationReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public ESMAValuationReportBuilder setEventDate(Date var1);

        public ESMAValuationReportBuilder setEventDateOverriddenAsDate(Date var1);

        public ESMAValuationReportBuilder setLevelOverriddenAsReportLevelEnum(ReportLevelEnum var1);

        public ESMAValuationReportBuilder setNonReportable(NonReportable var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.NonReportableBuilder.class, this.getNonReportable(), new AttributeMeta[0]);
        }

        @Override
        public ESMAValuationReportBuilder prune();
    }

    public static class ESMAValuationReportImpl
    extends CommonValuationReport.CommonValuationReportImpl
    implements ESMAValuationReport {
        private final Date eventDate;
        private final ReportLevelEnum level;
        private final NonReportable nonReportable;

        protected ESMAValuationReportImpl(ESMAValuationReportBuilder builder) {
            super(builder);
            this.eventDate = builder.getEventDate();
            this.level = builder.getLevel();
            this.nonReportable = Optional.ofNullable(builder.getNonReportable()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="level", isRequired=true)
        @RuneAttribute(value="level", isRequired=true)
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public NonReportable getNonReportable() {
            return this.nonReportable;
        }

        @Override
        public ESMAValuationReport build() {
            return this;
        }

        @Override
        public ESMAValuationReportBuilder toBuilder() {
            ESMAValuationReportBuilder builder = ESMAValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ESMAValuationReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDateOverriddenAsDate);
            Optional.ofNullable(this.getLevel()).ifPresent(builder::setLevelOverriddenAsReportLevelEnum);
            Optional.ofNullable(this.getNonReportable()).ifPresent(builder::setNonReportable);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ESMAValuationReport _that = (ESMAValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.level, (Object)_that.getLevel())) {
                return false;
            }
            return Objects.equals(this.nonReportable, _that.getNonReportable());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ESMAValuationReport {eventDate=" + String.valueOf(this.eventDate) + ", level=" + String.valueOf((Object)this.level) + ", nonReportable=" + String.valueOf(this.nonReportable) + "} " + super.toString();
        }
    }
}

