/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.valuation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.emir.functions.ValuationTimestamp_06_Validation;
import drr.regulation.esma.emir.refit.valuation.ESMAValuationReport;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAValuationReportEMIR_VR_2023_06")
@ImplementedBy(value=Default.class)
public interface ESMAValuationReportEMIR_VR_2023_06
extends Validator<ESMAValuationReport> {
    public static final String NAME = "ESMAValuationReportEMIR_VR_2023_06";
    public static final String DEFINITION = "ValuationTimestamp_06_Validation(valuationAmount, valuationTimestamp, eventDate)";

    public static class NoOp
    implements ESMAValuationReportEMIR_VR_2023_06 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAValuationReport eSMAValuationReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAValuationReportEMIR_VR_2023_06 {
        @Inject
        protected ValuationTimestamp_06_Validation valuationTimestamp_06_Validation;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAValuationReport eSMAValuationReport) {
            ComparisonResult result = this.executeDataRule(eSMAValuationReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAValuationReportEMIR_VR_2023_06.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAValuationReport", (RosettaPath)path, (String)ESMAValuationReportEMIR_VR_2023_06.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAValuationReportEMIR_VR_2023_06.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAValuationReport", (RosettaPath)path, (String)ESMAValuationReportEMIR_VR_2023_06.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAValuationReport eSMAValuationReport) {
            try {
                return ComparisonResult.of((Mapper)MapperS.of((Object)this.valuationTimestamp_06_Validation.evaluate((BigDecimal)MapperS.of((Object)eSMAValuationReport).map("getValuationAmount", _eSMAValuationReport -> _eSMAValuationReport.getValuationAmount()).get(), (ZonedDateTime)MapperS.of((Object)eSMAValuationReport).map("getValuationTimestamp", _eSMAValuationReport -> _eSMAValuationReport.getValuationTimestamp()).get(), (Date)MapperS.of((Object)eSMAValuationReport).map("getEventDate", _eSMAValuationReport -> _eSMAValuationReport.getEventDate()).get())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

