/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.uti.functions.UniqueTransactionIdentifierForTransaction;
import java.util.Collections;
import javax.inject.Inject;

@ImplementedBy(value=UTIFCAValueRuleDefault.class)
public abstract class UTIFCAValueRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected UniqueTransactionIdentifierForTransaction uniqueTransactionIdentifierForTransaction;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class UTIFCAValueRuleDefault
    extends UTIFCAValueRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            SupervisoryBodyEnum supervisoryBodyEnum = SupervisoryBodyEnum.FCA;
            output = this.uniqueTransactionIdentifierForTransaction.evaluate(input, supervisoryBodyEnum == null ? Collections.emptyList() : Collections.singletonList(supervisoryBodyEnum));
            return output;
        }
    }
}

