/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HKMATransactionReportTypeFormatValidator
implements Validator<HKMATransactionReport> {
    private List<ComparisonResult> getComparisonResults(HKMATransactionReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"beneficiary1", (String)o.getBeneficiary1(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"buyerIdentifier", (String)o.getBuyerIdentifier(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"sellerIdentifier", (String)o.getSellerIdentifier(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"centralCounterparty", (String)o.getCentralCounterparty(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"clearingMember", (String)o.getClearingMember(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkNumber((String)"callAmount", (BigDecimal)o.getCallAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"putAmount", (BigDecimal)o.getPutAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"delta", (BigDecimal)o.getDelta(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"packageIdentifier", (String)o.getPackageIdentifier(), (int)1, Optional.of(100), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,100}"))), ExpressionOperators.checkString((String)"priceUnitOfMeasure", (String)o.getPriceUnitOfMeasure(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"optionPremiumAmount", (BigDecimal)o.getOptionPremiumAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"exchangeRate", (BigDecimal)o.getExchangeRate(), Optional.of(18), Optional.of(13), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"exchangeRateBasis", (String)o.getExchangeRateBasis(), (int)7, Optional.of(7), Optional.of(Pattern.compile("[A-Z]{3,3}/[A-Z]{3,3}"))), ExpressionOperators.checkNumber((String)"cdSIndexAttachmentPoint", (BigDecimal)o.getCdSIndexAttachmentPoint(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"cdSIndexDetachmentPoint", (BigDecimal)o.getCdSIndexDetachmentPoint(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"priorUTI", (String)o.getPriorUTI(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkNumber((String)"valuationAmount", (BigDecimal)o.getValuationAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"customBasketCode", (String)o.getCustomBasketCode(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"underlyingIdOther", (String)o.getUnderlyingIdOther(), (int)1, Optional.of(210), Optional.empty()), ExpressionOperators.checkString((String)"underlyingAssetTradingPlatformIdentifier", (String)o.getUnderlyingAssetTradingPlatformIdentifier(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"underlyingAssetPriceSource", (String)o.getUnderlyingAssetPriceSource(), (int)1, Optional.of(50), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,50}"))), ExpressionOperators.checkString((String)"eventIdentifier", (String)o.getEventIdentifier(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"platformIdentifier", (String)o.getPlatformIdentifier(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"executionAgentCounterparty2", (String)o.getExecutionAgentCounterparty2(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"corporateSectorOfTheCounterparty1", o.getCorporateSectorOfTheCounterparty1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"corporateSectorOfTheCounterparty2", o.getCorporateSectorOfTheCounterparty2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"counterparty2Name", (String)o.getCounterparty2Name(), (int)1, Optional.of(150), Optional.empty()), ExpressionOperators.checkString((String)"reportSubmittingEntityID", (String)o.getReportSubmittingEntityID(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"entityResponsibleForReporting", (String)o.getEntityResponsibleForReporting(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"brokerID", (String)o.getBrokerID(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkNumber((String)"masterAgreementVersion", (Integer)o.getMasterAgreementVersion(), Optional.empty(), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"secondaryTransactionIdentifier", (String)o.getSecondaryTransactionIdentifier(), (int)1, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"underlyingIdentification", (String)o.getUnderlyingIdentification(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), ExpressionOperators.checkString((String)"nameOfTheUnderlyingIndex", (String)o.getNameOfTheUnderlyingIndex(), (int)1, Optional.of(50), Optional.of(Pattern.compile("[a-zA-Z0-9 \\:.\\-_\\&]{1,50}"))), ExpressionOperators.checkString((String)"swapLinkID", (String)o.getSwapLinkID(), (int)1, Optional.of(35), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,35}"))), ExpressionOperators.checkString((String)"priorUTIProprietary", (String)o.getPriorUTIProprietary(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperators.checkString((String)"uniqueTransactionIdentifier", (String)o.getUniqueTransactionIdentifier(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"uniqueTransactionIdentifierProprietary", (String)o.getUniqueTransactionIdentifierProprietary(), (int)0, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,50}[a-zA-Z0-9]{1}"))), ExpressionOperators.checkString((String)"originalSwapUTI", (String)o.getOriginalSwapUTI(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"subsequentPositionUTI", (String)o.getSubsequentPositionUTI(), (int)0, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,50}[a-zA-Z0-9]{1}"))), ExpressionOperators.checkString((String)"originalSwapSDRIdentifier", (String)o.getOriginalSwapSDRIdentifier(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"priorUSI", (String)o.getPriorUSI(), (int)1, Optional.of(42), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,42}"))), ExpressionOperators.checkString((String)"newSDRIdentifier", (String)o.getNewSDRIdentifier(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkNumber((String)"series", (Integer)o.getSeries(), Optional.of(5), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"indexFactor", (BigDecimal)o.getIndexFactor(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"seriesVersion", (Integer)o.getSeriesVersion(), Optional.of(5), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"initialMarginCollateralPortfolioCode", (String)o.getInitialMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"variationMarginCollateralPortfolioCode", (String)o.getVariationMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkNumber((String)"basketConstituentNumberOfUnits", o.getBasketConstituentNumberOfUnits(), Optional.of(18), Optional.of(13), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"basketConstituentUnitOfMeasure", o.getBasketConstituentUnitOfMeasure(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkString((String)"productDescription", (String)o.getProductDescription(), (int)1, Optional.of(255), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,255}"))), ExpressionOperators.checkString((String)"beneficiary", (String)o.getBeneficiary(), (int)1, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"uniqueProductIdentifierProprietary", (String)o.getUniqueProductIdentifierProprietary(), (int)1, Optional.of(100), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,100}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMATransactionReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"HKMATransactionReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"HKMATransactionReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"HKMATransactionReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"HKMATransactionReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

