/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.sec.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutForQuantityLeg2Rule;
import drr.regulation.sec.rewrite.trade.functions.IsAllowableActionForSEC;
import drr.standards.iosco.cde.version2.quantity.reports.NotionalCurrencyRule;
import javax.inject.Inject;

@ImplementedBy(value=NotionalCurrency2RuleDefault.class)
public abstract class NotionalCurrency2Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected IsAllowableActionForSEC isAllowableActionForSEC;
    @Inject
    protected NotionalCurrencyRule notionalCurrencyRule;
    @Inject
    protected PayoutForQuantityLeg2Rule payoutForQuantityLeg2Rule;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class NotionalCurrency2RuleDefault
    extends NotionalCurrency2Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForSEC.evaluate((ReportableEventBase)item.get()));
            output = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.notionalCurrencyRule.evaluate(this.payoutForQuantityLeg2Rule.evaluate((TransactionReportInstruction)item.get())))).get();
            return output;
        }
    }
}

