/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.payment.reports;

import cdm.event.common.TransferState;
import cdm.observable.asset.FeeTypeEnum;
import cdm.product.common.settlement.ScheduledTransferEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.standards.iso.PaymentType4Code;

@ImplementedBy(value=OtherPaymentTypeRuleDefault.class)
public abstract class OtherPaymentTypeRule
implements ReportFunction<TransferState, PaymentType4Code> {
    public PaymentType4Code evaluate(TransferState input) {
        PaymentType4Code output = this.doEvaluate(input);
        return output;
    }

    protected abstract PaymentType4Code doEvaluate(TransferState var1);

    public static class OtherPaymentTypeRuleDefault
    extends OtherPaymentTypeRule {
        @Override
        protected PaymentType4Code doEvaluate(TransferState input) {
            PaymentType4Code output = null;
            return this.assignOutput(output, input);
        }

        protected PaymentType4Code assignOutput(PaymentType4Code output, TransferState input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> item.map("getTransfer", transferState -> transferState.getTransfer()).map("getTransferExpression", transfer -> transfer.getTransferExpression()));
            output = (PaymentType4Code)((Object)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)item.map("getPriceTransfer", transferExpression -> transferExpression.getPriceTransfer()), (Mapper)MapperS.of((Object)FeeTypeEnum.UPFRONT), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)PaymentType4Code.UFRO));
                }
                if (ExpressionOperators.areEqual((Mapper)item.map("getPriceTransfer", transferExpression -> transferExpression.getPriceTransfer()), (Mapper)MapperS.of((Object)FeeTypeEnum.TERMINATION), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)PaymentType4Code.UWIN));
                }
                if (ExpressionOperators.areEqual((Mapper)item.map("getScheduledTransfer", transferExpression -> transferExpression.getScheduledTransfer()).map("getTransferType", scheduledTransfer -> scheduledTransfer.getTransferType()), (Mapper)MapperS.of((Object)ScheduledTransferEnum.PRINCIPAL_PAYMENT), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)PaymentType4Code.PEXH));
                }
                return MapperS.ofNull();
            }).get());
            return output;
        }
    }
}

