/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.price.functions.Contract_Price;
import drr.standards.iosco.cde.version1.price.functions.StrikePrice;
import drr.standards.iso.functions.FormatToBaseOne18Rate;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=ExchangeRateRuleDefault.class)
public abstract class ExchangeRateRule
implements ReportFunction<TransactionReportInstructionBase, BigDecimal> {
    @Inject
    protected Contract_Price contract_Price;
    @Inject
    protected FormatToBaseOne18Rate formatToBaseOne18Rate;
    @Inject
    protected StrikePrice strikePrice;

    public BigDecimal evaluate(TransactionReportInstructionBase input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstructionBase var1);

    public static class ExchangeRateRuleDefault
    extends ExchangeRateRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstructionBase input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstructionBase input) {
            MapperC thenArg0 = MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperC.of(this.contract_Price.evaluate(input)), MapperS.of((Object)this.strikePrice.evaluate(input))}).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.notExists((Mapper)item.map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get());
            MapperS thenArg1 = thenArg0.last();
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> item.map("getValue", priceSchedule -> priceSchedule.getValue()));
            output = (BigDecimal)MapperS.of((Object)this.formatToBaseOne18Rate.evaluate((BigDecimal)thenArg2.get())).get();
            return output;
        }
    }
}

