/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.quantity.reports;

import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsFXOption;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.quantity.functions.GetTradeForQuantity;
import drr.standards.iosco.cde.version1.quantity.functions.OptionAmountAndCurrency;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.functions.FormatToShortFraction5DecimalNumber;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=CallAmountRuleDefault.class)
public abstract class CallAmountRule
implements ReportFunction<TransactionReportInstructionBase, BigDecimal> {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
    @Inject
    protected GetTradeForQuantity getTradeForQuantity;
    @Inject
    protected IsFXOption isFXOption;
    @Inject
    protected OptionAmountAndCurrency optionAmountAndCurrency;
    @Inject
    protected ProductForTrade productForTrade;

    public BigDecimal evaluate(TransactionReportInstructionBase input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstructionBase var1);

    public static class CallAmountRuleDefault
    extends CallAmountRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstructionBase input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstructionBase input) {
            MapperS thenArg0 = MapperS.of((Object)this.productForTrade.evaluate(this.getTradeForQuantity.evaluate(input)));
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> this.isFXOption.evaluate((Product)item.get()));
            MapperS thenArg2 = MapperS.of((Object)this.optionAmountAndCurrency.evaluate((OptionPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)thenArg1.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get(), OptionTypeCode.CALL)).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
            output = (BigDecimal)MapperS.of((Object)this.formatToShortFraction5DecimalNumber.evaluate((BigDecimal)thenArg2.get())).get();
            return output;
        }
    }
}

