/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.quantity.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.product.functions.IsFXOption;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.quantity.functions.GetTradeForQuantity;
import drr.standards.iosco.cde.version1.quantity.functions.OptionAmountAndCurrency;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

@ImplementedBy(value=PutCurrencyRuleDefault.class)
public abstract class PutCurrencyRule
implements ReportFunction<TransactionReportInstructionBase, ISOCurrencyCodeEnum> {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected GetTradeForQuantity getTradeForQuantity;
    @Inject
    protected IsFXOption isFXOption;
    @Inject
    protected OptionAmountAndCurrency optionAmountAndCurrency;
    @Inject
    protected ProductForTrade productForTrade;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstructionBase input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstructionBase var1);

    public static class PutCurrencyRuleDefault
    extends PutCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstructionBase input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstructionBase input) {
            MapperS thenArg0 = MapperS.of((Object)this.productForTrade.evaluate(this.getTradeForQuantity.evaluate(input)));
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> this.isFXOption.evaluate((Product)item.get()));
            MapperS thenArg2 = MapperS.of((Object)this.optionAmountAndCurrency.evaluate((OptionPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)thenArg1.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get(), OptionTypeCode.PUTO)).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
            output = (ISOCurrencyCodeEnum)thenArg2.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

