/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.functions.LeapYearDateDifference;
import com.rosetta.model.lib.records.Date;
import java.time.LocalDate;
import java.time.chrono.IsoChronology;

public class LeapYearDateDifferenceImpl
extends LeapYearDateDifference {
    @Override
    protected Integer doEvaluate(Date firstDate, Date secondDate) {
        int multiplier;
        if (firstDate == null || secondDate == null) {
            return null;
        }
        LocalDate startDate = firstDate.toLocalDate();
        LocalDate endDate = secondDate.toLocalDate();
        int daysThatAreInLeapYear = 0;
        boolean reversed = endDate.isBefore(startDate);
        int n = multiplier = reversed ? -1 : 1;
        if (reversed) {
            LocalDate temp = endDate;
            endDate = startDate;
            startDate = temp;
        }
        LocalDate myDate = startDate;
        while (myDate.isBefore(endDate)) {
            if (IsoChronology.INSTANCE.isLeapYear(myDate.getYear())) {
                ++daysThatAreInLeapYear;
            }
            myDate = myDate.plusDays(1L);
        }
        return multiplier * daysThatAreInLeapYear;
    }
}

