/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.TaxonomyClassification;
import cdm.base.staticdata.asset.common.meta.TaxonomyValueMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TaxonomyValue", builder=TaxonomyValueBuilderImpl.class, version="5.30.0")
@RuneDataType(value="TaxonomyValue", model="cdm", builder=TaxonomyValueBuilderImpl.class, version="5.30.0")
public interface TaxonomyValue
extends RosettaModelObject {
    public static final TaxonomyValueMeta metaData = new TaxonomyValueMeta();

    public FieldWithMetaString getName();

    public List<? extends TaxonomyClassification> getClassification();

    public TaxonomyValue build();

    public TaxonomyValueBuilder toBuilder();

    public static TaxonomyValueBuilder builder() {
        return new TaxonomyValueBuilderImpl();
    }

    default public RosettaMetaData<? extends TaxonomyValue> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TaxonomyValue> getType() {
        return TaxonomyValue.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.class, this.getName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("classification"), processor, TaxonomyClassification.class, this.getClassification(), new AttributeMeta[0]);
    }

    public static class TaxonomyValueBuilderImpl
    implements TaxonomyValueBuilder {
        protected FieldWithMetaString.FieldWithMetaStringBuilder name;
        protected List<TaxonomyClassification.TaxonomyClassificationBuilder> classification = new ArrayList<TaxonomyClassification.TaxonomyClassificationBuilder>();

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public FieldWithMetaString.FieldWithMetaStringBuilder getName() {
            return this.name;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateName() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.name != null ? this.name : (this.name = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="classification")
        @RuneAttribute(value="classification")
        public List<? extends TaxonomyClassification.TaxonomyClassificationBuilder> getClassification() {
            return this.classification;
        }

        @Override
        public TaxonomyClassification.TaxonomyClassificationBuilder getOrCreateClassification(int index) {
            if (this.classification == null) {
                this.classification = new ArrayList<TaxonomyClassification.TaxonomyClassificationBuilder>();
            }
            return (TaxonomyClassification.TaxonomyClassificationBuilder)this.getIndex(this.classification, index, () -> {
                TaxonomyClassification.TaxonomyClassificationBuilder newClassification = TaxonomyClassification.builder();
                return newClassification;
            });
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public TaxonomyValueBuilder setName(FieldWithMetaString _name) {
            this.name = _name == null ? null : _name.toBuilder();
            return this;
        }

        @Override
        public TaxonomyValueBuilder setNameValue(String _name) {
            this.getOrCreateName().setValue(_name);
            return this;
        }

        @Override
        @RosettaAttribute(value="classification")
        @RuneAttribute(value="classification")
        public TaxonomyValueBuilder addClassification(TaxonomyClassification _classification) {
            if (_classification != null) {
                this.classification.add(_classification.toBuilder());
            }
            return this;
        }

        @Override
        public TaxonomyValueBuilder addClassification(TaxonomyClassification _classification, int idx) {
            this.getIndex(this.classification, idx, () -> _classification.toBuilder());
            return this;
        }

        @Override
        public TaxonomyValueBuilder addClassification(List<? extends TaxonomyClassification> classifications) {
            if (classifications != null) {
                for (TaxonomyClassification taxonomyClassification : classifications) {
                    this.classification.add(taxonomyClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="classification")
        public TaxonomyValueBuilder setClassification(List<? extends TaxonomyClassification> classifications) {
            this.classification = classifications == null ? new ArrayList<TaxonomyClassification.TaxonomyClassificationBuilder>() : (List)classifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TaxonomyValue build() {
            return new TaxonomyValueImpl(this);
        }

        @Override
        public TaxonomyValueBuilder toBuilder() {
            return this;
        }

        @Override
        public TaxonomyValueBuilder prune() {
            if (this.name != null && !this.name.prune().hasData()) {
                this.name = null;
            }
            this.classification = this.classification.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            return this.getClassification() != null && this.getClassification().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TaxonomyValueBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TaxonomyValueBuilder o = (TaxonomyValueBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getName(), (RosettaModelObjectBuilder)o.getName(), this::setName);
            merger.mergeRosetta(this.getClassification(), o.getClassification(), this::getOrCreateClassification);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TaxonomyValue _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            return ListEquals.listEquals(this.classification, _that.getClassification());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.classification != null ? this.classification.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TaxonomyValueBuilder {name=" + this.name + ", classification=" + this.classification + '}';
        }
    }

    public static interface TaxonomyValueBuilder
    extends TaxonomyValue,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateName();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getName();

        public TaxonomyClassification.TaxonomyClassificationBuilder getOrCreateClassification(int var1);

        public List<? extends TaxonomyClassification.TaxonomyClassificationBuilder> getClassification();

        public TaxonomyValueBuilder setName(FieldWithMetaString var1);

        public TaxonomyValueBuilder setNameValue(String var1);

        public TaxonomyValueBuilder addClassification(TaxonomyClassification var1);

        public TaxonomyValueBuilder addClassification(TaxonomyClassification var1, int var2);

        public TaxonomyValueBuilder addClassification(List<? extends TaxonomyClassification> var1);

        public TaxonomyValueBuilder setClassification(List<? extends TaxonomyClassification> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("classification"), processor, TaxonomyClassification.TaxonomyClassificationBuilder.class, this.getClassification(), new AttributeMeta[0]);
        }

        public TaxonomyValueBuilder prune();
    }

    public static class TaxonomyValueImpl
    implements TaxonomyValue {
        private final FieldWithMetaString name;
        private final List<? extends TaxonomyClassification> classification;

        protected TaxonomyValueImpl(TaxonomyValueBuilder builder) {
            this.name = Optional.ofNullable(builder.getName()).map(f -> f.build()).orElse(null);
            this.classification = Optional.ofNullable(builder.getClassification()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public FieldWithMetaString getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="classification")
        @RuneAttribute(value="classification")
        public List<? extends TaxonomyClassification> getClassification() {
            return this.classification;
        }

        @Override
        public TaxonomyValue build() {
            return this;
        }

        @Override
        public TaxonomyValueBuilder toBuilder() {
            TaxonomyValueBuilder builder = TaxonomyValue.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TaxonomyValueBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getClassification()).ifPresent(builder::setClassification);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TaxonomyValue _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            return ListEquals.listEquals(this.classification, _that.getClassification());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.classification != null ? this.classification.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TaxonomyValue {name=" + this.name + ", classification=" + this.classification + '}';
        }
    }
}

