/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.observable.asset.Money;
import cdm.product.common.settlement.PaymentRule;
import cdm.product.common.settlement.meta.PaymentDetailMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PaymentDetail", builder=PaymentDetailBuilderImpl.class, version="5.30.0")
@RuneDataType(value="PaymentDetail", model="cdm", builder=PaymentDetailBuilderImpl.class, version="5.30.0")
public interface PaymentDetail
extends RosettaModelObject,
GlobalKey {
    public static final PaymentDetailMeta metaData = new PaymentDetailMeta();

    public AdjustableOrRelativeDate getPaymentDate();

    public PaymentRule getPaymentRule();

    public Money getPaymentAmount();

    public MetaFields getMeta();

    public PaymentDetail build();

    public PaymentDetailBuilder toBuilder();

    public static PaymentDetailBuilder builder() {
        return new PaymentDetailBuilderImpl();
    }

    default public RosettaMetaData<? extends PaymentDetail> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PaymentDetail> getType() {
        return PaymentDetail.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentRule"), processor, PaymentRule.class, this.getPaymentRule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, Money.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class PaymentDetailBuilderImpl
    implements PaymentDetailBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder paymentDate;
        protected PaymentRule.PaymentRuleBuilder paymentRule;
        protected Money.MoneyBuilder paymentAmount;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreatePaymentDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentRule", isRequired=true)
        @RuneAttribute(value="paymentRule", isRequired=true)
        public PaymentRule.PaymentRuleBuilder getPaymentRule() {
            return this.paymentRule;
        }

        @Override
        public PaymentRule.PaymentRuleBuilder getOrCreatePaymentRule() {
            PaymentRule.PaymentRuleBuilder result = this.paymentRule != null ? this.paymentRule : (this.paymentRule = PaymentRule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentAmount")
        @RuneAttribute(value="paymentAmount")
        public Money.MoneyBuilder getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePaymentAmount() {
            Money.MoneyBuilder result = this.paymentAmount != null ? this.paymentAmount : (this.paymentAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public PaymentDetailBuilder setPaymentDate(AdjustableOrRelativeDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentRule", isRequired=true)
        @RuneAttribute(value="paymentRule", isRequired=true)
        public PaymentDetailBuilder setPaymentRule(PaymentRule _paymentRule) {
            this.paymentRule = _paymentRule == null ? null : _paymentRule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount")
        @RuneAttribute(value="paymentAmount")
        public PaymentDetailBuilder setPaymentAmount(Money _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public PaymentDetailBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public PaymentDetail build() {
            return new PaymentDetailImpl(this);
        }

        @Override
        public PaymentDetailBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentDetailBuilder prune() {
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            if (this.paymentRule != null && !this.paymentRule.prune().hasData()) {
                this.paymentRule = null;
            }
            if (this.paymentAmount != null && !this.paymentAmount.prune().hasData()) {
                this.paymentAmount = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPaymentDate() != null && this.getPaymentDate().hasData()) {
                return true;
            }
            if (this.getPaymentRule() != null && this.getPaymentRule().hasData()) {
                return true;
            }
            return this.getPaymentAmount() != null && this.getPaymentAmount().hasData();
        }

        public PaymentDetailBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PaymentDetailBuilder o = (PaymentDetailBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentRule(), (RosettaModelObjectBuilder)o.getPaymentRule(), this::setPaymentRule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentAmount(), (RosettaModelObjectBuilder)o.getPaymentAmount(), this::setPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDetail _that = this.getType().cast(o);
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentRule, _that.getPaymentRule())) {
                return false;
            }
            if (!Objects.equals(this.paymentAmount, _that.getPaymentAmount())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentRule != null ? this.paymentRule.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDetailBuilder {paymentDate=" + this.paymentDate + ", paymentRule=" + this.paymentRule + ", paymentAmount=" + this.paymentAmount + ", meta=" + this.meta + '}';
        }
    }

    public static interface PaymentDetailBuilder
    extends PaymentDetail,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreatePaymentDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getPaymentDate();

        public PaymentRule.PaymentRuleBuilder getOrCreatePaymentRule();

        @Override
        public PaymentRule.PaymentRuleBuilder getPaymentRule();

        public Money.MoneyBuilder getOrCreatePaymentAmount();

        @Override
        public Money.MoneyBuilder getPaymentAmount();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public PaymentDetailBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        public PaymentDetailBuilder setPaymentRule(PaymentRule var1);

        public PaymentDetailBuilder setPaymentAmount(Money var1);

        public PaymentDetailBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentRule"), processor, PaymentRule.PaymentRuleBuilder.class, this.getPaymentRule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, Money.MoneyBuilder.class, this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public PaymentDetailBuilder prune();
    }

    public static class PaymentDetailImpl
    implements PaymentDetail {
        private final AdjustableOrRelativeDate paymentDate;
        private final PaymentRule paymentRule;
        private final Money paymentAmount;
        private final MetaFields meta;

        protected PaymentDetailImpl(PaymentDetailBuilder builder) {
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
            this.paymentRule = Optional.ofNullable(builder.getPaymentRule()).map(f -> f.build()).orElse(null);
            this.paymentAmount = Optional.ofNullable(builder.getPaymentAmount()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public AdjustableOrRelativeDate getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        @RosettaAttribute(value="paymentRule", isRequired=true)
        @RuneAttribute(value="paymentRule", isRequired=true)
        public PaymentRule getPaymentRule() {
            return this.paymentRule;
        }

        @Override
        @RosettaAttribute(value="paymentAmount")
        @RuneAttribute(value="paymentAmount")
        public Money getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PaymentDetail build() {
            return this;
        }

        @Override
        public PaymentDetailBuilder toBuilder() {
            PaymentDetailBuilder builder = PaymentDetail.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentDetailBuilder builder) {
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
            Optional.ofNullable(this.getPaymentRule()).ifPresent(builder::setPaymentRule);
            Optional.ofNullable(this.getPaymentAmount()).ifPresent(builder::setPaymentAmount);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDetail _that = this.getType().cast(o);
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentRule, _that.getPaymentRule())) {
                return false;
            }
            if (!Objects.equals(this.paymentAmount, _that.getPaymentAmount())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentRule != null ? this.paymentRule.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDetail {paymentDate=" + this.paymentDate + ", paymentRule=" + this.paymentRule + ", paymentAmount=" + this.paymentAmount + ", meta=" + this.meta + '}';
        }
    }
}

