/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiverEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.common.schedule.RateSchedule;
import cdm.product.template.meta.StrikeScheduleMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="StrikeSchedule", builder=StrikeScheduleBuilderImpl.class, version="5.30.0")
@RuneDataType(value="StrikeSchedule", model="cdm", builder=StrikeScheduleBuilderImpl.class, version="5.30.0")
public interface StrikeSchedule
extends RateSchedule {
    public static final StrikeScheduleMeta metaData = new StrikeScheduleMeta();

    public PayerReceiverEnum getBuyer();

    public PayerReceiverEnum getSeller();

    @Override
    public StrikeSchedule build();

    @Override
    public StrikeScheduleBuilder toBuilder();

    public static StrikeScheduleBuilder builder() {
        return new StrikeScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends StrikeSchedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends StrikeSchedule> getType() {
        return StrikeSchedule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("price"), processor, ReferenceWithMetaPriceSchedule.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("buyer"), PayerReceiverEnum.class, (Object)this.getBuyer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seller"), PayerReceiverEnum.class, (Object)this.getSeller(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class StrikeScheduleBuilderImpl
    extends RateSchedule.RateScheduleBuilderImpl
    implements StrikeScheduleBuilder {
        protected PayerReceiverEnum buyer;
        protected PayerReceiverEnum seller;

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public PayerReceiverEnum getBuyer() {
            return this.buyer;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public PayerReceiverEnum getSeller() {
            return this.seller;
        }

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        @RuneScopedAttributeReference
        public StrikeScheduleBuilder setPrice(ReferenceWithMetaPriceSchedule _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        public StrikeScheduleBuilder setPriceValue(PriceSchedule _price) {
            this.getOrCreatePrice().setValue(_price);
            return this;
        }

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public StrikeScheduleBuilder setBuyer(PayerReceiverEnum _buyer) {
            this.buyer = _buyer == null ? null : _buyer;
            return this;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public StrikeScheduleBuilder setSeller(PayerReceiverEnum _seller) {
            this.seller = _seller == null ? null : _seller;
            return this;
        }

        @Override
        public StrikeSchedule build() {
            return new StrikeScheduleImpl(this);
        }

        @Override
        public StrikeScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public StrikeScheduleBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyer() != null) {
                return true;
            }
            return this.getSeller() != null;
        }

        @Override
        public StrikeScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            StrikeScheduleBuilder o = (StrikeScheduleBuilder)other;
            merger.mergeBasic((Object)this.getBuyer(), (Object)o.getBuyer(), this::setBuyer, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSeller(), (Object)o.getSeller(), this::setSeller, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StrikeSchedule _that = (StrikeSchedule)this.getType().cast(o);
            if (!Objects.equals((Object)this.buyer, (Object)_that.getBuyer())) {
                return false;
            }
            return Objects.equals((Object)this.seller, (Object)_that.getSeller());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyer != null ? ((Object)((Object)this.buyer)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.seller != null ? ((Object)((Object)this.seller)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "StrikeScheduleBuilder {buyer=" + (Object)((Object)this.buyer) + ", seller=" + (Object)((Object)this.seller) + '}' + " " + super.toString();
        }
    }

    public static interface StrikeScheduleBuilder
    extends StrikeSchedule,
    RateSchedule.RateScheduleBuilder {
        @Override
        public StrikeScheduleBuilder setPrice(ReferenceWithMetaPriceSchedule var1);

        @Override
        public StrikeScheduleBuilder setPriceValue(PriceSchedule var1);

        public StrikeScheduleBuilder setBuyer(PayerReceiverEnum var1);

        public StrikeScheduleBuilder setSeller(PayerReceiverEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("price"), processor, ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder.class, (RosettaModelObjectBuilder)this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("buyer"), PayerReceiverEnum.class, (Object)this.getBuyer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seller"), PayerReceiverEnum.class, (Object)this.getSeller(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public StrikeScheduleBuilder prune();
    }

    public static class StrikeScheduleImpl
    extends RateSchedule.RateScheduleImpl
    implements StrikeSchedule {
        private final PayerReceiverEnum buyer;
        private final PayerReceiverEnum seller;

        protected StrikeScheduleImpl(StrikeScheduleBuilder builder) {
            super(builder);
            this.buyer = builder.getBuyer();
            this.seller = builder.getSeller();
        }

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public PayerReceiverEnum getBuyer() {
            return this.buyer;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public PayerReceiverEnum getSeller() {
            return this.seller;
        }

        @Override
        public StrikeSchedule build() {
            return this;
        }

        @Override
        public StrikeScheduleBuilder toBuilder() {
            StrikeScheduleBuilder builder = StrikeSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StrikeScheduleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyer()).ifPresent(builder::setBuyer);
            Optional.ofNullable(this.getSeller()).ifPresent(builder::setSeller);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StrikeSchedule _that = (StrikeSchedule)this.getType().cast(o);
            if (!Objects.equals((Object)this.buyer, (Object)_that.getBuyer())) {
                return false;
            }
            return Objects.equals((Object)this.seller, (Object)_that.getSeller());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyer != null ? ((Object)((Object)this.buyer)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.seller != null ? ((Object)((Object)this.seller)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "StrikeSchedule {buyer=" + (Object)((Object)this.buyer) + ", seller=" + (Object)((Object)this.seller) + '}' + " " + super.toString();
        }
    }
}

