/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PayoutQuantity")
@ImplementedBy(value=Default.class)
public interface PayoutQuantity
extends Validator<Payout> {
    public static final String NAME = "PayoutQuantity";
    public static final String DEFINITION = "if optionPayout exists then optionPayout -> priceQuantity exists or optionPayout -> underlier -> contractualProduct -> economicTerms -> payout -> interestRatePayout count = 2 or optionPayout -> underlier -> foreignExchange exists";

    public static class NoOp
    implements PayoutQuantity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Payout payout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PayoutQuantity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Payout payout) {
            ComparisonResult result = this.executeDataRule(payout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutQuantity.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutQuantity.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Payout payout) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).mapC("getOptionPayout", _payout -> _payout.getOptionPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).mapC("getOptionPayout", _payout -> _payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity())).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperS.of((Object)payout).mapC("getOptionPayout", _payout -> _payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).resultCount()), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).mapC("getOptionPayout", _payout -> _payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange())));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

