/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.timeseries;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.function.ObjDoublePredicate;
import com.opengamma.strata.collect.timeseries.LocalDateDoublePoint;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeriesBuilder;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", metaScope="package")
final class DenseLocalDateDoubleTimeSeries
implements ImmutableBean,
LocalDateDoubleTimeSeries,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(get="private", validate="notNull")
    private final double[] points;
    @PropertyDefinition(get="private", validate="notNull")
    private final DenseTimeSeriesCalculation dateCalculation;
    private static final long serialVersionUID = 1L;

    static LocalDateDoubleTimeSeries of(LocalDate startDate, LocalDate endDate, Stream<LocalDateDoublePoint> values, DenseTimeSeriesCalculation dateCalculation) {
        double[] points = new double[dateCalculation.calculatePosition(startDate, endDate) + 1];
        Arrays.fill(points, Double.NaN);
        values.forEach((? super T pt) -> {
            points[dateCalculation.calculatePosition((LocalDate)startDate, (LocalDate)pt.getDate())] = pt.getValue();
        });
        return new DenseLocalDateDoubleTimeSeries(startDate, points, dateCalculation, true);
    }

    private DenseLocalDateDoubleTimeSeries(LocalDate startDate, double[] points, DenseTimeSeriesCalculation dateCalculation, boolean trusted) {
        ArgChecker.notNull(points, "points");
        this.startDate = ArgChecker.notNull(startDate, "startDate");
        this.points = trusted ? points : (double[])points.clone();
        this.dateCalculation = ArgChecker.notNull(dateCalculation, "dateCalculation");
    }

    private DenseLocalDateDoubleTimeSeries(LocalDate startDate, double[] points, DenseTimeSeriesCalculation dateCalculation) {
        this(startDate, points, dateCalculation, false);
    }

    @Override
    public boolean isEmpty() {
        return !this.validIndices().findFirst().isPresent();
    }

    @Override
    public int size() {
        return (int)this.validIndices().count();
    }

    @Override
    public boolean containsDate(LocalDate date) {
        return this.get(date).isPresent();
    }

    @Override
    public OptionalDouble get(LocalDate date) {
        double value;
        int position;
        if (!this.isEmpty() && !date.isBefore(this.startDate) && this.dateCalculation.allowsDate(date) && (position = this.dateCalculation.calculatePosition(this.startDate, date)) < this.points.length && this.isValidPoint(value = this.points[position])) {
            return OptionalDouble.of(value);
        }
        return OptionalDouble.empty();
    }

    private IntStream reversedValidIndices() {
        return IntStream.rangeClosed(1 - this.points.length, 0).map(i -> -i).filter(this::isValidIndex);
    }

    private LocalDate calculateDateFromPosition(int i) {
        return this.dateCalculation.calculateDateFromPosition(this.startDate, i);
    }

    @Override
    public LocalDate getLatestDate() {
        return this.reversedValidIndices().mapToObj(this::calculateDateFromPosition).findFirst().orElseThrow(() -> new NoSuchElementException("Unable to return latest date, time-series is empty"));
    }

    @Override
    public double getLatestValue() {
        return this.reversedValidIndices().mapToDouble(i -> this.points[i]).findFirst().orElseThrow(() -> new NoSuchElementException("Unable to return latest value, time-series is empty"));
    }

    @Override
    public LocalDateDoubleTimeSeries subSeries(LocalDate startInclusive, LocalDate endExclusive) {
        ArgChecker.notNull(startInclusive, "startInclusive");
        ArgChecker.notNull(endExclusive, "endExclusive");
        if (endExclusive.isBefore(startInclusive)) {
            throw new IllegalArgumentException("Invalid sub series, end before start: " + startInclusive + " to " + endExclusive);
        }
        if (this.isEmpty() || startInclusive.equals(endExclusive) || !this.startDate.isBefore(endExclusive) || startInclusive.isAfter(this.getLatestDate())) {
            return LocalDateDoubleTimeSeries.empty();
        }
        LocalDate resolvedStart = this.dateCalculation.adjustDate((LocalDate)Ordering.natural().max((Object)startInclusive, (Object)this.startDate));
        int startIndex = this.dateCalculation.calculatePosition(this.startDate, resolvedStart);
        int endIndex = this.dateCalculation.calculatePosition(this.startDate, endExclusive);
        return new DenseLocalDateDoubleTimeSeries(resolvedStart, Arrays.copyOfRange(this.points, Math.max(0, startIndex), Math.min(this.points.length, endIndex)), this.dateCalculation, true);
    }

    @Override
    public LocalDateDoubleTimeSeries headSeries(int numPoints) {
        ArgChecker.notNegative(numPoints, "numPoints");
        if (numPoints == 0) {
            return LocalDateDoubleTimeSeries.empty();
        }
        if (numPoints > this.size()) {
            return this;
        }
        int endPosition = this.findHeadPoints(numPoints);
        return new DenseLocalDateDoubleTimeSeries(this.startDate, Arrays.copyOf(this.points, endPosition), this.dateCalculation);
    }

    private int findHeadPoints(int required) {
        return this.validIndices().skip(required).findFirst().orElse(this.points.length);
    }

    @Override
    public LocalDateDoubleTimeSeries tailSeries(int numPoints) {
        ArgChecker.notNegative(numPoints, "numPoints");
        if (numPoints == 0) {
            return LocalDateDoubleTimeSeries.empty();
        }
        if (numPoints > this.size()) {
            return this;
        }
        int startPoint = this.findTailPoints(numPoints);
        return new DenseLocalDateDoubleTimeSeries(this.calculateDateFromPosition(startPoint), Arrays.copyOfRange(this.points, startPoint, this.points.length), this.dateCalculation);
    }

    private int findTailPoints(int required) {
        return this.reversedValidIndices().skip(required - 1).findFirst().orElse(0);
    }

    @Override
    public Stream<LocalDateDoublePoint> stream() {
        return this.validIndices().mapToObj(i -> LocalDateDoublePoint.of(this.calculateDateFromPosition(i), this.points[i]));
    }

    @Override
    public DoubleStream values() {
        return Arrays.stream(this.points).filter(this::isValidPoint);
    }

    @Override
    public Stream<LocalDate> dates() {
        return this.validIndices().mapToObj(this::calculateDateFromPosition);
    }

    private IntStream validIndices() {
        return IntStream.range(0, this.points.length).filter(this::isValidIndex);
    }

    private boolean isValidIndex(int i) {
        return this.isValidPoint(this.points[i]);
    }

    @Override
    public LocalDateDoubleTimeSeries filter(ObjDoublePredicate<LocalDate> predicate) {
        Stream<LocalDateDoublePoint> filteredPoints = this.stream().filter((? super T pt) -> predicate.test(pt.getDate(), pt.getValue()));
        return new LocalDateDoubleTimeSeriesBuilder(filteredPoints).build();
    }

    @Override
    public LocalDateDoubleTimeSeries mapDates(Function<? super LocalDate, ? extends LocalDate> mapper) {
        List dates = (List)this.dates().map(mapper).collect(Guavate.toImmutableList());
        dates.stream().reduce(this::checkAscending);
        return LocalDateDoubleTimeSeries.builder().putAll((Collection<LocalDate>)dates, Doubles.asList((double[])this.points)).build();
    }

    @Override
    public LocalDateDoubleTimeSeries mapValues(DoubleUnaryOperator mapper) {
        DoubleStream values = DoubleStream.of(this.points).map(d -> this.isValidPoint(d) ? this.applyMapper(mapper, d) : d);
        return new DenseLocalDateDoubleTimeSeries(this.startDate, values.toArray(), this.dateCalculation, true);
    }

    private double applyMapper(DoubleUnaryOperator mapper, double d) {
        double value = mapper.applyAsDouble(d);
        if (!this.isValidPoint(value)) {
            throw new IllegalArgumentException("Mapper must not map to NaN");
        }
        return value;
    }

    private boolean isValidPoint(double d) {
        return !Double.isNaN(d);
    }

    @Override
    public void forEach(ObjDoubleConsumer<LocalDate> action) {
        this.validIndices().forEach((int i) -> action.accept(this.calculateDateFromPosition(i), this.points[i]));
    }

    @Override
    public LocalDateDoubleTimeSeriesBuilder toBuilder() {
        return new LocalDateDoubleTimeSeriesBuilder(this.stream());
    }

    private LocalDate checkAscending(LocalDate earlier, LocalDate later) {
        if (earlier.isBefore(later)) {
            return later;
        }
        throw new IllegalArgumentException(Messages.format("Dates must be in ascending order after calling mapDates but {} and {} are not", earlier, later));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    private double[] getPoints() {
        return (double[])this.points.clone();
    }

    private DenseTimeSeriesCalculation getDateCalculation() {
        return this.dateCalculation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DenseLocalDateDoubleTimeSeries other = (DenseLocalDateDoubleTimeSeries)obj;
            return JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.points, (Object)other.points) && JodaBeanUtils.equal((Object)((Object)this.dateCalculation), (Object)((Object)other.dateCalculation));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.points);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.dateCalculation));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("DenseLocalDateDoubleTimeSeries{");
        buf.append("startDate").append('=').append(this.startDate).append(',').append(' ');
        buf.append("points").append('=').append(this.points).append(',').append(' ');
        buf.append("dateCalculation").append('=').append(JodaBeanUtils.toString((Object)((Object)this.dateCalculation)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<DenseLocalDateDoubleTimeSeries> {
        private LocalDate startDate;
        private double[] points;
        private DenseTimeSeriesCalculation dateCalculation;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return this.startDate;
                }
                case -982754077: {
                    return this.points;
                }
                case -152592837: {
                    return this.dateCalculation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -982754077: {
                    this.points = (double[])newValue;
                    break;
                }
                case -152592837: {
                    this.dateCalculation = (DenseTimeSeriesCalculation)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public DenseLocalDateDoubleTimeSeries build() {
            return new DenseLocalDateDoubleTimeSeries(this.startDate, this.points, this.dateCalculation);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("DenseLocalDateDoubleTimeSeries.Builder{");
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("points").append('=').append(JodaBeanUtils.toString((Object)this.points)).append(',').append(' ');
            buf.append("dateCalculation").append('=').append(JodaBeanUtils.toString((Object)((Object)this.dateCalculation)));
            buf.append('}');
            return buf.toString();
        }
    }

    static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", DenseLocalDateDoubleTimeSeries.class, LocalDate.class);
        private final MetaProperty<double[]> points = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"points", DenseLocalDateDoubleTimeSeries.class, double[].class);
        private final MetaProperty<DenseTimeSeriesCalculation> dateCalculation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dateCalculation", DenseLocalDateDoubleTimeSeries.class, DenseTimeSeriesCalculation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"startDate", "points", "dateCalculation"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return this.startDate;
                }
                case -982754077: {
                    return this.points;
                }
                case -152592837: {
                    return this.dateCalculation;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends DenseLocalDateDoubleTimeSeries> builder() {
            return new Builder();
        }

        public Class<? extends DenseLocalDateDoubleTimeSeries> beanType() {
            return DenseLocalDateDoubleTimeSeries.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<double[]> points() {
            return this.points;
        }

        public MetaProperty<DenseTimeSeriesCalculation> dateCalculation() {
            return this.dateCalculation;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return ((DenseLocalDateDoubleTimeSeries)bean).getStartDate();
                }
                case -982754077: {
                    return ((DenseLocalDateDoubleTimeSeries)bean).getPoints();
                }
                case -152592837: {
                    return ((DenseLocalDateDoubleTimeSeries)bean).getDateCalculation();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }

    static enum DenseTimeSeriesCalculation {
        SKIP_WEEKENDS{

            @Override
            int calculatePosition(LocalDate startDate, LocalDate date) {
                int unadjusted = (int)ChronoUnit.DAYS.between(startDate, date);
                int weekendAdjustment = startDate.getDayOfWeek().compareTo(date.getDayOfWeek()) > 0 ? 1 : 0;
                int numWeekends = unadjusted / 7 + weekendAdjustment;
                return unadjusted - 2 * numWeekends;
            }

            @Override
            LocalDate calculateDateFromPosition(LocalDate startDate, int position) {
                int numWeekends = position / 5;
                int remaining = position % 5;
                int endPointAdjustment = remaining < 6 - startDate.get(ChronoField.DAY_OF_WEEK) ? 0 : 2;
                return startDate.plusDays(7 * numWeekends + remaining + endPointAdjustment);
            }

            @Override
            boolean allowsDate(LocalDate date) {
                return !DenseTimeSeriesCalculation.isWeekend(date);
            }

            @Override
            public LocalDate adjustDate(LocalDate date) {
                return this.allowsDate(date) ? date : date.plusDays(8 - date.get(ChronoField.DAY_OF_WEEK));
            }
        }
        ,
        INCLUDE_WEEKENDS{

            @Override
            int calculatePosition(LocalDate startDate, LocalDate date) {
                return (int)ChronoUnit.DAYS.between(startDate, date);
            }

            @Override
            LocalDate calculateDateFromPosition(LocalDate startDate, int position) {
                return startDate.plusDays(position);
            }

            @Override
            boolean allowsDate(LocalDate date) {
                return true;
            }

            @Override
            public LocalDate adjustDate(LocalDate date) {
                return date;
            }
        };


        abstract int calculatePosition(LocalDate var1, LocalDate var2);

        abstract LocalDate calculateDateFromPosition(LocalDate var1, int var2);

        abstract boolean allowsDate(LocalDate var1);

        public abstract LocalDate adjustDate(LocalDate var1);

        private static boolean isWeekend(LocalDate date) {
            return date.get(ChronoField.DAY_OF_WEEK) > 5;
        }
    }
}

