/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.config;

import com.google.inject.ProvidedBy;
import com.regnosys.rosetta.config.RosettaConfiguration;
import com.regnosys.rosetta.experimental.ExperimentalFeature;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

@ProvidedBy(value=Provider.class)
public class RosettaModelConfiguration {
    private final String name;
    private final List<ExperimentalFeature> enableExperimentalFeatures;

    public RosettaModelConfiguration(String name, List<ExperimentalFeature> enableExperimentalFeatures) {
        Objects.requireNonNull(name);
        Validate.noNullElements(enableExperimentalFeatures);
        this.name = name;
        this.enableExperimentalFeatures = enableExperimentalFeatures;
    }

    public String getName() {
        return this.name;
    }

    public List<ExperimentalFeature> getEnableExperimentalFeatures() {
        return this.enableExperimentalFeatures;
    }

    public static class Provider
    implements jakarta.inject.Provider<RosettaModelConfiguration>,
    javax.inject.Provider<RosettaModelConfiguration> {
        private final RosettaConfiguration config;

        @Inject
        public Provider(RosettaConfiguration config) {
            this.config = config;
        }

        public RosettaModelConfiguration get() {
            return this.config.getModel();
        }
    }
}

