/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.expression;

import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.rosetta.util.types.JavaClass;
import jakarta.inject.Inject;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class JavaDependencyProvider {
    @Inject
    private RObjectFactory rTypeBuilderFactory;
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private JavaTypeTranslator typeTranslator;

    private void javaDependencies(RosettaExpression expression, Set<JavaClass<?>> result, Set<RosettaExpression> visited) {
        if (visited.add(expression)) {
            List<RosettaSymbol> rosettaSymbols = EcoreUtil2.eAllOfType((EObject)expression, RosettaSymbolReference.class).stream().map(RosettaSymbolReference::getSymbol).toList();
            List deepFeatureCalls = EcoreUtil2.eAllOfType((EObject)expression, RosettaDeepFeatureCall.class);
            rosettaSymbols.stream().filter(s -> s instanceof Function).map(s -> this.rTypeBuilderFactory.buildRFunction((Function)s)).map(this.typeTranslator::toFunctionJavaClass).forEach(result::add);
            rosettaSymbols.stream().filter(s -> s instanceof RosettaRule).map(s -> this.rTypeBuilderFactory.buildRFunction((RosettaRule)s)).map(this.typeTranslator::toFunctionJavaClass).forEach(result::add);
            deepFeatureCalls.stream().map(dfc -> this.typeProvider.getRMetaAnnotatedType(dfc.getReceiver()).getRType()).map(t -> t instanceof RChoiceType ? ((RChoiceType)t).asRDataType() : t).filter(t -> t instanceof RDataType).map(t -> this.typeTranslator.toDeepPathUtilJavaClass((RDataType)t)).forEach(result::add);
        }
    }

    public List<JavaClass<?>> javaDependencies(RosettaExpression expression) {
        HashSet result = new HashSet();
        this.javaDependencies(expression, result, new HashSet<RosettaExpression>());
        return result.stream().sorted(Comparator.comparing(dep -> dep.getSimpleName())).toList();
    }

    public List<JavaClass<?>> javaDependencies(Iterable<? extends RosettaExpression> expressions) {
        HashSet result = new HashSet();
        HashSet visited = new HashSet();
        expressions.forEach(expr -> this.javaDependencies((RosettaExpression)expr, result, visited));
        return result.stream().sorted(Comparator.comparing(dep -> dep.getSimpleName())).toList();
    }
}

