/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.object.validators;

import com.google.common.collect.ImmutableMap;
import com.regnosys.rosetta.generator.java.object.validators.AbstractValidatorGenerator;
import com.regnosys.rosetta.generator.java.scoping.JavaClassScope;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoProperty;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.RGeneratedJavaClass;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.util.types.JavaType;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;

public class OnlyExistsValidatorGenerator
extends AbstractValidatorGenerator {
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;

    @Override
    protected RGeneratedJavaClass<?> createValidatorClass(JavaPojoInterface pojo) {
        return this._javaTypeTranslator.toOnlyExistsValidatorClass(pojo);
    }

    @Override
    protected StringConcatenationClient generateClass(final RDataType type, final RGeneratedJavaClass<?> validator, final JavaPojoInterface javaType, String version, JavaClassScope scope) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public ");
                StringConcatenationClient _asClassDeclaration = validator.asClassDeclaration();
                _builder.append((Object)_asClassDeclaration);
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"/* Casting is required to ensure types are output to ensure recompilation in Rosetta */");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public <T2 extends ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)"> ");
                _builder.append(ValidationResult.class, "\t");
                _builder.append((Object)"<");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)"> validate(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" path, T2 o, ");
                _builder.append(Set.class, "\t");
                _builder.append((Object)"<String> fields) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append(Map.class, "\t\t");
                _builder.append((Object)"<String, Boolean> fieldExistenceMap = ");
                _builder.append(ImmutableMap.class, "\t\t");
                _builder.append((Object)".<String, Boolean>builder()");
                _builder.newLineIfNotEmpty();
                Collection<RAttribute> _allAttributes = type.getAllAttributes();
                for (RAttribute attr : _allAttributes) {
                    _builder.append((Object)"\t\t\t\t");
                    JavaPojoProperty prop = javaType.findProperty(attr.getName());
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t\t");
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"o");
                        }
                    };
                    JavaExpression propCode = prop.applyGetter(JavaExpression.from(_client, (JavaType)javaType));
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append((Object)".put(\"");
                    String _name = prop.getName();
                    _builder.append((Object)_name, "\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append(ExistenceChecker.class, "\t\t\t\t");
                    _builder.append((Object)".isSet((");
                    JavaType _type = prop.getType();
                    _builder.append((Object)_type, "\t\t\t\t");
                    _builder.append((Object)") ");
                    _builder.append((Object)propCode, "\t\t\t\t");
                    _builder.append((Object)"))");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".build();");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Find the fields that are set");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(Set.class, "\t\t");
                _builder.append((Object)"<String> setFields = fieldExistenceMap.entrySet().stream()");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".filter(Map.Entry::getValue)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".map(Map.Entry::getKey)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".collect(");
                _builder.append(Collectors.class, "\t\t\t\t");
                _builder.append((Object)".toSet());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (setFields.equals(fields)) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return ");
                Method _method = OnlyExistsValidatorGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                _builder.append((Object)_method, "\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName = javaType.getRosettaName();
                _builder.append((Object)_rosettaName, "\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t");
                _builder.append((Object)".ONLY_EXISTS, \"");
                String _rosettaName_1 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_1, "\t\t\t");
                _builder.append((Object)"\", path, \"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                Method _method_1 = OnlyExistsValidatorGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                _builder.append((Object)_method_1, "\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_2 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_2, "\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t");
                _builder.append((Object)".ONLY_EXISTS, \"");
                String _rosettaName_3 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_3, "\t\t");
                _builder.append((Object)"\", path, \"\",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"String.format(\"[%s] should only be set.  Set fields: %s\", fields, setFields));");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }
}

