/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.scoping;

import com.rosetta.util.DottedPath;
import java.util.Objects;
import javax.lang.model.SourceVersion;

public class JavaPackageName {
    private final DottedPath packageName;

    private JavaPackageName(DottedPath packageName) {
        this.packageName = packageName;
    }

    public static JavaPackageName escape(DottedPath unescapedPackageName) {
        String[] escapedNames = (String[])unescapedPackageName.stream().map(n -> JavaPackageName.escape(n)).toArray(String[]::new);
        return new JavaPackageName(DottedPath.of((String[])escapedNames));
    }

    public static JavaPackageName splitOnDotsAndEscape(String unescapedPackageName) {
        return JavaPackageName.escape(DottedPath.splitOnDots((String)unescapedPackageName));
    }

    private static String escape(String name) {
        if (!SourceVersion.isIdentifier((CharSequence)name)) {
            throw new IllegalStateException("`" + (String)name + "` cannot be escaped to a valid Java identifier");
        }
        while (!SourceVersion.isName((CharSequence)name)) {
            name = "_" + (String)name;
        }
        return name;
    }

    public DottedPath getName() {
        return this.packageName;
    }

    public String toString() {
        return this.packageName.withDots();
    }

    public int hashCode() {
        return Objects.hash(this.packageName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaPackageName other = (JavaPackageName)obj;
        return Objects.equals(this.packageName, other.packageName);
    }
}

