/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.statement.builder;

import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public class JavaLiteral
extends JavaExpression {
    public static final JavaLiteral NULL = new JavaLiteral("null", (JavaType)JavaReferenceType.NULL_TYPE);
    public static final JavaLiteral TRUE = new JavaLiteral("true", (JavaType)JavaPrimitiveType.BOOLEAN);
    public static final JavaLiteral FALSE = new JavaLiteral("false", (JavaType)JavaPrimitiveType.BOOLEAN);
    private final String representation;

    public static JavaLiteral INT(int intValue) {
        return new JavaLiteral(Integer.toString(intValue), (JavaType)JavaPrimitiveType.INT);
    }

    public static JavaLiteral LONG(long longValue) {
        return new JavaLiteral(Long.toString(longValue) + "l", (JavaType)JavaPrimitiveType.LONG);
    }

    public static JavaLiteral STRING(String stringValue) {
        return new JavaLiteral("\"" + StringEscapeUtils.escapeJava((String)stringValue) + "\"", JavaType.from(String.class));
    }

    public JavaLiteral(String representation, JavaType type) {
        super(type);
        this.representation = representation;
    }

    @Override
    public void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
        target.append((Object)this.representation);
    }

    @Override
    public String toString() {
        return this.representation;
    }
}

