/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaAttributeReference;
import com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment;
import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaDataReference;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaParameter;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.RosettaTypeWithConditions;
import com.regnosys.rosetta.rosetta.RosettaTypedFeature;
import com.regnosys.rosetta.rosetta.TypeParameter;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.DefaultOperation;
import com.regnosys.rosetta.rosetta.expression.DistinctOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.FilterOperation;
import com.regnosys.rosetta.rosetta.expression.FirstOperation;
import com.regnosys.rosetta.rosetta.expression.FlattenOperation;
import com.regnosys.rosetta.rosetta.expression.JoinOperation;
import com.regnosys.rosetta.rosetta.expression.LastOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.MapOperation;
import com.regnosys.rosetta.rosetta.expression.MaxOperation;
import com.regnosys.rosetta.rosetta.expression.MinOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.ReduceOperation;
import com.regnosys.rosetta.rosetta.expression.ReverseOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSuperCall;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.SortOperation;
import com.regnosys.rosetta.rosetta.expression.SumOperation;
import com.regnosys.rosetta.rosetta.expression.SwitchCaseGuard;
import com.regnosys.rosetta.rosetta.expression.SwitchCaseOrDefault;
import com.regnosys.rosetta.rosetta.expression.SwitchOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToEnumOperation;
import com.regnosys.rosetta.rosetta.expression.ToIntOperation;
import com.regnosys.rosetta.rosetta.expression.ToNumberOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.rosetta.expression.ToTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.WithMetaEntry;
import com.regnosys.rosetta.rosetta.expression.WithMetaOperation;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.AnnotationPathExpression;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.AssignPathRoot;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.ChoiceOption;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.types.ExpectedTypeProvider;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RMetaAttribute;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeFactory;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.utils.AnnotationPathExpressionUtil;
import com.regnosys.rosetta.utils.BigDecimalInterval;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.OptionalUtil;
import com.regnosys.rosetta.utils.PositiveIntegerInterval;
import com.regnosys.rosetta.utils.RosettaExpressionSwitch;
import jakarta.inject.Inject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;

public class RosettaTypeProvider
extends RosettaExpressionSwitch<RMetaAnnotatedType, Map<RosettaSymbol, RMetaAnnotatedType>> {
    @Inject
    private RosettaEcoreUtil extensions;
    @Inject
    private ImplicitVariableUtil implicitVariableUtil;
    @Inject
    private TypeSystem typeSystem;
    @Inject
    private TypeFactory typeFactory;
    @Inject
    private RBuiltinTypeService builtins;
    @Inject
    private RObjectFactory rObjectFactory;
    @Inject
    private ExpectedTypeProvider expectedTypeProvider;
    @Inject
    private AnnotationPathExpressionUtil annotationPathUtil;

    public RMetaAnnotatedType getRMetaAnnotatedType(RosettaExpression expression) {
        return this.safeRType(expression, new HashMap<RosettaSymbol, RMetaAnnotatedType>());
    }

    public RMetaAnnotatedType getRTypeOfFeature(RosettaFeature feature, EObject context) {
        return this.safeRType(feature, context, new HashMap<RosettaSymbol, RMetaAnnotatedType>());
    }

    public RMetaAnnotatedType getRTypeOfSymbol(RosettaSymbol symbol, EObject context) {
        return this.safeRType(symbol, context, new HashMap<RosettaSymbol, RMetaAnnotatedType>());
    }

    public RMetaAnnotatedType getRTypeOfSymbol(TypeParameter feature) {
        return this.getRTypeOfSymbol(feature, null);
    }

    public RMetaAnnotatedType getRTypeOfSymbol(AssignPathRoot feature) {
        return this.getRTypeOfSymbol(feature, null);
    }

    public RMetaAnnotatedType getRTypeOfSymbol(RosettaCallableWithArgs feature) {
        return this.getRTypeOfSymbol(feature, null);
    }

    public RType getRTypeOfAttributeReference(RosettaAttributeReferenceSegment seg) {
        if (seg instanceof RosettaAttributeReference) {
            RosettaAttributeReference attrRef = (RosettaAttributeReference)seg;
            return this.typeSystem.typeCallToRType(attrRef.getAttribute().getTypeCall());
        }
        if (seg instanceof RosettaDataReference) {
            RosettaDataReference dataRef = (RosettaDataReference)seg;
            if (this.extensions.isResolved(dataRef.getData())) {
                return this.rObjectFactory.buildRDataType(dataRef.getData());
            }
            return this.builtins.NOTHING;
        }
        return this.builtins.NOTHING;
    }

    public Iterable<? extends RosettaFeature> findFeaturesOfImplicitVariable(EObject context) {
        return this.extensions.allFeaturesExcludingEnumValues(this.typeOfImplicitVariable(context), context);
    }

    public RMetaAnnotatedType getRMetaAnnotatedType(AnnotationPathExpression expr) {
        return this.getRTypeOfSymbol(this.annotationPathUtil.getTargetAttribute(expr));
    }

    public List<RMetaAttribute> getRMetaAttributesOfSymbol(RosettaSymbol symbol) {
        HashSet<RMetaAttribute> acc = new HashSet<RMetaAttribute>();
        if (symbol instanceof Attribute) {
            RosettaType attributeType;
            Attribute a = (Attribute)symbol;
            if (a.isOverride()) {
                acc.addAll(this.getRMetaAttributesOfSymbol(this.extensions.getParentAttribute(a)));
                acc.addAll(this.getRMetaAttributes((List<AnnotationRef>)a.getAnnotations()));
            }
            if ((attributeType = a.getTypeCall().getType()) instanceof Data) {
                Data data = (Data)attributeType;
                acc.addAll(this.getRMetaAttributesOfType(data));
            }
        }
        if (symbol instanceof Annotated) {
            Annotated ann = (Annotated)((Object)symbol);
            acc.addAll(this.getRMetaAttributes((List<AnnotationRef>)ann.getAnnotations()));
        }
        return new ArrayList<RMetaAttribute>(acc);
    }

    public List<RMetaAttribute> getRMetaAttributesOfFeature(RosettaFeature feature) {
        if (feature instanceof RosettaSymbol) {
            RosettaSymbol s = (RosettaSymbol)((Object)feature);
            return this.getRMetaAttributesOfSymbol(s);
        }
        if (feature instanceof Annotated) {
            Annotated ann = (Annotated)((Object)feature);
            return this.getRMetaAttributes((List<AnnotationRef>)ann.getAnnotations());
        }
        return List.of();
    }

    public List<RMetaAttribute> getRMetaAttributesOfType(Data data) {
        HashSet allAnnotations = new HashSet();
        HashSet<Data> visited = new HashSet<Data>();
        Data current = data;
        while (current != null && visited.add(current)) {
            allAnnotations.addAll(current.getAnnotations());
            Data superType = current.getSuperType();
            if (superType != null && !this.extensions.isResolved(superType)) break;
            current = superType;
        }
        return this.getRMetaAttributes(new ArrayList<AnnotationRef>(allAnnotations));
    }

    public List<RMetaAttribute> getRMetaAttributes(List<AnnotationRef> annotations) {
        ArrayList<RMetaAttribute> res = new ArrayList<RMetaAttribute>();
        for (AnnotationRef a : annotations) {
            if (!this.extensions.isResolved(a.getAnnotation()) || !"metadata".equals(a.getAnnotation().getName()) || !this.extensions.isResolved(a.getAttribute())) continue;
            RMetaAnnotatedType attrType = this.getRTypeOfSymbol(a.getAttribute());
            res.add(new RMetaAttribute(a.getAttribute().getName(), attrType.getRType()));
        }
        return res;
    }

    public RMetaAnnotatedType typeOfImplicitVariable(EObject context) {
        return this.safeTypeOfImplicitVariable(context, new HashMap<RosettaSymbol, RMetaAnnotatedType>());
    }

    private RMetaAnnotatedType safeRType(RosettaSymbol symbol, EObject context, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RMetaAnnotatedType result;
        if (!this.extensions.isResolved(symbol)) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        RMetaAnnotatedType existing = cycleTracker.get(symbol);
        if (existing != null) {
            return existing;
        }
        cycleTracker.put(symbol, this.builtins.NOTHING_WITH_ANY_META);
        if (symbol instanceof RosettaFeature) {
            RosettaFeature f = (RosettaFeature)((Object)symbol);
            result = this.safeRType(f, context, cycleTracker);
        } else if (symbol instanceof RosettaParameter) {
            RosettaParameter p = (RosettaParameter)symbol;
            result = RMetaAnnotatedType.withNoMeta(this.typeSystem.typeCallToRType(p.getTypeCall()));
        } else if (symbol instanceof ClosureParameter) {
            RosettaFunctionalOperation setOp;
            ClosureParameter cp = (ClosureParameter)symbol;
            RosettaFunctionalOperation rosettaFunctionalOperation = setOp = cp.getFunction() == null ? null : (RosettaFunctionalOperation)cp.getFunction().eContainer();
            result = setOp != null ? this.safeRType(setOp.getArgument(), cycleTracker) : this.builtins.NOTHING_WITH_ANY_META;
        } else if (symbol instanceof RosettaEnumeration) {
            RosettaEnumeration e = (RosettaEnumeration)symbol;
            result = RMetaAnnotatedType.withMeta(this.rObjectFactory.buildREnumType(e), this.getRMetaAttributesOfSymbol(symbol));
        } else if (symbol instanceof Function) {
            Function func = (Function)symbol;
            Attribute out = func.getOutput();
            result = out != null ? this.safeRType(out, context, cycleTracker) : this.builtins.NOTHING_WITH_ANY_META;
        } else if (symbol instanceof RosettaRule) {
            RosettaRule rule = (RosettaRule)symbol;
            RosettaExpression e = rule.getExpression();
            result = e != null ? this.safeRType(e, cycleTracker) : this.builtins.NOTHING_WITH_ANY_META;
        } else if (symbol instanceof RosettaExternalFunction) {
            RosettaExternalFunction extFunc = (RosettaExternalFunction)symbol;
            result = RMetaAnnotatedType.withNoMeta(this.typeSystem.typeCallToRType(extFunc.getTypeCall()));
        } else if (symbol instanceof ShortcutDeclaration) {
            ShortcutDeclaration alias = (ShortcutDeclaration)symbol;
            result = this.safeRType(alias.getExpression(), cycleTracker);
        } else if (symbol instanceof TypeParameter) {
            TypeParameter tp = (TypeParameter)symbol;
            result = RMetaAnnotatedType.withNoMeta(this.typeSystem.typeCallToRType(tp.getTypeCall()));
        } else {
            result = this.builtins.NOTHING_WITH_ANY_META;
        }
        cycleTracker.put(symbol, result);
        return result;
    }

    private RMetaAnnotatedType safeRType(RosettaFeature feature, EObject context, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        if (!this.extensions.isResolved(feature)) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        if (feature instanceof RosettaTypedFeature) {
            RosettaTypedFeature tf = (RosettaTypedFeature)feature;
            if (tf.getTypeCall() == null) {
                return this.builtins.NOTHING_WITH_ANY_META;
            }
            return RMetaAnnotatedType.withMeta(this.typeSystem.typeCallToRType(tf.getTypeCall()), this.getRMetaAttributesOfFeature(feature));
        }
        if (feature instanceof RosettaEnumValue) {
            if (context instanceof RosettaFeatureCall) {
                RosettaFeatureCall fc = (RosettaFeatureCall)context;
                return this.safeRType(fc.getReceiver(), cycleTracker);
            }
            RMetaAnnotatedType fromContainer = this.expectedTypeProvider.getExpectedTypeFromContainer(context);
            return fromContainer != null ? fromContainer : this.builtins.NOTHING_WITH_ANY_META;
        }
        return this.builtins.NOTHING_WITH_ANY_META;
    }

    private RMetaAnnotatedType safeRType(RosettaExpression expression, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        if (expression == null) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        return (RMetaAnnotatedType)this.doSwitch(expression, cycleTracker);
    }

    private RMetaAnnotatedType safeTypeOfImplicitVariable(EObject context, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        Optional<? extends EObject> definingContainer = this.implicitVariableUtil.findContainerDefiningImplicitVariable(context);
        return definingContainer.map(it -> {
            SwitchCaseOrDefault sc;
            SwitchCaseGuard guard;
            if (it instanceof RosettaTypeWithConditions) {
                if (it instanceof Data) {
                    Data data = (Data)it;
                    return RMetaAnnotatedType.withNoMeta(this.rObjectFactory.buildRDataType(data));
                }
                if (it instanceof RosettaTypeAlias) {
                    RosettaTypeAlias alias = (RosettaTypeAlias)it;
                    return RMetaAnnotatedType.withNoMeta(this.typeSystem.typeWithUnknownArgumentsToRType(alias));
                }
                return this.builtins.NOTHING_WITH_ANY_META;
            }
            if (it instanceof RosettaFunctionalOperation) {
                RosettaFunctionalOperation fo = (RosettaFunctionalOperation)it;
                return this.safeRType(fo.getArgument(), cycleTracker);
            }
            if (it instanceof RosettaRule) {
                RosettaRule rule = (RosettaRule)it;
                return RMetaAnnotatedType.withNoMeta(this.typeSystem.getRuleInputType(rule));
            }
            if (it instanceof SwitchCaseOrDefault && (guard = (sc = (SwitchCaseOrDefault)it).getGuard()) != null) {
                ChoiceOption choiceOption = guard.getChoiceOptionGuard();
                if (choiceOption != null) {
                    return this.getRTypeOfSymbol(choiceOption, context);
                }
                Data data = guard.getDataGuard();
                if (data != null) {
                    return RMetaAnnotatedType.withNoMeta(this.rObjectFactory.buildRDataType(data));
                }
            }
            return this.builtins.NOTHING_WITH_ANY_META;
        }).orElse(this.builtins.NOTHING_WITH_ANY_META);
    }

    @Override
    protected RMetaAnnotatedType caseAbsentOperation(RosettaAbsentExpression expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseAddOperation(ArithmeticOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RMetaAnnotatedType left = this.safeRType(expr.getLeft(), cycleTracker);
        RMetaAnnotatedType right = this.safeRType(expr.getRight(), cycleTracker);
        if (this.typeSystem.isSubtypeOf(left, this.builtins.NOTHING_WITH_ANY_META)) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        if (this.typeSystem.isSubtypeOf(left, this.builtins.DATE_WITH_NO_META)) {
            return this.builtins.DATE_TIME_WITH_NO_META;
        }
        if (this.typeSystem.isSubtypeOf(left, this.builtins.UNCONSTRAINED_STRING_WITH_NO_META)) {
            return this.typeSystem.keepTypeAliasIfPossibleWithAnyMeta(left.getRType(), right.getRType(), (l, r) -> {
                if (l instanceof RStringType) {
                    RStringType s1 = (RStringType)l;
                    if (r instanceof RStringType) {
                        RStringType s2 = (RStringType)r;
                        PositiveIntegerInterval newInterval = s1.getInterval().add(s2.getInterval());
                        return new RStringType(newInterval, Optional.empty());
                    }
                }
                return this.builtins.NOTHING;
            });
        }
        if (this.typeSystem.isSubtypeOf(left, this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META)) {
            return this.typeSystem.keepTypeAliasIfPossibleWithAnyMeta(left.getRType(), right.getRType(), (l, r) -> {
                if (l instanceof RNumberType) {
                    RNumberType n1 = (RNumberType)l;
                    if (r instanceof RNumberType) {
                        RNumberType n2 = (RNumberType)r;
                        Optional<Integer> newFractional = OptionalUtil.zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), Math::max);
                        BigDecimalInterval newInterval = n1.getInterval().add(n2.getInterval());
                        return new RNumberType(Optional.empty(), newFractional, newInterval, Optional.empty());
                    }
                }
                return this.builtins.NOTHING;
            });
        }
        return this.builtins.NOTHING_WITH_ANY_META;
    }

    @Override
    protected RMetaAnnotatedType caseAndOperation(LogicalOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseAsKeyOperation(AsKeyOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseBooleanLiteral(RosettaBooleanLiteral expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseChoiceOperation(ChoiceOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseConditionalExpression(RosettaConditionalExpression expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RMetaAnnotatedType elseT;
        RMetaAnnotatedType ifT = this.safeRType(expr.getIfthen(), cycleTracker);
        RMetaAnnotatedType joined = this.typeSystem.joinMetaAnnotatedTypes(ifT, elseT = this.safeRType(expr.getElsethen(), cycleTracker));
        if (this.typeSystem.isSubtypeOf(this.builtins.ANY_WITH_NO_META, joined)) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        return joined;
    }

    @Override
    protected RMetaAnnotatedType caseContainsOperation(RosettaContainsExpression expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseDefaultOperation(DefaultOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RMetaAnnotatedType right;
        RMetaAnnotatedType left = this.safeRType(expr.getLeft(), cycleTracker);
        RMetaAnnotatedType result = this.typeSystem.joinMetaAnnotatedTypes(left, right = this.safeRType(expr.getRight(), cycleTracker));
        if (this.typeSystem.isSubtypeOf(this.builtins.ANY_WITH_NO_META, result)) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        return result;
    }

    @Override
    protected RMetaAnnotatedType caseCountOperation(RosettaCountOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return RMetaAnnotatedType.withNoMeta(this.typeFactory.constrainedInt(Optional.empty(), Optional.of(BigInteger.ZERO), Optional.empty()));
    }

    @Override
    protected RMetaAnnotatedType caseDisjointOperation(RosettaDisjointExpression expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseDistinctOperation(DistinctOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseDivideOperation(ArithmeticOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseEqualsOperation(EqualityOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseExistsOperation(RosettaExistsExpression expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseFeatureCall(RosettaFeatureCall expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RosettaFeature feature = expr.getFeature();
        if (!this.extensions.isResolved(feature)) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        if (feature instanceof RosettaEnumValue) {
            return this.safeRType(expr.getReceiver(), cycleTracker);
        }
        return this.safeRType(feature, (EObject)expr, cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseDeepFeatureCall(RosettaDeepFeatureCall expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        Attribute feature = expr.getFeature();
        if (!this.extensions.isResolved(feature)) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        return this.safeRType(feature, (EObject)expr, cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseFilterOperation(FilterOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseFirstOperation(FirstOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseFlattenOperation(FlattenOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseGreaterThanOperation(ComparisonOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseGreaterThanOrEqualOperation(ComparisonOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseImplicitVariable(RosettaImplicitVariable expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeTypeOfImplicitVariable(expr, cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseIntLiteral(RosettaIntLiteral expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        int len = expr.getValue().signum() >= 0 ? expr.getValue().toString().length() : expr.getValue().toString().length() - 1;
        return RMetaAnnotatedType.withNoMeta(this.typeFactory.constrainedInt(len, expr.getValue(), expr.getValue()));
    }

    @Override
    protected RMetaAnnotatedType caseJoinOperation(JoinOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseLastOperation(LastOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseLessThanOperation(ComparisonOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseLessThanOrEqualOperation(ComparisonOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseListLiteral(ListLiteral expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        ArrayList<RMetaAnnotatedType> types = new ArrayList<RMetaAnnotatedType>();
        for (RosettaExpression e : expr.getElements()) {
            RMetaAnnotatedType t = this.safeRType(e, cycleTracker);
            if (t == null) continue;
            types.add(t);
        }
        RMetaAnnotatedType joined = this.typeSystem.joinMetaAnnotatedTypes(types);
        if (this.typeSystem.isSubtypeOf(this.builtins.ANY_WITH_NO_META, joined)) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        return joined;
    }

    @Override
    protected RMetaAnnotatedType caseMapOperation(MapOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RosettaExpression body = expr.getFunction() != null ? expr.getFunction().getBody() : null;
        return body != null ? this.safeRType(body, cycleTracker) : this.builtins.NOTHING_WITH_ANY_META;
    }

    @Override
    protected RMetaAnnotatedType caseMaxOperation(MaxOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseMinOperation(MinOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseMultiplyOperation(ArithmeticOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RMetaAnnotatedType left = this.safeRType(expr.getLeft(), cycleTracker);
        RMetaAnnotatedType right = this.safeRType(expr.getRight(), cycleTracker);
        return this.typeSystem.keepTypeAliasIfPossibleWithAnyMeta(left.getRType(), right.getRType(), (l, r) -> {
            if (l instanceof RNumberType) {
                RNumberType n1 = (RNumberType)l;
                if (r instanceof RNumberType) {
                    RNumberType n2 = (RNumberType)r;
                    Optional<Integer> newFractional = OptionalUtil.zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), Integer::sum);
                    BigDecimalInterval newInterval = n1.getInterval().multiply(n2.getInterval());
                    return new RNumberType(Optional.empty(), newFractional, newInterval, Optional.empty());
                }
            }
            return this.builtins.NOTHING;
        });
    }

    @Override
    protected RMetaAnnotatedType caseNotEqualsOperation(EqualityOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseNumberLiteral(RosettaNumberLiteral expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        if (expr.getValue() == null) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        String plain = expr.getValue().toPlainString();
        int digits = plain.replaceAll("[.\\-]", "").length();
        int scale = Math.max(0, expr.getValue().scale());
        return RMetaAnnotatedType.withNoMeta(this.typeFactory.constrainedNumber(digits, scale, expr.getValue(), expr.getValue()));
    }

    @Override
    protected RMetaAnnotatedType caseOneOfOperation(OneOfOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseOnlyElementOperation(RosettaOnlyElement expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseOnlyExists(RosettaOnlyExistsExpression expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseOrOperation(LogicalOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.BOOLEAN_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseReduceOperation(ReduceOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RosettaExpression body = expr.getFunction() != null ? expr.getFunction().getBody() : null;
        return body != null ? this.safeRType(body, cycleTracker) : this.builtins.NOTHING_WITH_ANY_META;
    }

    @Override
    protected RMetaAnnotatedType caseReverseOperation(ReverseOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseSortOperation(SortOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseStringLiteral(RosettaStringLiteral expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return RMetaAnnotatedType.withNoMeta(this.typeFactory.constrainedString(expr.getValue().length(), expr.getValue().length()));
    }

    @Override
    protected RMetaAnnotatedType caseSubtractOperation(ArithmeticOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RMetaAnnotatedType left = this.safeRType(expr.getLeft(), cycleTracker);
        RMetaAnnotatedType right = this.safeRType(expr.getRight(), cycleTracker);
        if (this.typeSystem.isSubtypeOf(left, this.builtins.NOTHING_WITH_ANY_META)) {
            return this.builtins.NOTHING_WITH_ANY_META;
        }
        if (this.typeSystem.isSubtypeOf(left, this.builtins.DATE_WITH_NO_META)) {
            return this.builtins.UNCONSTRAINED_INT_WITH_NO_META;
        }
        if (this.typeSystem.isSubtypeOf(left, this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META)) {
            return this.typeSystem.keepTypeAliasIfPossibleWithAnyMeta(left.getRType(), right.getRType(), (l, r) -> {
                if (l instanceof RNumberType) {
                    RNumberType n1 = (RNumberType)l;
                    if (r instanceof RNumberType) {
                        RNumberType n2 = (RNumberType)r;
                        Optional<Integer> newFractional = OptionalUtil.zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), Math::max);
                        BigDecimalInterval newInterval = n1.getInterval().subtract(n2.getInterval());
                        return new RNumberType(Optional.empty(), newFractional, newInterval, Optional.empty());
                    }
                }
                return this.builtins.NOTHING;
            });
        }
        return this.builtins.NOTHING_WITH_ANY_META;
    }

    @Override
    protected RMetaAnnotatedType caseSumOperation(SumOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getArgument(), cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseSymbolReference(RosettaSymbolReference expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RosettaSymbol rosettaSymbol = expr.getSymbol();
        if (rosettaSymbol instanceof RosettaExternalFunction) {
            RosettaExternalFunction fun = (RosettaExternalFunction)rosettaSymbol;
            RMetaAnnotatedType returnType = this.safeRType(fun, (EObject)expr, cycleTracker);
            ArrayList<RMetaAnnotatedType> argTypes = new ArrayList<RMetaAnnotatedType>();
            for (RosettaExpression arg : expr.getArgs()) {
                argTypes.add(this.safeRType(arg, cycleTracker));
            }
            boolean allSub = argTypes.stream().allMatch(a -> this.typeSystem.isSubtypeOf((RMetaAnnotatedType)a, returnType));
            if (allSub) {
                return this.typeSystem.joinMetaAnnotatedTypes(argTypes);
            }
            return returnType;
        }
        return this.safeRType(expr.getSymbol(), (EObject)expr, cycleTracker);
    }

    @Override
    protected RMetaAnnotatedType caseThenOperation(ThenOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RosettaExpression body = expr.getFunction() != null ? expr.getFunction().getBody() : null;
        return body != null ? this.safeRType(body, cycleTracker) : this.builtins.NOTHING_WITH_ANY_META;
    }

    @Override
    protected RMetaAnnotatedType caseToEnumOperation(ToEnumOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return RMetaAnnotatedType.withNoMeta(this.rObjectFactory.buildREnumType(expr.getEnumeration()));
    }

    @Override
    protected RMetaAnnotatedType caseToIntOperation(ToIntOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.UNCONSTRAINED_INT_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseToNumberOperation(ToNumberOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseToStringOperation(ToStringOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseToTimeOperation(ToTimeOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.TIME_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseConstructorExpression(RosettaConstructorExpression expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return RMetaAnnotatedType.withNoMeta(this.typeSystem.typeCallToRType(expr.getTypeCall()));
    }

    @Override
    protected RMetaAnnotatedType caseToDateOperation(ToDateOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.DATE_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseToDateTimeOperation(ToDateTimeOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.DATE_TIME_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseToZonedDateTimeOperation(ToZonedDateTimeOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.builtins.ZONED_DATE_TIME_WITH_NO_META;
    }

    @Override
    protected RMetaAnnotatedType caseSwitchOperation(SwitchOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        ArrayList<RMetaAnnotatedType> caseTypes = new ArrayList<RMetaAnnotatedType>();
        for (SwitchCaseOrDefault c : expr.getCases()) {
            caseTypes.add(this.safeRType(c.getExpression(), cycleTracker));
        }
        return this.typeSystem.joinMetaAnnotatedTypes(caseTypes);
    }

    @Override
    protected RMetaAnnotatedType caseWithMetaOperation(WithMetaOperation expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        RMetaAnnotatedType argType = this.safeRType(expr.getArgument(), cycleTracker);
        List<RMetaAttribute> newMetaAttributes = expr.getEntries().stream().map(WithMetaEntry::getKey).filter(f -> this.extensions.isResolved((EObject)f)).map(f -> new RMetaAttribute(f.getName(), this.getRTypeOfFeature((RosettaFeature)f, null).getRType())).toList();
        return argType.addMeta(newMetaAttributes);
    }

    @Override
    protected RMetaAnnotatedType caseSuperCall(RosettaSuperCall expr, Map<RosettaSymbol, RMetaAnnotatedType> cycleTracker) {
        return this.safeRType(expr.getSuperFunction(), (EObject)expr, cycleTracker);
    }
}

