/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import com.regnosys.rosetta.validation.CycleValidationHelper;
import jakarta.inject.Inject;
import java.util.HashSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class EnumValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RosettaEcoreUtil ecoreUtil;
    @Inject
    private CycleValidationHelper cycleValidationHelper;

    @Check
    public void checkEnumNameIsCapitalized(RosettaEnumeration enumeration) {
        String name = enumeration.getName();
        if (name != null && Character.isLowerCase(name.charAt(0))) {
            this.warning("Enumeration name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkCyclicExtensions(RosettaEnumeration enumeration) {
        this.cycleValidationHelper.detectCycle(enumeration, RosettaEnumeration::getParent, "extends", pathMsg -> this.error("Cyclic extension: " + pathMsg, enumeration, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_ENUMERATION__PARENT));
    }

    @Check
    public void checkEnumValuesAreUnique(RosettaEnumeration enumeration) {
        HashSet<String> usedNames = new HashSet<String>();
        if (enumeration.getParent() != null) {
            this.ecoreUtil.getAllEnumValues(enumeration.getParent()).forEach(v -> usedNames.add(v.getName()));
        }
        for (RosettaEnumValue value : enumeration.getEnumValues()) {
            if (usedNames.add(value.getName())) continue;
            this.error("Duplicate enum value '" + value.getName() + "'", value, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
    }
}

