/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.ExternalAnnotationSource;
import com.regnosys.rosetta.rosetta.Import;
import com.regnosys.rosetta.rosetta.ParametrizedRosettaType;
import com.regnosys.rosetta.rosetta.RosettaAttributeReference;
import com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment;
import com.regnosys.rosetta.rosetta.RosettaEnumSynonym;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumValueReference;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalRef;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonym;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaMapPathValue;
import com.regnosys.rosetta.rosetta.RosettaMapTestExpression;
import com.regnosys.rosetta.rosetta.RosettaMapping;
import com.regnosys.rosetta.rosetta.RosettaMappingInstance;
import com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue;
import com.regnosys.rosetta.rosetta.RosettaMetaType;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaSynonym;
import com.regnosys.rosetta.rosetta.RosettaSynonymBody;
import com.regnosys.rosetta.rosetta.RosettaSynonymValueBase;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTyped;
import com.regnosys.rosetta.rosetta.TypeParameter;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.FilterOperation;
import com.regnosys.rosetta.rosetta.expression.FlattenOperation;
import com.regnosys.rosetta.rosetta.expression.HasGeneratedInput;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.ListOperation;
import com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.MapOperation;
import com.regnosys.rosetta.rosetta.expression.ReduceOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation;
import com.regnosys.rosetta.rosetta.expression.SumOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.AnnotationQualifier;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.FunctionDispatch;
import com.regnosys.rosetta.rosetta.simple.LabelAnnotation;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.scoping.RosettaScopeProvider;
import com.regnosys.rosetta.services.RosettaGrammarAccess;
import com.regnosys.rosetta.types.CardinalityProvider;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.ImportManagementService;
import com.regnosys.rosetta.utils.RosettaConfigExtension;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import jakarta.inject.Inject;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Deprecated
public class RosettaSimpleValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RosettaEcoreUtil rosettaEcoreUtil;
    @Inject
    private RosettaTypeProvider rosettaTypeProvider;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private RosettaFunctionExtensions rosettaFunctionExtensions;
    @Inject
    private ExpressionHelper exprHelper;
    @Inject
    private CardinalityProvider cardinality;
    @Inject
    private RosettaConfigExtension confExtensions;
    @Inject
    private ImplicitVariableUtil implicitVariableUtil;
    @Inject
    private RosettaScopeProvider scopeProvider;
    @Inject
    private RBuiltinTypeService builtinTypeService;
    @Inject
    private TypeSystem typeSystem;
    @Inject
    private RosettaGrammarAccess grammarAccess;
    @Inject
    private RObjectFactory objectFactory;
    @Inject
    private ImportManagementService importManagementService;

    @Check
    public void deprecatedWarning(EObject object) {
        EList features = object.eClass().getEAllStructuralFeatures();
        EStructuralFeature[] crossReferencesArray = ((EClassImpl.FeatureSubsetSupplier)features).crossReferences();
        List crossRefs = (List)Conversions.doWrapArray((Object)crossReferencesArray);
        if (crossRefs != null) {
            for (EReference ref : crossRefs) {
                if (ref.isMany()) {
                    Object eGet = object.eGet((EStructuralFeature)ref);
                    Iterable annotatedList = Iterables.filter((Iterable)((List)eGet), Annotated.class);
                    List annotatedArray = IterableExtensions.toList((Iterable)annotatedList);
                    for (int i = 0; i < annotatedArray.size(); ++i) {
                        this.checkDeprecatedAnnotation((Annotated)annotatedArray.get(i), object, (EStructuralFeature)ref, i);
                    }
                    continue;
                }
                Object annotated = object.eGet((EStructuralFeature)ref);
                if (!(annotated instanceof Annotated)) continue;
                this.checkDeprecatedAnnotation((Annotated)annotated, object, (EStructuralFeature)ref, -1);
            }
        }
    }

    @Check
    public void deprecatedLabelAsWarning(LabelAnnotation labelAnnotation) {
        if (labelAnnotation.isDeprecatedAs()) {
            if (labelAnnotation.getPath() == null) {
                this.warning("The `as` keyword without a path is deprecated", labelAnnotation, (EStructuralFeature)SimplePackage.Literals.LABEL_ANNOTATION__DEPRECATED_AS);
            } else {
                this.warning("The `as` keyword after a path is deprecated. Add the keyword `for` before the path instead", labelAnnotation, (EStructuralFeature)SimplePackage.Literals.LABEL_ANNOTATION__DEPRECATED_AS);
            }
        }
    }

    @Check
    public void ruleMustHaveInputTypeDeclared(RosettaRule rule) {
        if (rule.getInput() == null) {
            this.error("A rule must declare its input type: `rule " + rule.getName() + " from <input type>: ...`", rule, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
        if (this.cardinality.isOutputListOfLists(rule.getExpression())) {
            this.error("Assign expression contains a list of lists, use flatten to create a list.", rule.getExpression(), null);
        }
    }

    @Check
    public void unnecesarrySquareBracketsCheck(RosettaFunctionalOperation op) {
        if (this.hasSquareBrackets(op) && !this.areSquareBracketsMandatory(op)) {
            this.warning("Usage of brackets is unnecessary.", op.getFunction(), null, "RosettaIssueCodes.redundantSquareBrackets", new String[0]);
        }
    }

    public boolean hasSquareBrackets(RosettaFunctionalOperation op) {
        return op.getFunction() != null && this.findDirectKeyword((EObject)op.getFunction(), this.grammarAccess.getInlineFunctionAccess().getLeftSquareBracketKeyword_0_0_1()) != null;
    }

    public boolean areSquareBracketsMandatory(RosettaFunctionalOperation op) {
        if (op instanceof ThenOperation || op.getFunction() == null) {
            return false;
        }
        boolean condition1 = !(op instanceof MandatoryFunctionalOperation) || !op.getFunction().getParameters().isEmpty();
        boolean condition2 = this.containsNestedFunctionalOperation(op);
        boolean condition3 = op.eContainer() instanceof RosettaOperation && !(op.eContainer() instanceof ThenOperation);
        return condition1 || condition2 || condition3;
    }

    @Check
    public void mandatoryThenCheck(RosettaUnaryOperation op) {
        if (this.isThenMandatory(op)) {
            boolean previousOperationIsThen;
            boolean bl = previousOperationIsThen = op.getArgument().isGenerated() && op.eContainer() instanceof InlineFunction && op.eContainer().eContainer() instanceof ThenOperation;
            if (!previousOperationIsThen) {
                this.error("Usage of `then` is mandatory.", op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR, "RosettaIssueCodes.mandatoryThen", new String[0]);
            }
        }
    }

    public boolean isThenMandatory(RosettaUnaryOperation op) {
        if (op instanceof ThenOperation) {
            return false;
        }
        if (op.getArgument() instanceof MandatoryFunctionalOperation) {
            return true;
        }
        if (op.getArgument() instanceof RosettaUnaryOperation) {
            return this.isThenMandatory((RosettaUnaryOperation)op.getArgument());
        }
        return false;
    }

    @Check
    public void ambiguousFunctionalOperation(RosettaFunctionalOperation op) {
        InlineFunction inlineFunction;
        RosettaFunctionalOperation enclosingFunctionalOperation;
        if (op.getFunction() != null && this.isNestedFunctionalOperation(op) && !this.hasSquareBrackets(enclosingFunctionalOperation = (RosettaFunctionalOperation)(inlineFunction = (InlineFunction)EcoreUtil2.getContainerOfType((EObject)op, InlineFunction.class)).eContainer())) {
            this.error("Ambiguous operation. Either use `then` or surround with square brackets to define a nested operation.", op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    public boolean isNestedFunctionalOperation(RosettaFunctionalOperation op) {
        EObject functionCodeBlock;
        EObject opCodeBlock;
        InlineFunction enclosingInlineFunction = (InlineFunction)EcoreUtil2.getContainerOfType((EObject)op, InlineFunction.class);
        return enclosingInlineFunction != null && !(enclosingInlineFunction.eContainer() instanceof ThenOperation) && (opCodeBlock = this.getEnclosingCodeBlock(op)) == (functionCodeBlock = this.getEnclosingCodeBlock(enclosingInlineFunction));
    }

    public boolean containsNestedFunctionalOperation(RosettaFunctionalOperation op) {
        if (op.getFunction() == null) {
            return false;
        }
        EObject codeBlock = this.getEnclosingCodeBlock(op.getFunction());
        List allOperations = EcoreUtil2.eAllOfType((EObject)op.getFunction(), RosettaFunctionalOperation.class);
        for (RosettaFunctionalOperation operation : allOperations) {
            if (this.getEnclosingCodeBlock(operation) != codeBlock) continue;
            return true;
        }
        return false;
    }

    public EObject getEnclosingCodeBlock(EObject obj) {
        return this.getEnclosingCodeBlock((INode)NodeModelUtils.findActualNodeFor((EObject)obj), obj);
    }

    private EObject getEnclosingCodeBlock(INode node, EObject potentialCodeBlock) {
        if (potentialCodeBlock instanceof RosettaRootElement) {
            return potentialCodeBlock;
        }
        HashMap<String, String> pairs = new HashMap<String, String>();
        pairs.put("(", ")");
        pairs.put("[", "]");
        pairs.put("{", "}");
        INode leftBracket = null;
        for (String leftBracketText : pairs.keySet()) {
            INode foundNode = this.findDirectKeyword(potentialCodeBlock, leftBracketText);
            if (foundNode == null) continue;
            leftBracket = foundNode;
            break;
        }
        if (leftBracket != null) {
            boolean isWithinBrackets;
            String rightBracketText = (String)pairs.get(leftBracket.getText());
            INode rightBracket = this.findDirectKeyword(potentialCodeBlock, rightBracketText);
            boolean bl = isWithinBrackets = leftBracket.getOffset() <= node.getOffset() && (rightBracket == null || rightBracket.getOffset() >= node.getOffset());
            if (isWithinBrackets) {
                return potentialCodeBlock;
            }
        }
        return this.getEnclosingCodeBlock(node, potentialCodeBlock.eContainer());
    }

    @Check
    public void checkParametrizedType(ParametrizedRosettaType type) {
        HashSet<String> visited = new HashSet<String>();
        for (TypeParameter param : type.getParameters()) {
            if (visited.add(param.getName())) continue;
            this.error("Duplicate parameter name `" + param.getName() + "`.", param, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
    }

    @Check
    public void checkAnnotationSource(ExternalAnnotationSource source) {
        HashSet<RosettaType> visited = new HashSet<RosettaType>();
        for (RosettaExternalRef t : source.getExternalRefs()) {
            if (visited.add(t.getTypeRef())) continue;
            this.warning("Duplicate type `" + t.getTypeRef().getName() + "`.", t, null);
        }
    }

    @Check
    public void checkSynonymSource(RosettaExternalSynonymSource source) {
        for (RosettaExternalClass t : source.getExternalClasses()) {
            for (RosettaExternalRegularAttribute attr : t.getRegularAttributes()) {
                attr.getExternalRuleReferences().forEach(it -> this.error("You may not define rule references in a synonym source.", (EObject)it, null));
            }
        }
    }

    @Check
    public void checkRuleSource(RosettaExternalRuleSource source) {
        if (source.getSuperSources().size() > 1) {
            this.error("A rule source may not extend more than one other rule source.", source, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES, 1);
        }
        for (RosettaExternalClass t : source.getExternalClasses()) {
            t.getExternalClassSynonyms().forEach(it -> this.error("You may not define synonyms in a rule source.", (EObject)it, null));
            for (RosettaExternalRegularAttribute attr : t.getRegularAttributes()) {
                attr.getExternalSynonyms().forEach(it -> this.error("You may not define synonyms in a rule source.", (EObject)it, null));
            }
        }
        this.errorKeyword("A rule source cannot define annotations for enums.", (EObject)source, this.grammarAccess.getExternalAnnotationSourceAccess().getEnumsKeyword_2_0());
    }

    @Check
    public void checkGeneratedInputInContextWithImplicitVariable(HasGeneratedInput e) {
        if (e.needsGeneratedInput() && !this.implicitVariableUtil.implicitVariableExistsInContext(e)) {
            this.error("There is no implicit variable in this context. This operator needs an explicit input in this context.", e, null);
        }
    }

    @Check
    public void checkImplicitVariableReferenceInContextWithoutImplicitVariable(RosettaImplicitVariable e) {
        if (!this.implicitVariableUtil.implicitVariableExistsInContext(e)) {
            this.error("There is no implicit variable in this context.", e, null);
        }
    }

    @Check
    public void checkConditionName(Condition condition) {
        if (condition.getName() == null && !this.rosettaEcoreUtil.isConstraintCondition(condition)) {
            this.warning("Condition name should be specified", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidName", new String[0]);
        } else if (condition.getName() != null && Character.isLowerCase(condition.getName().charAt(0))) {
            this.warning("Condition name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkFeatureCallFeature(RosettaFeatureCall fCall) {
        if (fCall.getFeature() == null) {
            this.error("Attribute is missing after '->'", fCall, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_FEATURE_CALL__FEATURE);
        }
    }

    @Check
    public void checkFunctionNameStartsWithCapital(Function func) {
        if (Character.isLowerCase(func.getName().charAt(0))) {
            this.warning("Function name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkAttributes(Data clazz) {
        HashMultimap name2attr = HashMultimap.create();
        for (RAttribute attr : this.objectFactory.buildRDataType(clazz).getAllAttributes()) {
            if (attr.isOverride()) continue;
            name2attr.put((Object)attr.getName(), (Object)attr);
        }
        for (Attribute a : clazz.getAttributes()) {
            String name;
            Set attrByName;
            if (a.isOverride() || (attrByName = name2attr.get((Object)(name = a.getName()))).size() <= 1) continue;
            List<RAttribute> attrFromClazzes = attrByName.stream().filter(it -> Objects.equals(it.getEObject().eContainer(), clazz)).toList();
            List<RAttribute> attrFromSuperClasses = attrByName.stream().filter(it -> !Objects.equals(it.getEObject().eContainer(), clazz)).toList();
            this.checkTypeAttributeMustHaveSameTypeAsParent(attrFromClazzes, attrFromSuperClasses, name);
            this.checkAttributeCardinalityMatchSuper(attrFromClazzes, attrFromSuperClasses, name);
        }
    }

    protected void checkTypeAttributeMustHaveSameTypeAsParent(Iterable<RAttribute> attrFromClazzes, Iterable<RAttribute> attrFromSuperClasses, String name) {
        for (RAttribute childAttr : attrFromClazzes) {
            RType childAttrType = childAttr.getRMetaAnnotatedType().getRType();
            for (RAttribute parentAttr : attrFromSuperClasses) {
                RType parentAttrType = parentAttr.getRMetaAnnotatedType().getRType();
                if (Objects.equals(childAttrType, parentAttrType)) continue;
                this.error("Overriding attribute '" + name + "' with type " + String.valueOf(childAttrType) + " must match the type of the attribute it overrides (" + String.valueOf(parentAttrType) + ")", childAttr.getEObject(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.duplicateAttribute", new String[0]);
            }
        }
    }

    protected void checkAttributeCardinalityMatchSuper(Iterable<RAttribute> attrFromClazzes, Iterable<RAttribute> attrFromSuperClasses, String name) {
        for (RAttribute childAttr : attrFromClazzes) {
            for (RAttribute parentAttr : attrFromSuperClasses) {
                if (Objects.equals(childAttr.getCardinality(), parentAttr.getCardinality())) continue;
                this.error("Overriding attribute '" + name + "' with cardinality (" + String.valueOf(childAttr.getCardinality()) + ") must match the cardinality of the attribute it overrides (" + String.valueOf(parentAttr.getCardinality()) + ")", childAttr.getEObject(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.cardinalityError", new String[0]);
            }
        }
    }

    @Check
    public void checkClosureParameterNamesAreUnique(ClosureParameter param) {
        IScope scope = this.scopeProvider.getScope(param.getFunction().eContainer(), ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL);
        IEObjectDescription sameNamedElement = scope.getSingleElement(QualifiedName.create((String)param.getName()));
        if (sameNamedElement != null) {
            this.error("Duplicate name.", param, null);
        }
    }

    @Check
    public void checkMappingSetToCase(RosettaMapping element) {
        RosettaType type;
        long defaultSetCount = element.getInstances().stream().filter(inst -> inst.getSet() != null && inst.getWhen() == null).count();
        if (defaultSetCount > 1L) {
            this.error("Only one set to with no when clause allowed.", element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
        }
        if (defaultSetCount == 1L) {
            RosettaMappingInstance lastInstance;
            RosettaMappingInstance defaultInstance = element.getInstances().stream().filter(inst -> inst.getSet() != null && inst.getWhen() == null).findFirst().orElse(null);
            RosettaMappingInstance rosettaMappingInstance = lastInstance = element.getInstances().isEmpty() ? null : (RosettaMappingInstance)element.getInstances().get(element.getInstances().size() - 1);
            if (defaultInstance != lastInstance) {
                this.error("Set to without when case must be ordered last.", element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
            }
        }
        if ((type = this.getContainerType(element)) != null) {
            boolean anySetConstants = element.getInstances().stream().anyMatch(inst -> inst.getSet() != null);
            if (type instanceof Data && anySetConstants) {
                this.error("Set to constant type does not match type of field.", element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
            } else if (type instanceof RosettaEnumeration) {
                for (RosettaMappingInstance inst2 : element.getInstances()) {
                    String setEnumName;
                    if (inst2.getSet() == null) continue;
                    RosettaMapTestExpression setExpr = inst2.getSet();
                    if (!(setExpr instanceof RosettaEnumValueReference)) {
                        this.error("Set to constant type does not match type of field.", element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
                        continue;
                    }
                    RosettaEnumValueReference setEnum = (RosettaEnumValueReference)setExpr;
                    String containerEnumName = ((RosettaEnumeration)type).getName();
                    if (Objects.equals(containerEnumName, setEnumName = setEnum.getEnumeration().getName())) continue;
                    this.error("Set to constant type does not match type of field.", element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
                }
            }
        }
    }

    public RosettaType getContainerType(RosettaMapping element) {
        EObject container = element.eContainer().eContainer().eContainer();
        if (container instanceof RosettaExternalRegularAttribute) {
            RosettaExternalRegularAttribute attrContainer = (RosettaExternalRegularAttribute)container;
            RosettaFeature attributeRef = attrContainer.getAttributeRef();
            if (attributeRef instanceof RosettaTyped) {
                RosettaTyped typed = (RosettaTyped)((Object)attributeRef);
                return typed.getTypeCall().getType();
            }
        } else if (container instanceof RosettaTyped) {
            RosettaTyped typed = (RosettaTyped)container;
            return typed.getTypeCall().getType();
        }
        return null;
    }

    @Check
    public void checkMappingDefaultCase(RosettaMapping element) {
        long defaultCount = element.getInstances().stream().filter(RosettaMappingInstance::isDefault).count();
        if (defaultCount > 1L) {
            this.error("Only one default case allowed.", element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
        }
        if (defaultCount == 1L) {
            RosettaMappingInstance lastInstance;
            RosettaMappingInstance defaultInstance = element.getInstances().stream().filter(RosettaMappingInstance::isDefault).findFirst().orElse(null);
            RosettaMappingInstance rosettaMappingInstance = lastInstance = element.getInstances().isEmpty() ? null : (RosettaMappingInstance)element.getInstances().get(element.getInstances().size() - 1);
            if (defaultInstance != lastInstance) {
                this.error("Default case must be ordered last.", element, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAPPING__INSTANCES);
            }
        }
    }

    @Check
    public void checkMergeSynonymAttributeCardinality(Attribute attribute) {
        for (RosettaSynonym syn : attribute.getSynonyms()) {
            boolean multi = attribute.getCard().isIsMany();
            RosettaSynonymBody body = syn.getBody();
            RosettaMergeSynonymValue merge = body == null ? null : body.getMerge();
            if (merge == null || multi) continue;
            this.error("Merge synonym can only be specified on an attribute with multiple cardinality.", syn.getBody(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__MERGE);
        }
    }

    @Check
    public void checkMergeSynonymAttributeCardinality(RosettaExternalRegularAttribute attribute) {
        RosettaFeature att = attribute.getAttributeRef();
        if (att instanceof Attribute) {
            Attribute attr = (Attribute)att;
            for (RosettaExternalSynonym syn : attribute.getExternalSynonyms()) {
                boolean multi = attr.getCard().isIsMany();
                RosettaSynonymBody body = syn.getBody();
                RosettaMergeSynonymValue merge = body == null ? null : body.getMerge();
                if (merge == null || multi) continue;
                this.error("Merge synonym can only be specified on an attribute with multiple cardinality.", syn.getBody(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__MERGE);
            }
        }
    }

    @Check
    public void checkPatternAndFormat(RosettaExternalRegularAttribute attribute) {
        boolean isDateTime = this.isDateTime(this.rosettaTypeProvider.getRTypeOfFeature(attribute.getAttributeRef(), attribute).getRType());
        if (!isDateTime) {
            for (RosettaExternalSynonym s : attribute.getExternalSynonyms()) {
                this.checkFormatNull(s.getBody());
                this.checkPatternValid(s.getBody());
            }
        } else {
            for (RosettaExternalSynonym s : attribute.getExternalSynonyms()) {
                this.checkFormatValid(s.getBody());
                this.checkPatternNull(s.getBody());
            }
        }
    }

    @Check
    public void checkPatternAndFormat(Attribute attribute) {
        boolean isDateTime = this.isDateTime(this.rosettaTypeProvider.getRTypeOfSymbol(attribute).getRType());
        if (!isDateTime) {
            for (RosettaSynonym s : attribute.getSynonyms()) {
                this.checkFormatNull(s.getBody());
                this.checkPatternValid(s.getBody());
            }
        } else {
            for (RosettaSynonym s : attribute.getSynonyms()) {
                this.checkFormatValid(s.getBody());
                this.checkPatternNull(s.getBody());
            }
        }
    }

    public void checkFormatNull(RosettaSynonymBody body) {
        if (body.getFormat() != null) {
            this.error("Format can only be applied to date/time types", body, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__FORMAT);
        }
    }

    public DateTimeFormatter checkFormatValid(RosettaSynonymBody body) {
        if (body == null || body.getFormat() == null) {
            return null;
        }
        try {
            return DateTimeFormatter.ofPattern(body.getFormat());
        }
        catch (IllegalArgumentException e) {
            this.error("Format must be a valid date/time format - " + e.getMessage(), body, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__FORMAT);
            return null;
        }
    }

    public void checkPatternNull(RosettaSynonymBody body) {
        if (body.getPatternMatch() != null) {
            this.error("Pattern cannot be applied to date/time types", body, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__PATTERN_MATCH);
        }
    }

    public Pattern checkPatternValid(RosettaSynonymBody body) {
        if (body == null || body.getPatternMatch() == null) {
            return null;
        }
        try {
            return Pattern.compile(body.getPatternMatch());
        }
        catch (PatternSyntaxException e) {
            this.error("Pattern to match must be a valid regular expression - " + this.getPatternSyntaxErrorMessage(e), body, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_BODY__PATTERN_MATCH);
            return null;
        }
    }

    private boolean isDateTime(RType rType) {
        String name = rType == null ? null : rType.getName();
        return Set.of("date", "time", "zonedDateTime").contains(name);
    }

    @Check
    public void checkPatternOnEnum(RosettaEnumSynonym synonym) {
        if (synonym.getPatternMatch() != null) {
            try {
                Pattern.compile(synonym.getPatternMatch());
            }
            catch (PatternSyntaxException e) {
                this.error("Pattern to match must be a valid regular expression - " + this.getPatternSyntaxErrorMessage(e), synonym, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_ENUM_SYNONYM__PATTERN_MATCH);
            }
        }
    }

    private String getPatternSyntaxErrorMessage(PatternSyntaxException e) {
        return e.getMessage().replace(System.lineSeparator(), "\n");
    }

    @Check
    public void checkFuncDispatchAttr(FunctionDispatch ele) {
        RosettaType type;
        if (this.rosettaEcoreUtil.isResolved(ele.getAttribute()) && this.rosettaEcoreUtil.isResolved(ele.getAttribute().getTypeCall()) && !((type = ele.getAttribute().getTypeCall().getType()) instanceof RosettaEnumeration)) {
            this.error("Dispatching function may refer to an enumeration typed attributes only. Current type is " + ele.getAttribute().getTypeCall().getType().getName(), ele, (EStructuralFeature)SimplePackage.Literals.FUNCTION_DISPATCH__ATTRIBUTE);
        }
    }

    @Check
    public void checkDispatch(Function ele) {
        if (ele instanceof FunctionDispatch) {
            return;
        }
        List dispatches = IterableExtensions.toList(this.rosettaFunctionExtensions.getDispatchingFunctions(ele));
        if (dispatches.isEmpty()) {
            return;
        }
        HashMap byEnum = new HashMap();
        for (FunctionDispatch fd : dispatches) {
            RosettaEnumValueReference enumRef = fd.getValue();
            if (enumRef == null || enumRef.getEnumeration() == null || enumRef.getValue() == null) continue;
            RosettaEnumeration rosettaEnumeration = enumRef.getEnumeration();
            String valueName = enumRef.getValue().getName();
            byEnum.computeIfAbsent(rosettaEnumeration, k -> new HashMap()).computeIfAbsent(valueName, k -> new ArrayList()).add(fd);
        }
        if (byEnum.isEmpty()) {
            return;
        }
        RosettaEnumeration mostUsedEnum = null;
        int maxSize = -1;
        for (Map.Entry entry : byEnum.entrySet()) {
            int size = ((Map)entry.getValue()).size();
            if (size <= maxSize) continue;
            maxSize = size;
            mostUsedEnum = (RosettaEnumeration)entry.getKey();
        }
        if (mostUsedEnum == null) {
            return;
        }
        HashSet<String> toImplement = new HashSet<String>();
        for (RosettaEnumValue v : this.objectFactory.buildREnumType(mostUsedEnum).getAllEnumValues()) {
            toImplement.add(v.getName());
        }
        Map map = byEnum.getOrDefault(mostUsedEnum, Map.of());
        toImplement.removeAll(map.keySet());
        if (!toImplement.isEmpty()) {
            this.warning("Missing implementation for " + mostUsedEnum.getName() + ": " + toImplement.stream().sorted().collect(Collectors.joining(", ")), ele, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
        for (Map.Entry e : byEnum.entrySet()) {
            RosettaEnumeration usedEnum = (RosettaEnumeration)e.getKey();
            Map entries = (Map)e.getValue();
            if (!Objects.equals(usedEnum, mostUsedEnum)) {
                for (List list : entries.values()) {
                    for (FunctionDispatch fd : list) {
                        this.error("Wrong " + usedEnum.getName() + " enumeration used. Expecting " + mostUsedEnum.getName() + ".", fd.getValue(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_ENUM_VALUE_REFERENCE__ENUMERATION);
                    }
                }
                continue;
            }
            for (Map.Entry entry : entries.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                for (FunctionDispatch fd : (List)entry.getValue()) {
                    this.error("Dupplicate usage of " + (String)entry.getKey() + " enumeration value.", fd.getValue(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_ENUM_VALUE_REFERENCE__VALUE);
                }
            }
        }
    }

    @Check
    public void checkConditionDontUseOutput(Function ele) {
        for (Condition cond : ele.getConditions()) {
            Stack<String> trace;
            List<RosettaSymbol> outRef;
            RosettaExpression expr;
            if (cond.isPostCondition() || (expr = cond.getExpression()) == null || (outRef = this.exprHelper.findOutputRef(expr, trace = new Stack<String>())) == null || outRef.isEmpty()) continue;
            RosettaSymbol first = outRef.get(0);
            StringBuilder msg = new StringBuilder();
            msg.append("output '").append(first.getName()).append("' or alias on output '").append(first.getName()).append("' not allowed in condition blocks.");
            if (!trace.isEmpty()) {
                msg.append("\n").append(String.join((CharSequence)" > ", trace)).append(" > ").append(first.getName());
            }
            this.error(msg.toString(), expr, null);
        }
    }

    @Check
    public void checkAssignAnAlias(Operation ele) {
        if (ele.getPath() == null && ele.getAssignRoot() instanceof ShortcutDeclaration) {
            this.error("An alias can not be assigned. Assign target must be an attribute.", ele, (EStructuralFeature)SimplePackage.Literals.OPERATION__ASSIGN_ROOT);
        }
    }

    @Check
    public void checkSynonymMapPath(RosettaMapPathValue ele) {
        InvalidPathChar invalid;
        if (!StringExtensions.isNullOrEmpty((String)ele.getPath()) && (invalid = this.checkPathChars(ele.getPath())) != null) {
            String msg = "Character '" + invalid.ch + "' is not allowed " + (invalid.atSegmentStart ? "as first symbol in a path segment." : "in paths. Use '->' to separate path segments.");
            this.error(msg, ele, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_MAP_PATH_VALUE__PATH);
        }
    }

    @Check
    public void checkSynonyValuePath(RosettaSynonymValueBase ele) {
        InvalidPathChar invalid;
        if (!StringExtensions.isNullOrEmpty((String)ele.getPath()) && (invalid = this.checkPathChars(ele.getPath())) != null) {
            String msg = "Character '" + invalid.ch + "' is not allowed " + (invalid.atSegmentStart ? "as first symbol in a path segment." : "in paths. Use '->' to separate path segments.");
            this.error(msg, ele, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_SYNONYM_VALUE_BASE__PATH);
        }
    }

    @Check
    public void checkToStringOpArgument(ToStringOperation ele) {
        RosettaExpression arg = ele.getArgument();
        if (this.rosettaEcoreUtil.isResolved(arg)) {
            RType type;
            if (this.cardinality.isMulti(arg)) {
                this.error("The argument of " + ele.getOperator() + " should be of singular cardinality.", ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT);
            }
            if (!((type = this.typeSystem.stripFromTypeAliases(this.rosettaTypeProvider.getRMetaAnnotatedType(arg).getRType())) instanceof RBasicType || type instanceof RRecordType || type instanceof REnumType)) {
                this.error("The argument of " + ele.getOperator() + " should be of a builtin type or an enum.", ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT);
            }
        }
    }

    @Check
    public void checkFunctionPrefix(Function ele) {
        ele.getAnnotations().forEach(a -> {
            String prefix = a.getAnnotation().getPrefix();
            if (prefix != null && !ele.getName().startsWith(prefix + "_")) {
                this.warning("Function name " + ele.getName() + " must have prefix '" + prefix + "' followed by an underscore.", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidElementName", new String[0]);
            }
        });
    }

    @Check
    public void checkMetadataAnnotation(Annotated ele) {
        List<AnnotationRef> metadatas = this.rosettaFunctionExtensions.getMetadataAnnotations(ele);
        block18: for (AnnotationRef it : metadatas) {
            String name;
            Attribute attr = it.getAttribute();
            String string = name = attr == null ? null : attr.getName();
            if (name == null) continue;
            switch (name) {
                case "key": {
                    if (ele instanceof Data) break;
                    this.error("[metadata key] annotation only allowed on a type.", it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                    break;
                }
                case "id": {
                    if (ele instanceof Attribute) break;
                    this.error("[metadata id] annotation only allowed on an attribute.", it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                    break;
                }
                case "reference": {
                    if (ele instanceof Attribute) break;
                    this.error("[metadata reference] annotation only allowed on an attribute.", it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                    break;
                }
                case "scheme": {
                    if (ele instanceof Attribute || ele instanceof Data) break;
                    this.error("[metadata scheme] annotation only allowed on an attribute or a type.", it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                    break;
                }
                case "template": {
                    if (!(ele instanceof Data)) {
                        this.error("[metadata template] annotation only allowed on a type.", it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                        break;
                    }
                    boolean hasKey = metadatas.stream().map(AnnotationRef::getAttribute).map(a -> a == null ? null : a.getName()).anyMatch("key"::equals);
                    if (hasKey) continue block18;
                    this.error("Types with [metadata template] annotation must also specify the [metadata key] annotation.", it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                    break;
                }
                case "location": {
                    if (ele instanceof Attribute) {
                        boolean hasPointsTo = it.getQualifiers().stream().anyMatch(q -> Objects.equals(q.getQualName(), "pointsTo"));
                        if (!hasPointsTo) continue block18;
                        this.error("pointsTo qualifier belongs on the address not the location.", it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                        break;
                    }
                    this.error("[metadata location] annotation only allowed on an attribute.", it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                    break;
                }
                case "address": {
                    if (ele instanceof Attribute) {
                        for (AnnotationQualifier q2 : it.getQualifiers()) {
                            if (!Objects.equals(q2.getQualName(), "pointsTo")) continue;
                            RosettaAttributeReferenceSegment qualPath = q2.getQualPath();
                            if (qualPath instanceof RosettaAttributeReference) {
                                RosettaAttributeReference attrRef = (RosettaAttributeReference)qualPath;
                                if (!this.rosettaEcoreUtil.isResolved(attrRef.getAttribute())) continue;
                                this.checkForLocation(attrRef.getAttribute(), q2);
                                RType targetType = this.typeSystem.typeCallToRType(attrRef.getAttribute().getTypeCall());
                                RType thisType = this.rosettaTypeProvider.getRTypeOfFeature((RosettaFeature)((Object)ele), null).getRType();
                                if (this.typeSystem.isSubtypeOf(thisType, targetType)) continue;
                                this.error("Expected address target type of '" + thisType.getName() + "' but was '" + (targetType != null ? targetType.getName() : "null") + "'", q2, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_QUALIFIER__QUAL_PATH, "RosettaIssueCodes.typeError", new String[0]);
                                continue;
                            }
                            this.error("Target of an address must be an attribute", q2, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_QUALIFIER__QUAL_PATH, "RosettaIssueCodes.typeError", new String[0]);
                        }
                        continue block18;
                    }
                    this.error("[metadata address] annotation only allowed on an attribute.", it, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE);
                    break;
                }
            }
        }
    }

    private void checkForLocation(Attribute attribute, AnnotationQualifier checked) {
        boolean locationFound = this.rosettaFunctionExtensions.getMetadataAnnotations(attribute).stream().map(AnnotationRef::getAttribute).map(a -> a == null ? null : a.getName()).anyMatch("location"::equals);
        if (!locationFound) {
            this.error("Target of address must be annotated with metadata location", checked, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_QUALIFIER__QUAL_PATH);
        }
    }

    @Check
    public void checkTransformAnnotations(Annotated ele) {
        String name;
        List<AnnotationRef> annotations = this.rosettaFunctionExtensions.getTransformAnnotations(ele);
        if (annotations.isEmpty()) {
            return;
        }
        if (!(ele instanceof Function)) {
            this.error("Transform annotations only allowed on a function.", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
            return;
        }
        Function func = (Function)ele;
        if (annotations.size() > 1) {
            annotations.stream().skip(1L).forEach(it -> this.error("Only one transform annotation allowed.", (EObject)it, null));
        }
        AnnotationRef annotationRef = annotations.get(0);
        func.getInputs().stream().skip(1L).forEach(i -> this.error("Transform functions may only have a single input.", (EObject)i, null));
        if (func.getOutput() != null && func.getInputs().isEmpty()) {
            this.error("Transform functions must have a single input.", annotationRef, null);
        }
        if (Objects.equals(name = annotationRef.getAnnotation().getName(), "ingest") && annotationRef.getAttribute() == null) {
            this.error("The `ingest` annotation must have a source format such as JSON, XML or CSV", annotationRef, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ANNOTATION);
        }
        if (Objects.equals(name, "projection") && annotationRef.getAttribute() == null) {
            this.error("The `projection` annotation must have a target format such as JSON, XML or CSV", annotationRef, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_REF__ANNOTATION);
        }
    }

    @Check
    public void checkCreationAnnotation(Annotated ele) {
        RType funcOutputType;
        List<AnnotationRef> annotations = this.rosettaFunctionExtensions.getCreationAnnotations(ele);
        if (annotations.isEmpty()) {
            return;
        }
        if (!(ele instanceof Function)) {
            this.error("Creation annotation only allowed on a function.", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidElementName", new String[0]);
            return;
        }
        if (annotations.size() > 1) {
            this.error("Only 1 creation annotation allowed.", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidElementName", new String[0]);
            return;
        }
        Function func = (Function)ele;
        RType annotationType = this.rosettaTypeProvider.getRTypeOfSymbol(annotations.get(0).getAttribute()).getRType();
        if (annotationType instanceof RChoiceType) {
            RChoiceType choice = (RChoiceType)annotationType;
            annotationType = choice.asRDataType();
        }
        if ((funcOutputType = this.rosettaTypeProvider.getRTypeOfSymbol(func).getRType()) instanceof RChoiceType) {
            RChoiceType choice = (RChoiceType)funcOutputType;
            funcOutputType = choice.asRDataType();
        }
        if (annotationType instanceof RDataType) {
            RDataType annotationDataType = (RDataType)annotationType;
            if (funcOutputType instanceof RDataType) {
                boolean invalid;
                RDataType funcOutputDataType = (RDataType)funcOutputType;
                HashSet funcOutputSuperTypes = new HashSet();
                funcOutputDataType.getAllSuperTypes().forEach(t -> funcOutputSuperTypes.add(t));
                ArrayList<Class<RType>> annotationAttributeTypes = new ArrayList<Class<RType>>();
                for (RAttribute a : annotationDataType.getAllAttributes()) {
                    annotationAttributeTypes.add(RType.class);
                }
                boolean bl = invalid = !Objects.equals(annotationDataType, funcOutputDataType) && !funcOutputSuperTypes.contains(annotationDataType) && !annotationAttributeTypes.contains(funcOutputDataType);
                if (invalid) {
                    this.warning("Invalid output type for creation annotation.  The output type must match the type specified in the annotation '" + annotationDataType.getName() + "' (or extend the annotation type, or be a sub-type as part of a one-of condition).", func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__OUTPUT);
                }
            }
        }
    }

    @Check
    public void checkQualificationAnnotation(Annotated ele) {
        RType outType;
        RosettaType inputType;
        List<AnnotationRef> annotations = this.rosettaFunctionExtensions.getQualifierAnnotations(ele);
        if (annotations.isEmpty()) {
            return;
        }
        if (!(ele instanceof Function)) {
            this.error("Qualification annotation only allowed on a function.", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidElementName", new String[0]);
            return;
        }
        Function func = (Function)ele;
        if (annotations.size() > 1) {
            this.error("Only 1 qualification annotation allowed.", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidElementName", new String[0]);
            return;
        }
        List<Attribute> inputs = this.rosettaFunctionExtensions.getInputs(func);
        if (inputs == null || inputs.size() != 1) {
            this.error("Qualification functions must have exactly 1 input.", func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__INPUTS);
            return;
        }
        RosettaType rosettaType = inputType = inputs.get(0).getTypeCall() == null ? null : inputs.get(0).getTypeCall().getType();
        if (!this.rosettaEcoreUtil.isResolved(inputType)) {
            this.error("Invalid input type for qualification function.", func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__INPUTS);
        } else if (!this.confExtensions.isRootEventOrProduct(inputType)) {
            this.warning("Input type does not match qualification root type.", func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__INPUTS);
        }
        RType rType = func.getOutput() == null ? null : (outType = func.getOutput().getTypeCall() == null ? null : this.typeSystem.typeCallToRType(func.getOutput().getTypeCall()));
        if (!Objects.equals(outType, this.builtinTypeService.BOOLEAN)) {
            this.error("Qualification functions must output a boolean.", func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__OUTPUT);
        }
    }

    private InvalidPathChar checkPathChars(String str) {
        String[] segments;
        for (String segment : segments = str.split("->")) {
            if (segment.isEmpty()) continue;
            if (!Character.isJavaIdentifierStart(segment.charAt(0))) {
                return new InvalidPathChar(segment.charAt(0), true);
            }
            for (char c : segment.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                return new InvalidPathChar(c, false);
            }
        }
        return null;
    }

    @Check
    public void checkUnaryOperation(RosettaUnaryOperation e) {
        RosettaExpression receiver = e.getArgument();
        if (e instanceof ListOperation && this.rosettaEcoreUtil.isResolved(receiver) && !this.cardinality.isMulti(receiver)) {
            this.warning("List " + e.getOperator() + " operation cannot be used for single cardinality expressions.", e, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
        if (!(e instanceof CanHandleListOfLists) && receiver != null && this.cardinality.isOutputListOfLists(receiver)) {
            this.error("List must be flattened before " + e.getOperator() + " operation.", e, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    @Check
    public void checkInlineFunction(InlineFunction f) {
        if (f.getBody() == null) {
            this.error("Missing function body.", f, null);
        }
    }

    @Check
    public void checkMandatoryFunctionalOperation(MandatoryFunctionalOperation e) {
        this.checkBodyExists(e);
    }

    @Check
    public void checkUnaryFunctionalOperation(UnaryFunctionalOperation e) {
        this.checkOptionalNamedParameter(e.getFunction());
    }

    @Check
    public void checkFilterOperation(FilterOperation o) {
        this.checkBodyType(o.getFunction(), this.builtinTypeService.BOOLEAN);
        this.checkBodyIsSingleCardinality(o.getFunction());
    }

    @Check
    public void checkMapOperation(MapOperation o) {
        if (this.cardinality.isOutputListOfListOfLists(o)) {
            this.error("Each list item is already a list, mapping the item into a list of lists is not allowed. List map item expression must maintain existing cardinality (e.g. list to list), or reduce to single cardinality (e.g. list to single using expression such as count, sum etc).", o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_FUNCTIONAL_OPERATION__FUNCTION);
        }
    }

    @Check
    public void checkFlattenOperation(FlattenOperation o) {
        if (!this.cardinality.isOutputListOfLists(o.getArgument())) {
            this.error("List flatten only allowed for list of lists.", o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    @Check
    public void checkReduceOperation(ReduceOperation o) {
        this.checkNumberOfMandatoryNamedParameters(o.getFunction(), 2);
        boolean subtype = this.typeSystem.isSubtypeOf(this.rosettaTypeProvider.getRMetaAnnotatedType(o.getArgument()), this.rosettaTypeProvider.getRMetaAnnotatedType(o.getFunction().getBody()));
        if (!subtype) {
            this.error("List reduce expression must evaluate to the same type as the input. Found types " + String.valueOf(this.rosettaTypeProvider.getRMetaAnnotatedType(o.getArgument()).getRType()) + " and " + String.valueOf(this.rosettaTypeProvider.getRMetaAnnotatedType(o.getFunction().getBody()).getRType()) + ".", o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_FUNCTIONAL_OPERATION__FUNCTION);
        }
        this.checkBodyIsSingleCardinality(o.getFunction());
    }

    @Check
    public void checkNumberReducerOperation(SumOperation o) {
        this.checkInputType(o, this.builtinTypeService.UNCONSTRAINED_NUMBER_WITH_NO_META);
    }

    @Check
    public void checkComparingFunctionalOperation(ComparingFunctionalOperation o) {
        this.checkBodyIsSingleCardinality(o.getFunction());
        this.checkBodyIsComparable(o);
        if (o.getFunction() == null) {
            this.checkInputIsComparable(o);
        }
    }

    @Check
    public void checkAsKeyOperation(AsKeyOperation o) {
        EObject container = o.eContainer();
        if (container instanceof Operation) {
            RosettaFeature feature;
            Operation op = (Operation)container;
            if (op.getPath() == null) {
                this.error("'" + o.getOperator() + "' can only be used when assigning an attribute. Example: \"set out -> attribute: value as-key\"", o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
                return;
            }
            EList<Segment> segments = op.getPath().asSegmentList(op.getPath());
            Segment last = segments == null ? null : (Segment)IterableExtensions.lastOrNull(segments);
            RosettaFeature rosettaFeature = feature = last == null ? null : last.getFeature();
            if (feature instanceof RosettaMetaType || !(feature instanceof Attribute) || !this.rosettaEcoreUtil.hasReferenceAnnotation((Attribute)feature)) {
                this.error("'" + o.getOperator() + "' can only be used with attributes annotated with [metadata reference] annotation.", o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        } else if (container instanceof ConstructorKeyValuePair) {
            ConstructorKeyValuePair kv = (ConstructorKeyValuePair)container;
            RosettaFeature attr = kv.getKey();
            if (!(attr instanceof Attribute) || !this.rosettaEcoreUtil.hasReferenceAnnotation((Attribute)attr)) {
                this.error("'" + o.getOperator() + "' can only be used with attributes annotated with [metadata reference] annotation.", o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        } else {
            this.error("'" + o.getOperator() + "' may only be used in context of an attribute.\"", o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    @Check
    public void checkImport(RosettaModel model) {
        for (Object ns : model.getImports()) {
            QualifiedName qn;
            boolean isWildcard;
            if (ns.getImportedNamespace() == null || (isWildcard = (qn = QualifiedName.create((String[])ns.getImportedNamespace().split("\\."))).getLastSegment().equals("*")) || ns.getNamespaceAlias() == null) continue;
            this.error("\"as\" statement can only be used with wildcard imports", (EObject)ns, (EStructuralFeature)RosettaPackage.Literals.IMPORT__NAMESPACE_ALIAS);
        }
        List<Import> unused = this.importManagementService.findUnused(model);
        for (Import ns : unused) {
            this.warning("Unused import " + ns.getImportedNamespace(), ns, (EStructuralFeature)RosettaPackage.Literals.IMPORT__IMPORTED_NAMESPACE, "RosettaIssueCodes.unusedImport", new String[0]);
        }
        List<Import> duplicates = this.importManagementService.findDuplicates((List<Import>)model.getImports());
        for (Import imp : duplicates) {
            this.warning("Duplicate import " + imp.getImportedNamespace(), imp, (EStructuralFeature)RosettaPackage.Literals.IMPORT__IMPORTED_NAMESPACE, "RosettaIssueCodes.duplicateImport", new String[0]);
        }
    }

    private void checkBodyExists(RosettaFunctionalOperation operation) {
        if (operation.getFunction() == null) {
            this.error("Missing an expression.", operation, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    private void checkOptionalNamedParameter(InlineFunction ref) {
        if (ref != null && ref.getParameters() != null && ref.getParameters().size() != 0 && ref.getParameters().size() != 1) {
            this.error("Function must have 1 named parameter.", ref, (EStructuralFeature)ExpressionPackage.Literals.INLINE_FUNCTION__PARAMETERS);
        }
    }

    private void checkNumberOfMandatoryNamedParameters(InlineFunction ref, int max) {
        if (ref != null && ref.getParameters() == null || ref != null && ref.getParameters().size() != max) {
            this.error("Function must have " + max + " named parameter" + (max > 1 ? "s" : "") + ".", ref, (EStructuralFeature)ExpressionPackage.Literals.INLINE_FUNCTION__PARAMETERS);
        }
    }

    private void checkInputType(RosettaUnaryOperation o, RMetaAnnotatedType type) {
        boolean ok = this.typeSystem.isSubtypeOf(this.rosettaTypeProvider.getRMetaAnnotatedType(o.getArgument()), type);
        if (!ok) {
            this.error("Input type must be a " + String.valueOf(type) + ".", o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    private void checkInputIsComparable(RosettaUnaryOperation o) {
        RMetaAnnotatedType inputRType = this.rosettaTypeProvider.getRMetaAnnotatedType(o.getArgument());
        if (!inputRType.getRType().hasNaturalOrder()) {
            this.error("Operation " + o.getOperator() + " only supports comparable types (string, int, number, boolean, date). Found type " + inputRType.getRType().getName() + ".", o, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
        }
    }

    private void checkBodyIsSingleCardinality(InlineFunction ref) {
        if (ref != null && this.cardinality.isBodyExpressionMulti(ref)) {
            this.error("Operation only supports single cardinality expressions.", ref, null);
        }
    }

    private void checkBodyType(InlineFunction ref, RType type) {
        RType bodyType;
        RType rType = bodyType = ref == null || ref.getBody() == null ? null : this.rosettaTypeProvider.getRMetaAnnotatedType(ref.getBody()).getRType();
        if (ref != null && bodyType != null && !Objects.equals(bodyType, type)) {
            this.error("Expression must evaluate to a " + type.getName() + ".", ref, null);
        }
    }

    private void checkBodyIsComparable(RosettaFunctionalOperation op) {
        RMetaAnnotatedType bodyRType;
        InlineFunction ref = op.getFunction();
        if (ref != null && !(bodyRType = this.rosettaTypeProvider.getRMetaAnnotatedType(ref.getBody())).getRType().hasNaturalOrder()) {
            this.error("Operation " + op.getOperator() + " only supports comparable types (string, int, number, boolean, date). Found type " + bodyRType.getRType().getName() + ".", ref, null);
        }
    }

    @Check
    public void checkAlias(ShortcutDeclaration o) {
        RosettaExpression expr;
        RosettaExpression rosettaExpression = expr = o == null ? null : o.getExpression();
        if (expr != null && this.cardinality.isOutputListOfLists(expr)) {
            this.error("Alias expression contains a list of lists, use flatten to create a list.", o, (EStructuralFeature)SimplePackage.Literals.SHORTCUT_DECLARATION__EXPRESSION);
        }
    }

    private record InvalidPathChar(char ch, boolean atSegmentStart) {
    }
}

