/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation.expression;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.ParseOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaOperation;
import com.regnosys.rosetta.rosetta.expression.ToEnumOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.validation.expression.ExpressionValidator;
import jakarta.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class ParseOperationValidator
extends ExpressionValidator {
    @Inject
    private RosettaEcoreUtil ecoreUtil;

    @Check
    public void checkParseOpArgument(ParseOperation ele) {
        RosettaExpression arg = ele.getArgument();
        if (this.ecoreUtil.isResolved(arg)) {
            this.isSingleCheck(arg, (EObject)ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, ele);
            RMetaAnnotatedType argumentRMetaType = this.typeProvider.getRMetaAnnotatedType(arg);
            if (ele instanceof ToEnumOperation) {
                RosettaExpression toStringArgument;
                RType toStringArgumnetRType;
                RType argumentRType = this.typeSystem.stripFromTypeAliases(argumentRMetaType.getRType());
                if (argumentRType.equals(this.builtins.NOTHING)) {
                    return;
                }
                if (arg instanceof ToStringOperation && (toStringArgumnetRType = this.typeSystem.stripFromTypeAliases(this.typeProvider.getRMetaAnnotatedType(toStringArgument = ((ToStringOperation)arg).getArgument()).getRType())) instanceof REnumType) {
                    this.warning("Using to-string on enumeration to convert to another enum is not required", (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT);
                }
                if (!this.typeSystem.isSubtypeOf(argumentRMetaType, this.builtins.UNCONSTRAINED_STRING_WITH_NO_META) && !(argumentRType instanceof REnumType)) {
                    this.unsupportedTypeError(argumentRMetaType, ele.getOperator(), ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, "Supported argument types are strings and enumerations");
                }
            } else {
                this.subtypeCheck(this.builtins.UNCONSTRAINED_STRING_WITH_NO_META, ele.getArgument(), (EObject)ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, (RosettaOperation)ele);
            }
        }
    }
}

