/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation.names;

import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.validation.names.ClusterScopes;
import com.regnosys.rosetta.validation.names.DuplicationCluster;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

@Singleton
public class RosettaUniqueNamesConfig {
    private final ClusterScopes scopes;
    private final Map<EClass, DuplicationCluster> duplicationClusters = new HashMap<EClass, DuplicationCluster>();

    @Inject
    public RosettaUniqueNamesConfig(ClusterScopes scopes) {
        this.scopes = scopes;
        this.initialize();
    }

    protected void initialize() {
        this.addGlobalCheck(RosettaPackage.eINSTANCE.getRosettaSynonymSource(), false);
        this.addGlobalCheck(RosettaPackage.eINSTANCE.getRosettaExternalRuleSource(), false);
        this.addGlobalCheck(RosettaPackage.eINSTANCE.getRosettaCallableWithArgs(), false);
        this.addGlobalCheck(RosettaPackage.eINSTANCE.getRosettaType(), false);
        this.addGlobalCheck(SimplePackage.eINSTANCE.getAnnotation(), false);
        this.addGlobalCheck(RosettaPackage.eINSTANCE.getRosettaBody(), true);
        this.addGlobalCheck(RosettaPackage.eINSTANCE.getRosettaCorpus(), true);
        this.addGlobalCheck(RosettaPackage.eINSTANCE.getRosettaSegment(), true);
        this.addGlobalCheck(RosettaPackage.eINSTANCE.getRosettaScope(), false);
        this.addLocalCheck(SimplePackage.eINSTANCE.getAttribute(), Attribute.class, this::getDirectDataContainer, Data::getAttributes, true);
        this.addLocalCheck(RosettaPackage.eINSTANCE.getRosettaSymbol(), RosettaSymbol.class, this::getFunctionContainer, this::getFunctionSymbols, true);
    }

    private Data getDirectDataContainer(Attribute attr) {
        return this.containerOfType(attr, Data.class);
    }

    private com.regnosys.rosetta.rosetta.simple.Function getFunctionContainer(RosettaSymbol symbol) {
        return (com.regnosys.rosetta.rosetta.simple.Function)EcoreUtil2.getContainerOfType((EObject)symbol, com.regnosys.rosetta.rosetta.simple.Function.class);
    }

    private Iterable<RosettaSymbol> getFunctionSymbols(com.regnosys.rosetta.rosetta.simple.Function function) {
        return EcoreUtil2.getAllContentsOfType((EObject)function, RosettaSymbol.class);
    }

    private <T> T containerOfType(EObject eObject, Class<T> clazz) {
        EObject parent = eObject.eContainer();
        if (clazz.isInstance(parent)) {
            return clazz.cast(parent);
        }
        return null;
    }

    public Map<EClass, DuplicationCluster> getDuplicationClusters() {
        return this.duplicationClusters;
    }

    public DuplicationCluster getDuplicationCluster(EClass clusterType) {
        return this.duplicationClusters.get(clusterType);
    }

    protected void addGlobalCheck(EClass clusterType, boolean caseSensitive) {
        this.duplicationClusters.put(clusterType, new DuplicationCluster(clusterType, this.scopes.global(), caseSensitive));
    }

    protected <Parent, Child extends RosettaNamed> void addLocalCheck(EClass clusterType, Class<Child> childClass, Function<Child, Parent> getParent, Function<Parent, Iterable<Child>> getChildren, boolean caseSensitive) {
        this.duplicationClusters.put(clusterType, new DuplicationCluster(clusterType, this.scopes.local(childClass, getParent, getChildren), caseSensitive));
    }
}

