package iso20022.auth030.hkma.dtcc;

import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * Defines the sub-product of type Construction.
 * @version ${project.version}
 */
@RosettaEnum("AssetClassSubProductType33Code")
public enum AssetClassSubProductType33Code {

	/**
	 * Commodity of type construction.
	 */
	@RosettaEnumValue(value = "CSTR") 
	CSTR("CSTR", null)
;
	private static Map<String, AssetClassSubProductType33Code> values;
	static {
        Map<String, AssetClassSubProductType33Code> map = new ConcurrentHashMap<>();
		for (AssetClassSubProductType33Code instance : AssetClassSubProductType33Code.values()) {
			map.put(instance.toDisplayString(), instance);
		}
		values = Collections.unmodifiableMap(map);
    }

	private final String rosettaName;
	private final String displayName;

	AssetClassSubProductType33Code(String rosettaName, String displayName) {
		this.rosettaName = rosettaName;
		this.displayName = displayName;
	}

	public static AssetClassSubProductType33Code fromDisplayName(String name) {
		AssetClassSubProductType33Code value = values.get(name);
		if (value == null) {
			throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
		}
		return value;
	}

	@Override
	public String toString() {
		return toDisplayString();
	}

	public String toDisplayString() {
		return displayName != null ?  displayName : rosettaName;
	}
}
