package iso20022.auth030.hkma.tr.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.AssetClassCommodityFertilizer4Choice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("AssetClassCommodityFertilizer4ChoiceChoice")
@ImplementedBy(AssetClassCommodityFertilizer4ChoiceChoice.Default.class)
public interface AssetClassCommodityFertilizer4ChoiceChoice extends Validator<AssetClassCommodityFertilizer4Choice> {
	
	String NAME = "AssetClassCommodityFertilizer4ChoiceChoice";
	String DEFINITION = "one-of";
	
	class Default implements AssetClassCommodityFertilizer4ChoiceChoice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetClassCommodityFertilizer4Choice assetClassCommodityFertilizer4Choice) {
			ComparisonResult result = executeDataRule(assetClassCommodityFertilizer4Choice);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityFertilizer4Choice", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityFertilizer4Choice", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(AssetClassCommodityFertilizer4Choice assetClassCommodityFertilizer4Choice) {
			try {
				return choice(MapperS.of(assetClassCommodityFertilizer4Choice), Arrays.asList("ammn", "dmmnmPhspht", "ptsh", "slphr", "urea", "ureaAndAmmnmNtrt", "othr"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements AssetClassCommodityFertilizer4ChoiceChoice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetClassCommodityFertilizer4Choice assetClassCommodityFertilizer4Choice) {
			return Collections.emptyList();
		}
	}
}
