package iso20022.auth030.hkma.tr.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.hkma.tr.BasketConstituents3__1;
import iso20022.auth030.hkma.tr.InstrumentIdentification6Choice__1;
import iso20022.auth030.hkma.tr.UnitOfMeasure8Choice__1;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class BasketConstituents3__1OnlyExistsValidator implements ValidatorWithArg<BasketConstituents3__1, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends BasketConstituents3__1> ValidationResult<BasketConstituents3__1> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("instrmId", ExistenceChecker.isSet((InstrumentIdentification6Choice__1) o.getInstrmId()))
				.put("qty", ExistenceChecker.isSet((BigDecimal) o.getQty()))
				.put("unitOfMeasr", ExistenceChecker.isSet((UnitOfMeasure8Choice__1) o.getUnitOfMeasr()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("BasketConstituents3__1", ValidationResult.ValidationType.ONLY_EXISTS, "BasketConstituents3__1", path, "");
		}
		return failure("BasketConstituents3__1", ValidationResult.ValidationType.ONLY_EXISTS, "BasketConstituents3__1", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
