package iso20022.auth108.iso;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth108.iso.meta.LegalPersonIdentification1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Provides the identification of the organisation which is a legal person.
 * @version ${project.version}
 */
@RosettaDataType(value="LegalPersonIdentification1", builder=LegalPersonIdentification1.LegalPersonIdentification1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="LegalPersonIdentification1", model="iso20022", builder=LegalPersonIdentification1.LegalPersonIdentification1BuilderImpl.class, version="${project.version}")
public interface LegalPersonIdentification1 extends RosettaModelObject {

	LegalPersonIdentification1Meta metaData = new LegalPersonIdentification1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Unique and unambiguous identification of the legal person.
	 */
	OrganisationIdentification15Choice getId();
	/**
	 * Code of country where the registered office of the organisation is located.
	 */
	String getCtry();

	/*********************** Build Methods  ***********************/
	LegalPersonIdentification1 build();
	
	LegalPersonIdentification1.LegalPersonIdentification1Builder toBuilder();
	
	static LegalPersonIdentification1.LegalPersonIdentification1Builder builder() {
		return new LegalPersonIdentification1.LegalPersonIdentification1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends LegalPersonIdentification1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends LegalPersonIdentification1> getType() {
		return LegalPersonIdentification1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("id"), processor, OrganisationIdentification15Choice.class, getId());
		processor.processBasic(path.newSubPath("ctry"), String.class, getCtry(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface LegalPersonIdentification1Builder extends LegalPersonIdentification1, RosettaModelObjectBuilder {
		OrganisationIdentification15Choice.OrganisationIdentification15ChoiceBuilder getOrCreateId();
		@Override
		OrganisationIdentification15Choice.OrganisationIdentification15ChoiceBuilder getId();
		LegalPersonIdentification1.LegalPersonIdentification1Builder setId(OrganisationIdentification15Choice id);
		LegalPersonIdentification1.LegalPersonIdentification1Builder setCtry(String ctry);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("id"), processor, OrganisationIdentification15Choice.OrganisationIdentification15ChoiceBuilder.class, getId());
			processor.processBasic(path.newSubPath("ctry"), String.class, getCtry(), this);
		}
		

		LegalPersonIdentification1.LegalPersonIdentification1Builder prune();
	}

	/*********************** Immutable Implementation of LegalPersonIdentification1  ***********************/
	class LegalPersonIdentification1Impl implements LegalPersonIdentification1 {
		private final OrganisationIdentification15Choice id;
		private final String ctry;
		
		protected LegalPersonIdentification1Impl(LegalPersonIdentification1.LegalPersonIdentification1Builder builder) {
			this.id = ofNullable(builder.getId()).map(f->f.build()).orElse(null);
			this.ctry = builder.getCtry();
		}
		
		@Override
		@RosettaAttribute(value="id", isRequired=true)
		@RuneAttribute(value="id", isRequired=true)
		public OrganisationIdentification15Choice getId() {
			return id;
		}
		
		@Override
		@RosettaAttribute("ctry")
		@RuneAttribute("ctry")
		public String getCtry() {
			return ctry;
		}
		
		@Override
		public LegalPersonIdentification1 build() {
			return this;
		}
		
		@Override
		public LegalPersonIdentification1.LegalPersonIdentification1Builder toBuilder() {
			LegalPersonIdentification1.LegalPersonIdentification1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(LegalPersonIdentification1.LegalPersonIdentification1Builder builder) {
			ofNullable(getId()).ifPresent(builder::setId);
			ofNullable(getCtry()).ifPresent(builder::setCtry);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			LegalPersonIdentification1 _that = getType().cast(o);
		
			if (!Objects.equals(id, _that.getId())) return false;
			if (!Objects.equals(ctry, _that.getCtry())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (id != null ? id.hashCode() : 0);
			_result = 31 * _result + (ctry != null ? ctry.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "LegalPersonIdentification1 {" +
				"id=" + this.id + ", " +
				"ctry=" + this.ctry +
			'}';
		}
	}

	/*********************** Builder Implementation of LegalPersonIdentification1  ***********************/
	class LegalPersonIdentification1BuilderImpl implements LegalPersonIdentification1.LegalPersonIdentification1Builder {
	
		protected OrganisationIdentification15Choice.OrganisationIdentification15ChoiceBuilder id;
		protected String ctry;
		
		@Override
		@RosettaAttribute(value="id", isRequired=true)
		@RuneAttribute(value="id", isRequired=true)
		public OrganisationIdentification15Choice.OrganisationIdentification15ChoiceBuilder getId() {
			return id;
		}
		
		@Override
		public OrganisationIdentification15Choice.OrganisationIdentification15ChoiceBuilder getOrCreateId() {
			OrganisationIdentification15Choice.OrganisationIdentification15ChoiceBuilder result;
			if (id!=null) {
				result = id;
			}
			else {
				result = id = OrganisationIdentification15Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("ctry")
		@RuneAttribute("ctry")
		public String getCtry() {
			return ctry;
		}
		
		@RosettaAttribute(value="id", isRequired=true)
		@RuneAttribute(value="id", isRequired=true)
		@Override
		public LegalPersonIdentification1.LegalPersonIdentification1Builder setId(OrganisationIdentification15Choice _id) {
			this.id = _id == null ? null : _id.toBuilder();
			return this;
		}
		
		@RosettaAttribute("ctry")
		@RuneAttribute("ctry")
		@Override
		public LegalPersonIdentification1.LegalPersonIdentification1Builder setCtry(String _ctry) {
			this.ctry = _ctry == null ? null : _ctry;
			return this;
		}
		
		@Override
		public LegalPersonIdentification1 build() {
			return new LegalPersonIdentification1.LegalPersonIdentification1Impl(this);
		}
		
		@Override
		public LegalPersonIdentification1.LegalPersonIdentification1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public LegalPersonIdentification1.LegalPersonIdentification1Builder prune() {
			if (id!=null && !id.prune().hasData()) id = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getId()!=null && getId().hasData()) return true;
			if (getCtry()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public LegalPersonIdentification1.LegalPersonIdentification1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			LegalPersonIdentification1.LegalPersonIdentification1Builder o = (LegalPersonIdentification1.LegalPersonIdentification1Builder) other;
			
			merger.mergeRosetta(getId(), o.getId(), this::setId);
			
			merger.mergeBasic(getCtry(), o.getCtry(), this::setCtry);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			LegalPersonIdentification1 _that = getType().cast(o);
		
			if (!Objects.equals(id, _that.getId())) return false;
			if (!Objects.equals(ctry, _that.getCtry())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (id != null ? id.hashCode() : 0);
			_result = 31 * _result + (ctry != null ? ctry.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "LegalPersonIdentification1Builder {" +
				"id=" + this.id + ", " +
				"ctry=" + this.ctry +
			'}';
		}
	}
}
