package iso20022.auth108.iso.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth108.iso.TechnicalAttributes6;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class TechnicalAttributes6TypeFormatValidator implements Validator<TechnicalAttributes6> {

	private List<ComparisonResult> getComparisonResults(TechnicalAttributes6 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("techRcrdId", o.getTechRcrdId(), 1, of(140), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, TechnicalAttributes6 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("TechnicalAttributes6", ValidationResult.ValidationType.TYPE_FORMAT, "TechnicalAttributes6", path, "", res.getError());
				}
				return success("TechnicalAttributes6", ValidationResult.ValidationType.TYPE_FORMAT, "TechnicalAttributes6", path, "");
			})
			.collect(toList());
	}

}
