package iso20022.dtcc.rds.harmonized.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.dtcc.rds.harmonized.HarmonizedData;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class HarmonizedDataValidator implements Validator<HarmonizedData> {

	private List<ComparisonResult> getComparisonResults(HarmonizedData o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("leg2CommodityInstrumentId", (String) o.getLeg2CommodityInstrumentId() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2CommodityUnderlyerId", (String) o.getLeg2CommodityUnderlyerId() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2CommodityUnderlyerDetails", (String) o.getLeg2CommodityUnderlyerDetails() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2CommodityUnitOfMeasure", (String) o.getLeg2CommodityUnitOfMeasure() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2CommodityCurrency", (String) o.getLeg2CommodityCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2CommodityExchangeId", (String) o.getLeg2CommodityExchangeId() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1CommodityRateSource", (String) o.getLeg1CommodityRateSource() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1CommodityRateSourcePage", (String) o.getLeg1CommodityRateSourcePage() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2SpecifiedPrice", (String) o.getLeg2SpecifiedPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("commencementDateUnadjusted", (Date) o.getCommencementDateUnadjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("exerciseExpirationDateUnadjusted", (Date) o.getExerciseExpirationDateUnadjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("expirationDateUnadjusted", (Date) o.getExpirationDateUnadjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2NotionalQuantityFrequency", (String) o.getLeg2NotionalQuantityFrequency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2NotionalQuantity", (BigDecimal) o.getLeg2NotionalQuantity() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2TotalNotionalQuantity", (BigDecimal) o.getLeg2TotalNotionalQuantity() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2SpreadAmount", (BigDecimal) o.getLeg2SpreadAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2SpreadCurrency", (String) o.getLeg2SpreadCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("scheduledTerminationDateAdjusted", (Date) o.getScheduledTerminationDateAdjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1PartyPayer", (String) o.getLeg1PartyPayer() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2PartyPayer", (String) o.getLeg2PartyPayer() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1CommodityInstrumentId", (String) o.getLeg1CommodityInstrumentId() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1CommodityUnderlyerId", (String) o.getLeg1CommodityUnderlyerId() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1CommodityUnitOfMeasure", (String) o.getLeg1CommodityUnitOfMeasure() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1CommodityExchangeId", (String) o.getLeg1CommodityExchangeId() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2CommodityRateSource", (String) o.getLeg2CommodityRateSource() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1EffectiveDateUnadjusted", (Date) o.getLeg1EffectiveDateUnadjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2EffectiveDateUnadjusted", (Date) o.getLeg2EffectiveDateUnadjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("coProductType", (String) o.getCoProductType() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalQuantityUnit", (String) o.getTotalQuantityUnit() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalQuantity", (BigDecimal) o.getTotalQuantity() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedPrice", (BigDecimal) o.getFixedPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedPriceCurrency", (String) o.getFixedPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1NotionalQuantityUnit", (String) o.getLeg1NotionalQuantityUnit() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1NotionalQuantityFrequency", (String) o.getLeg1NotionalQuantityFrequency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1NotionalQuantity", (BigDecimal) o.getLeg1NotionalQuantity() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1TotalNotionalQuantity", (BigDecimal) o.getLeg1TotalNotionalQuantity() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1CommodityCurrency", (String) o.getLeg1CommodityCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1SpecifiedPrice", (String) o.getLeg1SpecifiedPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1SpreadCurrency", (String) o.getLeg1SpreadCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1SpreadAmount", (BigDecimal) o.getLeg1SpreadAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2NotionalQuantityUnit", (String) o.getLeg2NotionalQuantityUnit() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2PartyReceiver", (String) o.getLeg2PartyReceiver() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1PartyReceiver", (String) o.getLeg1PartyReceiver() != null ? 1 : 0, 0, 1), 
				checkCardinality("coalSource", (String) o.getCoalSource() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2Quantity", (BigDecimal) o.getLeg2Quantity() != null ? 1 : 0, 0, 1), 
				checkCardinality("commodityBase", (String) o.getCommodityBase() != null ? 1 : 0, 0, 1), 
				checkCardinality("commodityDetails", (String) o.getCommodityDetails() != null ? 1 : 0, 0, 1), 
				checkCardinality("interconnectionPoint", (String) o.getInterconnectionPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("loadType", (String) o.getLoadType() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedPriceUnit", (String) o.getFixedPriceUnit() != null ? 1 : 0, 0, 1), 
				checkCardinality("exercisePaymentDateUnadjusted", (Date) o.getExercisePaymentDateUnadjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1PaymentDatesUnadjusted", (Date) o.getLeg1PaymentDatesUnadjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2PaymentDateUnadjusted", (Date) o.getLeg2PaymentDateUnadjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementDateUnadjusted", (Date) o.getSettlementDateUnadjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("deliveryLocation", (String) o.getDeliveryLocation() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2QuantityUnit", (String) o.getLeg2QuantityUnit() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1CommodityUnderlyerDetails", (String) o.getLeg1CommodityUnderlyerDetails() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2CommodityRateSourcePage", (String) o.getLeg2CommodityRateSourcePage() != null ? 1 : 0, 0, 1), 
				checkCardinality("valueDate", (Date) o.getValueDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("gtrQuantityUnit", (String) o.getGtrQuantityUnit() != null ? 1 : 0, 0, 1), 
				checkCardinality("attachmentPoint", (BigDecimal) o.getAttachmentPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("exhaustionPoint", (BigDecimal) o.getExhaustionPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("mthToDefault", (BigDecimal) o.getMthToDefault() != null ? 1 : 0, 0, 1), 
				checkCardinality("nthToDefault", (BigDecimal) o.getNthToDefault() != null ? 1 : 0, 0, 1), 
				checkCardinality("seniority", (String) o.getSeniority() != null ? 1 : 0, 0, 1), 
				checkCardinality("series", (BigDecimal) o.getSeries() != null ? 1 : 0, 0, 1), 
				checkCardinality("crversion", (BigDecimal) o.getCrversion() != null ? 1 : 0, 0, 1), 
				checkCardinality("tranche", (String) o.getTranche() != null ? 1 : 0, 0, 1), 
				checkCardinality("indexFactor", (BigDecimal) o.getIndexFactor() != null ? 1 : 0, 0, 1), 
				checkCardinality("referenceObligation", (String) o.getReferenceObligation() != null ? 1 : 0, 0, 1), 
				checkCardinality("referenceObligationIdType", (String) o.getReferenceObligationIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingFixedRatePayerBuyer", (String) o.getUnderlyingFixedRatePayerBuyer() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingFloatRatePayerSeller", (String) o.getUnderlyingFloatRatePayerSeller() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingAssetExchangeId", (String) o.getUnderlyingAssetExchangeId() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingAssetNumberOfUnits", (BigDecimal) o.getUnderlyingAssetNumberOfUnits() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionalEarlyTerminationType", (String) o.getOptionalEarlyTerminationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionalEarlyTerminationElectingPartyValue", (String) o.getOptionalEarlyTerminationElectingPartyValue() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionalEarlyTerminationIndicator", (Boolean) o.getOptionalEarlyTerminationIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingAssetFloatingAmountPayer", (String) o.getUnderlyingAssetFloatingAmountPayer() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingAssetFloatingAmountReceiver", (String) o.getUnderlyingAssetFloatingAmountReceiver() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateOption", (String) o.getFloatingRateOption() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingAssetFloatingLegSpread", (BigDecimal) o.getUnderlyingAssetFloatingLegSpread() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2DesignatedMaturityPeriod", (String) o.getLeg2DesignatedMaturityPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2DesignatedMaturityPeriodMultiplier", (BigDecimal) o.getLeg2DesignatedMaturityPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingAssetEquityAmountPayer", (String) o.getUnderlyingAssetEquityAmountPayer() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingAssetEquityAmountReceiver", (String) o.getUnderlyingAssetEquityAmountReceiver() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingAssetInitialPriceCurrency", (String) o.getUnderlyingAssetInitialPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1ValuationDates", (Date) o.getLeg1ValuationDates() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1TypeOfReturn", (String) o.getLeg1TypeOfReturn() != null ? 1 : 0, 0, 1), 
				checkCardinality("observationStartDate", (Date) o.getObservationStartDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("varianceAmount", (BigDecimal) o.getVarianceAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("volatilityStrikePrice", (BigDecimal) o.getVolatilityStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("varianceStrikePrice", (BigDecimal) o.getVarianceStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("varianceCapFactor", (BigDecimal) o.getVarianceCapFactor() != null ? 1 : 0, 0, 1), 
				checkCardinality("referenceCurrency", (String) o.getReferenceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("specialDividendsIndicator", (String) o.getSpecialDividendsIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("materialNoncashDividendIndicator", (String) o.getMaterialNoncashDividendIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("numberOfSharesUnits", (BigDecimal) o.getNumberOfSharesUnits() != null ? 1 : 0, 0, 1), 
				checkCardinality("dividendAmountPayer", (String) o.getDividendAmountPayer() != null ? 1 : 0, 0, 1), 
				checkCardinality("dividendAmountReceiver", (String) o.getDividendAmountReceiver() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedAmountPayer", (String) o.getFixedAmountPayer() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedAmountReceiver", (String) o.getFixedAmountReceiver() != null ? 1 : 0, 0, 1), 
				checkCardinality("knockInEvent", (String) o.getKnockInEvent() != null ? 1 : 0, 0, 1), 
				checkCardinality("knockOutEvent", (String) o.getKnockOutEvent() != null ? 1 : 0, 0, 1), 
				checkCardinality("knockInPrice", (BigDecimal) o.getKnockInPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("knockOutPrice", (BigDecimal) o.getKnockOutPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("barrierType", (String) o.getBarrierType() != null ? 1 : 0, 0, 1), 
				checkCardinality("earliestExecutionTime", (LocalTime) o.getEarliestExecutionTime() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRate", (BigDecimal) o.getExchangeRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRateBasisCurrency1", (String) o.getExchangeRateBasisCurrency1() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRateBasisCurrency2", (String) o.getExchangeRateBasisCurrency2() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionPeriodStartDate", (Date) o.getExecutionPeriodStartDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("payoutStyle", (String) o.getPayoutStyle() != null ? 1 : 0, 0, 1), 
				checkCardinality("rateQuoteBasis1", (String) o.getRateQuoteBasis1() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementFixingDate", (Date) o.getSettlementFixingDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("swapLinkId", (String) o.getSwapLinkId() != null ? 1 : 0, 0, 1), 
				checkCardinality("triggerCondition", (String) o.getTriggerCondition() != null ? 1 : 0, 0, 1), 
				checkCardinality("triggerCondition2", (String) o.getTriggerCondition2() != null ? 1 : 0, 0, 1), 
				checkCardinality("triggerRate", (BigDecimal) o.getTriggerRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("triggerRate2", (BigDecimal) o.getTriggerRate2() != null ? 1 : 0, 0, 1), 
				checkCardinality("rateQuoteBasis2", (String) o.getRateQuoteBasis2() != null ? 1 : 0, 0, 1), 
				checkCardinality("forwardExchangeRate", (BigDecimal) o.getForwardExchangeRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("barrierType2", (String) o.getBarrierType2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cancelationOptionBuyer", (String) o.getCancelationOptionBuyer() != null ? 1 : 0, 0, 1), 
				checkCardinality("cancelationOptionCommencementDate", (Date) o.getCancelationOptionCommencementDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("cancelationOptionExerciseStyleType", (String) o.getCancelationOptionExerciseStyleType() != null ? 1 : 0, 0, 1), 
				checkCardinality("cancelationOptionExpirationDate", (Date) o.getCancelationOptionExpirationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("cancelationOptionInitialFeeCurrency", (String) o.getCancelationOptionInitialFeeCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("cancelationOptionInitialFeePayer", (String) o.getCancelationOptionInitialFeePayer() != null ? 1 : 0, 0, 1), 
				checkCardinality("cancelationOptionPremiumAmount", (BigDecimal) o.getCancelationOptionPremiumAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("cancelationOptionSeller", (String) o.getCancelationOptionSeller() != null ? 1 : 0, 0, 1), 
				checkCardinality("capRateInitial", (BigDecimal) o.getCapRateInitial() != null ? 1 : 0, 0, 1), 
				checkCardinality("couponType", (String) o.getCouponType() != null ? 1 : 0, 0, 1), 
				checkCardinality("finalPrincipalExchangeIndicatorAtTermination", (Boolean) o.getFinalPrincipalExchangeIndicatorAtTermination() != null ? 1 : 0, 0, 1), 
				checkCardinality("floorRateInitial", (BigDecimal) o.getFloorRateInitial() != null ? 1 : 0, 0, 1), 
				checkCardinality("fraDiscountingType", (String) o.getFraDiscountingType() != null ? 1 : 0, 0, 1), 
				checkCardinality("inflationIndexInitialLevel", (BigDecimal) o.getInflationIndexInitialLevel() != null ? 1 : 0, 0, 1), 
				checkCardinality("inflationIndexMainPublication", (String) o.getInflationIndexMainPublication() != null ? 1 : 0, 0, 1), 
				checkCardinality("inflationInterpolationMethod", (String) o.getInflationInterpolationMethod() != null ? 1 : 0, 0, 1), 
				checkCardinality("inflationLagDayType", (String) o.getInflationLagDayType() != null ? 1 : 0, 0, 1), 
				checkCardinality("inflationLagPeriod", (String) o.getInflationLagPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("inflationRateSourceName", (String) o.getInflationRateSourceName() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialPrincipalExchangeIndicator", (Boolean) o.getInitialPrincipalExchangeIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("intermediatePrincipalExchangeIndicator", (Boolean) o.getIntermediatePrincipalExchangeIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1FloatingRateIndex", (String) o.getLeg1FloatingRateIndex() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1FloatingRateInitialSpread", (BigDecimal) o.getLeg1FloatingRateInitialSpread() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1FloatingRateMultiplierInitialValue", (BigDecimal) o.getLeg1FloatingRateMultiplierInitialValue() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1FloatingRateTenorPeriod", (String) o.getLeg1FloatingRateTenorPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1FloatingRateTenorPeriodMultiplier", (BigDecimal) o.getLeg1FloatingRateTenorPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1KnownAmount", (BigDecimal) o.getLeg1KnownAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1KnownAmountCurrency", (String) o.getLeg1KnownAmountCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1ReferenceCurrency", (String) o.getLeg1ReferenceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2FloatingRateIndex", (String) o.getLeg2FloatingRateIndex() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2FloatingRateInitialSpread", (BigDecimal) o.getLeg2FloatingRateInitialSpread() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2FloatingRateMultiplierInitialValue", (BigDecimal) o.getLeg2FloatingRateMultiplierInitialValue() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2FloatingRateTenorPeriod", (String) o.getLeg2FloatingRateTenorPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2FloatingRateTenorPeriodMultiplier", (BigDecimal) o.getLeg2FloatingRateTenorPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2KnownAmount", (BigDecimal) o.getLeg2KnownAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2KnownAmountCurrency", (String) o.getLeg2KnownAmountCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2ReferenceCurrency", (String) o.getLeg2ReferenceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("mandatoryEarlyTerminationDate", (Date) o.getMandatoryEarlyTerminationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("mandatoryEarlyTerminationDateTenorPeriod", (String) o.getMandatoryEarlyTerminationDateTenorPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("mandatoryEarlyTerminationDateTenorPeriodMultiplier", (String) o.getMandatoryEarlyTerminationDateTenorPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalUnits", (BigDecimal) o.getNotionalUnits() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionalEarlyTerminationCommencementDate", (Date) o.getOptionalEarlyTerminationCommencementDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionalEarlyTerminationExerciseStyle", (String) o.getOptionalEarlyTerminationExerciseStyle() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionalEarlyTerminationExpirationDate", (Date) o.getOptionalEarlyTerminationExpirationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("premiumReceiver", (String) o.getPremiumReceiver() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingCouponRate", (BigDecimal) o.getUnderlyingCouponRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingMaturityDate", (Date) o.getUnderlyingMaturityDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingProductId", (String) o.getUnderlyingProductId() != null ? 1 : 0, 0, 1), 
				checkCardinality("inflationLagPeriodMultiplier", (String) o.getInflationLagPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1FixedRateNotation", (String) o.getLeg1FixedRateNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2FixedRateNotation", (String) o.getLeg2FixedRateNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("swaptionStraddleIndicator", (String) o.getSwaptionStraddleIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("singlePartyEarlyTerminationBuyer", (String) o.getSinglePartyEarlyTerminationBuyer() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1EffectiveDate", (Date) o.getLeg1EffectiveDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("action", (String) o.getAction() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingStatus", (String) o.getClearingStatus() != null ? 1 : 0, 0, 1), 
				checkCardinality("effectiveDate1", (Date) o.getEffectiveDate1() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionVenueType", (String) o.getExecutionVenueType() != null ? 1 : 0, 0, 1), 
				checkCardinality("nonStandardTradeIndicator", (Boolean) o.getNonStandardTradeIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalAmount1", (BigDecimal) o.getNotionalAmount1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrency1", (String) o.getNotionalCurrency1() != null ? 1 : 0, 0, 1), 
				checkCardinality("price1Price", (BigDecimal) o.getPrice1Price() != null ? 1 : 0, 0, 1), 
				checkCardinality("price1Type", (String) o.getPrice1Type() != null ? 1 : 0, 0, 1), 
				checkCardinality("price1Units", (String) o.getPrice1Units() != null ? 1 : 0, 0, 1), 
				checkCardinality("scheduledTerminationDate1", (Date) o.getScheduledTerminationDate1() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeDate", (Date) o.getTradeDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1CollateralizationType", (String) o.getTradeParty1CollateralizationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1EventId", (String) o.getTradeParty1EventId() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2CollateralizationType", (String) o.getTradeParty2CollateralizationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2EventId", (String) o.getTradeParty2EventId() != null ? 1 : 0, 0, 1), 
				checkCardinality("embeddedOptionOnSwap", (String) o.getEmbeddedOptionOnSwap() != null ? 1 : 0, 0, 1), 
				checkCardinality("expirationDate", (Date) o.getExpirationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalAmount2", (BigDecimal) o.getNotionalAmount2() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrency2", (String) o.getNotionalCurrency2() != null ? 1 : 0, 0, 1), 
				checkCardinality("premiumAmount", (BigDecimal) o.getPremiumAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("premiumCurrency", (String) o.getPremiumCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("version", (String) o.getVersion() != null ? 1 : 0, 0, 1), 
				checkCardinality("comment1", (String) o.getComment1() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionStyle", (String) o.getOptionStyle() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionType", (String) o.getOptionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrency1", (String) o.getSettlementCurrency1() != null ? 1 : 0, 0, 1), 
				checkCardinality("commencementDate", (Date) o.getCommencementDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("dayCountFraction1", (String) o.getDayCountFraction1() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2DayCountFraction", (String) o.getLeg2DayCountFraction() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2EffectiveDate", (Date) o.getLeg2EffectiveDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2ResetFrequencyPeriod", (String) o.getLeg2ResetFrequencyPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2ResetFrequencyPeriodMultiplier", (BigDecimal) o.getLeg2ResetFrequencyPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2SettlementCurrency", (String) o.getLeg2SettlementCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2ScheduledTerminationDate", (Date) o.getLeg2ScheduledTerminationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("numberOfOptions", (BigDecimal) o.getNumberOfOptions() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionEntitlement", (BigDecimal) o.getOptionEntitlement() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalExecutionTimestamp", (ZonedDateTime) o.getOriginalExecutionTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment1Date", (Date) o.getPayment1Date() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment1FrequencyPeriod", (String) o.getPayment1FrequencyPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment1FrequencyPeriodMultiplier", (BigDecimal) o.getPayment1FrequencyPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment2Date", (Date) o.getPayment2Date() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment2FrequencyPeriod", (String) o.getPayment2FrequencyPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment2FrequencyPeriodMultiplier", (BigDecimal) o.getPayment2FrequencyPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("resetFrequencyPeriod1", (String) o.getResetFrequencyPeriod1() != null ? 1 : 0, 0, 1), 
				checkCardinality("resetFrequencyPeriodMultiplier1", (BigDecimal) o.getResetFrequencyPeriodMultiplier1() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementDate", (Date) o.getSettlementDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePrice", (BigDecimal) o.getStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceUnits", (String) o.getStrikePriceUnits() != null ? 1 : 0, 0, 1), 
				checkCardinality("asOfDateTime", (ZonedDateTime) o.getAsOfDateTime() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingVenueId", (String) o.getClearingVenueId() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingVenueIdType", (String) o.getClearingVenueIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("compressedTradeIndicator", (String) o.getCompressedTradeIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("confirmationMethod", (String) o.getConfirmationMethod() != null ? 1 : 0, 0, 1), 
				checkCardinality("confirmationPlatformId", (String) o.getConfirmationPlatformId() != null ? 1 : 0, 0, 1), 
				checkCardinality("confirmationPlatformTradeId", (String) o.getConfirmationPlatformTradeId() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionVenueId", (String) o.getExecutionVenueId() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionVenueIdType", (String) o.getExecutionVenueIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("postTradeEffectiveDate", (Date) o.getPostTradeEffectiveDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUsiId", (String) o.getPriorUsiId() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUsiIdPrefix", (String) o.getPriorUsiIdPrefix() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUtiId", (String) o.getPriorUtiId() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUtiIdPrefix", (String) o.getPriorUtiIdPrefix() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1BranchLocation", (String) o.getTradeParty1BranchLocation() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1ClearingBrokerId", (String) o.getTradeParty1ClearingBrokerId() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1ClearingBrokerIdType", (String) o.getTradeParty1ClearingBrokerIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1DeskLocation", (String) o.getTradeParty1DeskLocation() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1Domicile", (String) o.getTradeParty1Domicile() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1IndustrialSectorType", (String) o.getTradeParty1IndustrialSectorType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2BranchLocation", (String) o.getTradeParty2BranchLocation() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2DeskLocation", (String) o.getTradeParty2DeskLocation() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2Domicile", (String) o.getTradeParty2Domicile() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2IndustrialSectorType", (String) o.getTradeParty2IndustrialSectorType() != null ? 1 : 0, 0, 1), 
				checkCardinality("sellerPayer2", (String) o.getSellerPayer2() != null ? 1 : 0, 0, 1), 
				checkCardinality("buyerPayer1", (String) o.getBuyerPayer1() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1HkCounterpartyOrigin", (String) o.getTradeParty1HkCounterpartyOrigin() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2SettlementDate", (Date) o.getLeg2SettlementDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1FixedRateInitial", (BigDecimal) o.getLeg1FixedRateInitial() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2FixedRateInitial", (BigDecimal) o.getLeg2FixedRateInitial() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment1Amount", (BigDecimal) o.getPayment1Amount() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment1Currency", (String) o.getPayment1Currency() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment1Payer", (String) o.getPayment1Payer() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment1Receiver", (String) o.getPayment1Receiver() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment2Payer", (String) o.getPayment2Payer() != null ? 1 : 0, 0, 1), 
				checkCardinality("postTradeTransactionDate", (Date) o.getPostTradeTransactionDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("secondaryAssetClass", (String) o.getSecondaryAssetClass() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementType", (String) o.getSettlementType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1Name", (String) o.getTradeParty1Name() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2Name", (String) o.getTradeParty2Name() != null ? 1 : 0, 0, 1), 
				checkCardinality("ccpValuationAmount", (BigDecimal) o.getCcpValuationAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("ccpValuationCurrency", (String) o.getCcpValuationCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("ccpValuationDatetime", (ZonedDateTime) o.getCcpValuationDatetime() != null ? 1 : 0, 0, 1), 
				checkCardinality("ccpValuationType", (String) o.getCcpValuationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1ValuationAmount", (BigDecimal) o.getTradeParty1ValuationAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1ValuationCurrency", (String) o.getTradeParty1ValuationCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1ValuationDatetime", (ZonedDateTime) o.getTradeParty1ValuationDatetime() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1ValuationType", (String) o.getTradeParty1ValuationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2ValuationAmount", (BigDecimal) o.getTradeParty2ValuationAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2ValuationCurrency", (String) o.getTradeParty2ValuationCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2ValuationDatetime", (ZonedDateTime) o.getTradeParty2ValuationDatetime() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2ValuationType", (String) o.getTradeParty2ValuationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionType", (String) o.getExecutionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceCurrency", (String) o.getStrikePriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment2Amount", (BigDecimal) o.getPayment2Amount() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2HkCounterpartyOrigin", (String) o.getTradeParty2HkCounterpartyOrigin() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1CountryOfTheOtherCounterparty", (String) o.getTradeParty1CountryOfTheOtherCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2CountryOfTheOtherCounterparty", (String) o.getTradeParty2CountryOfTheOtherCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1BrokerId", (String) o.getTradeParty1BrokerId() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2BrokerId", (String) o.getTradeParty2BrokerId() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1BeneficiaryIdType", (String) o.getTradeParty1BeneficiaryIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1BeneficiaryId", (String) o.getTradeParty1BeneficiaryId() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2BeneficiaryIdType", (String) o.getTradeParty2BeneficiaryIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2BeneficiaryId", (String) o.getTradeParty2BeneficiaryId() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1CounterpartySide", (String) o.getTradeParty1CounterpartySide() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2CounterpartySide", (String) o.getTradeParty2CounterpartySide() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1CollateralPortfolioCode", (String) o.getTradeParty1CollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2CollateralPortfolioCode", (String) o.getTradeParty2CollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("contractType", (String) o.getContractType() != null ? 1 : 0, 0, 1), 
				checkCardinality("euUnderlyingAssetIdType", (String) o.getEuUnderlyingAssetIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("productClassification", (String) o.getProductClassification() != null ? 1 : 0, 0, 1), 
				checkCardinality("complexTradeComponentId", (String) o.getComplexTradeComponentId() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceMultiplier", (BigDecimal) o.getPriceMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantity", (BigDecimal) o.getQuantity() != null ? 1 : 0, 0, 1), 
				checkCardinality("masterAgreementType", (String) o.getMasterAgreementType() != null ? 1 : 0, 0, 1), 
				checkCardinality("masterAgreementVersion", (String) o.getMasterAgreementVersion() != null ? 1 : 0, 0, 1), 
				checkCardinality("confirmationDatetime", (ZonedDateTime) o.getConfirmationDatetime() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingDatetime", (ZonedDateTime) o.getClearingDatetime() != null ? 1 : 0, 0, 1), 
				checkCardinality("maturityDateOfTheUnderlying", (Date) o.getMaturityDateOfTheUnderlying() != null ? 1 : 0, 0, 1), 
				checkCardinality("level", (String) o.getLevel() != null ? 1 : 0, 0, 1), 
				checkCardinality("productClassificationType", (String) o.getProductClassificationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("productIdentificationType", (String) o.getProductIdentificationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("productIdentification", (String) o.getProductIdentification() != null ? 1 : 0, 0, 1), 
				checkCardinality("euUnderlyingAssetId", (String) o.getEuUnderlyingAssetId() != null ? 1 : 0, 0, 1), 
				checkCardinality("reportTrackingNumber", (String) o.getReportTrackingNumber() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1BrokerIdType", (String) o.getTradeParty1BrokerIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2BrokerIdType", (String) o.getTradeParty2BrokerIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2ClearingBrokerIdType", (String) o.getTradeParty2ClearingBrokerIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2ClearingBrokerId", (String) o.getTradeParty2ClearingBrokerId() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1ClearingThreshold", (Boolean) o.getTradeParty1ClearingThreshold() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2ClearingThreshold", (Boolean) o.getTradeParty2ClearingThreshold() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1CorporateSectorType", (String) o.getTradeParty1CorporateSectorType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2CorporateSectorType", (String) o.getTradeParty2CorporateSectorType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator", (String) o.getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator", (String) o.getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("intragroupIndicator", (Boolean) o.getIntragroupIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1TradingCapacity1", (String) o.getTradeParty1TradingCapacity1() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2TradingCapacity1", (String) o.getTradeParty2TradingCapacity1() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfPrice", (String) o.getCurrencyOfPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1CollateralPortfolio", (String) o.getTradeParty1CollateralPortfolio() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2CollateralPortfolio", (String) o.getTradeParty2CollateralPortfolio() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionVenueMicCode", (String) o.getExecutionVenueMicCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment2Currency", (String) o.getPayment2Currency() != null ? 1 : 0, 0, 1), 
				checkCardinality("expirationDateTimeBusinessCenter", (String) o.getExpirationDateTimeBusinessCenter() != null ? 1 : 0, 0, 1), 
				checkCardinality("expirationTime", (LocalTime) o.getExpirationTime() != null ? 1 : 0, 0, 1), 
				checkCardinality("expirationTimeType", (String) o.getExpirationTimeType() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1TraderLocation", (String) o.getTradeParty1TraderLocation() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2TraderLocation", (String) o.getTradeParty2TraderLocation() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment3ResetFrequencyPeriodMultiplier", (BigDecimal) o.getPayment3ResetFrequencyPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment3ResetFrequencyPeriod", (String) o.getPayment3ResetFrequencyPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment4ResetFrequencyPeriodMultiplier", (BigDecimal) o.getPayment4ResetFrequencyPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment4ResetFrequencyPeriod", (String) o.getPayment4ResetFrequencyPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment5ResetFrequencyPeriodMultiplier", (BigDecimal) o.getPayment5ResetFrequencyPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment5ResetFrequencyPeriod", (String) o.getPayment5ResetFrequencyPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment1Type", (String) o.getPayment1Type() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment1Reference", (String) o.getPayment1Reference() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment2Type", (String) o.getPayment2Type() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment2Reference", (String) o.getPayment2Reference() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment3Payer", (String) o.getPayment3Payer() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment3Reference", (String) o.getPayment3Reference() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment3FrequencyPeriod", (String) o.getPayment3FrequencyPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment3FrequencyPeriodMultiplier", (BigDecimal) o.getPayment3FrequencyPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment3Date", (Date) o.getPayment3Date() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment4Reference", (String) o.getPayment4Reference() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment4Payer", (String) o.getPayment4Payer() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment4FrequencyPeriod", (String) o.getPayment4FrequencyPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment4FrequencyPeriodMultiplier", (BigDecimal) o.getPayment4FrequencyPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment4Date", (Date) o.getPayment4Date() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment5Reference", (String) o.getPayment5Reference() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment5Payer", (String) o.getPayment5Payer() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment5FrequencyPeriod", (String) o.getPayment5FrequencyPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment5FrequencyPeriodMultiplier", (BigDecimal) o.getPayment5FrequencyPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment5Date", (Date) o.getPayment5Date() != null ? 1 : 0, 0, 1), 
				checkCardinality("payment3Type", (String) o.getPayment3Type() != null ? 1 : 0, 0, 1), 
				checkCardinality("premiumPayer", (String) o.getPremiumPayer() != null ? 1 : 0, 0, 1), 
				checkCardinality("premiumPaymentDateUnadjusted", (Date) o.getPremiumPaymentDateUnadjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1NatureOfTheReportingCounterparty", (String) o.getTradeParty1NatureOfTheReportingCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2NatureOfTheReportingCounterparty", (String) o.getTradeParty2NatureOfTheReportingCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("reservedParticipantUse1", (String) o.getReservedParticipantUse1() != null ? 1 : 0, 0, 1), 
				checkCardinality("reservedParticipantUse2", (String) o.getReservedParticipantUse2() != null ? 1 : 0, 0, 1), 
				checkCardinality("reservedParticipantUse3", (String) o.getReservedParticipantUse3() != null ? 1 : 0, 0, 1), 
				checkCardinality("reservedParticipantUse4", (String) o.getReservedParticipantUse4() != null ? 1 : 0, 0, 1), 
				checkCardinality("reservedParticipantUse5", (String) o.getReservedParticipantUse5() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1TerminationDate", (Date) o.getLeg1TerminationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("allocationType", (String) o.getAllocationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("calculationBasis", (String) o.getCalculationBasis() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingExceptionPartyId", (String) o.getClearingExceptionPartyId() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingExceptionPartyIdType", (String) o.getClearingExceptionPartyIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingExceptionType", (String) o.getClearingExceptionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingMemberClientAccountId", (String) o.getClearingMemberClientAccountId() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingReceiptDatetime", (ZonedDateTime) o.getClearingReceiptDatetime() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingSwapSdrLeiId", (String) o.getClearingSwapSdrLeiId() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingSwapUtiId", (String) o.getClearingSwapUtiId() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralReportingDate", (Date) o.getCollateralReportingDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralValuationDatetime", (ZonedDateTime) o.getCollateralValuationDatetime() != null ? 1 : 0, 0, 1), 
				checkCardinality("comment2", (String) o.getComment2() != null ? 1 : 0, 0, 1), 
				checkCardinality("commodityStrikePriceUnit", (String) o.getCommodityStrikePriceUnit() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionAgentMaskingIndicator", (String) o.getExecutionAgentMaskingIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("feeInCurrency", (String) o.getFeeInCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("feeOutCurrency", (String) o.getFeeOutCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyLeg1Multiplier", (BigDecimal) o.getFloatingRatePaymentFrequencyLeg1Multiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyLeg1TimePeriod", (String) o.getFloatingRatePaymentFrequencyLeg1TimePeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyLeg2Multiplier", (BigDecimal) o.getFloatingRatePaymentFrequencyLeg2Multiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyLeg2TimePeriod", (String) o.getFloatingRatePaymentFrequencyLeg2TimePeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("frequencyOfPayment", (String) o.getFrequencyOfPayment() != null ? 1 : 0, 0, 1), 
				checkCardinality("interaffiliate", (Boolean) o.getInteraffiliate() != null ? 1 : 0, 0, 1), 
				checkCardinality("largeTradeIndicator", (Boolean) o.getLargeTradeIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1EffectiveDateAdjusted", (Date) o.getLeg1EffectiveDateAdjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1FinalValuationDate", (Date) o.getLeg1FinalValuationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg1SettlementPeriod", (String) o.getLeg1SettlementPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2EffectiveDateAdjusted", (Date) o.getLeg2EffectiveDateAdjusted() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2PaymentTermsFrequencyPeriod", (String) o.getLeg2PaymentTermsFrequencyPeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2PaymentTermsPaymentFrequencyPeriodMultiplier", (BigDecimal) o.getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2SettlementType", (String) o.getLeg2SettlementType() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2UnderlyingAssetId", (String) o.getLeg2UnderlyingAssetId() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2UnderlyingAssetIdType", (String) o.getLeg2UnderlyingAssetIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2UnderlyingAssetName", (String) o.getLeg2UnderlyingAssetName() != null ? 1 : 0, 0, 1), 
				checkCardinality("maturityDate", (Date) o.getMaturityDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionalEarlyTerminationDate", (String) o.getOptionalEarlyTerminationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionCommodityCurrency", (String) o.getOptionCommodityCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionCommodityExchangeId", (String) o.getOptionCommodityExchangeId() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionCommodityInstrumentId", (String) o.getOptionCommodityInstrumentId() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionCommodityRateSource", (String) o.getOptionCommodityRateSource() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionCommodityRateSourcePage", (String) o.getOptionCommodityRateSourcePage() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionCommodityUnderlyerDetails", (String) o.getOptionCommodityUnderlyerDetails() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionCommodityUnderlyerId", (String) o.getOptionCommodityUnderlyerId() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionCommodityUnitOfMeasure", (String) o.getOptionCommodityUnitOfMeasure() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionSpecifiedPrice", (String) o.getOptionSpecifiedPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionSpreadAmount", (BigDecimal) o.getOptionSpreadAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionSpreadCurrency", (String) o.getOptionSpreadCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionSpreadSchedule", (String) o.getOptionSpreadSchedule() != null ? 1 : 0, 0, 1), 
				checkCardinality("origin", (String) o.getOrigin() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalSwapSdrId", (String) o.getOriginalSwapSdrId() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalSwapSdrIdType", (String) o.getOriginalSwapSdrIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("paymentFrequencyPeriodLeg1", (String) o.getPaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("paymentFrequencyPeriodLeg2", (String) o.getPaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("paymentFrequencyPeriodMultiplierLeg1", (BigDecimal) o.getPaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("paymentFrequencyPeriodMultiplierLeg2", (BigDecimal) o.getPaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("premiumPayerPrefix", (String) o.getPremiumPayerPrefix() != null ? 1 : 0, 0, 1), 
				checkCardinality("price1Currency", (String) o.getPrice1Currency() != null ? 1 : 0, 0, 1), 
				checkCardinality("price2Price", (BigDecimal) o.getPrice2Price() != null ? 1 : 0, 0, 1), 
				checkCardinality("price2Type", (String) o.getPrice2Type() != null ? 1 : 0, 0, 1), 
				checkCardinality("price2Units", (String) o.getPrice2Units() != null ? 1 : 0, 0, 1), 
				checkCardinality("price3Price", (BigDecimal) o.getPrice3Price() != null ? 1 : 0, 0, 1), 
				checkCardinality("price3Type", (String) o.getPrice3Type() != null ? 1 : 0, 0, 1), 
				checkCardinality("price3Units", (String) o.getPrice3Units() != null ? 1 : 0, 0, 1), 
				checkCardinality("price4Price", (BigDecimal) o.getPrice4Price() != null ? 1 : 0, 0, 1), 
				checkCardinality("price4Type", (String) o.getPrice4Type() != null ? 1 : 0, 0, 1), 
				checkCardinality("price4Units", (String) o.getPrice4Units() != null ? 1 : 0, 0, 1), 
				checkCardinality("pricingContext", (String) o.getPricingContext() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUsiType", (String) o.getPriorUsiType() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUtiType", (String) o.getPriorUtiType() != null ? 1 : 0, 0, 1), 
				checkCardinality("recoveryPrice", (BigDecimal) o.getRecoveryPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("sendToDataCenterCode", (String) o.getSendToDataCenterCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceType", (String) o.getStrikePriceType() != null ? 1 : 0, 0, 1), 
				checkCardinality("subAssetClassForOtherCommodity", (String) o.getSubAssetClassForOtherCommodity() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1CftcFinancialEntityStatus", (String) o.getTradeParty1CftcFinancialEntityStatus() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1CollateralAmount", (BigDecimal) o.getTradeParty1CollateralAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1CollateralCurrency", (String) o.getTradeParty1CollateralCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1MandatoryDelegatedReporting", (String) o.getTradeParty1MandatoryDelegatedReporting() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty1Role", (String) o.getTradeParty1Role() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2CftcFinancialEntityStatus", (String) o.getTradeParty2CftcFinancialEntityStatus() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2CollateralAmount", (BigDecimal) o.getTradeParty2CollateralAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2CollateralCurrency", (String) o.getTradeParty2CollateralCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2MandatoryDelegatedReporting", (String) o.getTradeParty2MandatoryDelegatedReporting() != null ? 1 : 0, 0, 1), 
				checkCardinality("tradeParty2Role", (String) o.getTradeParty2Role() != null ? 1 : 0, 0, 1), 
				checkCardinality("upfrontPayment", (BigDecimal) o.getUpfrontPayment() != null ? 1 : 0, 0, 1), 
				checkCardinality("verificationMethod", (String) o.getVerificationMethod() != null ? 1 : 0, 0, 1), 
				checkCardinality("responsibleDataSubmitterId", (String) o.getResponsibleDataSubmitterId() != null ? 1 : 0, 0, 1), 
				checkCardinality("responsibleDataSubmitterIdType", (String) o.getResponsibleDataSubmitterIdType() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalSwapUsi", (String) o.getOriginalSwapUsi() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalSwapUti", (String) o.getOriginalSwapUti() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeReceiverIdentifierLeg2", (String) o.getCdeReceiverIdentifierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty1FederalEntityIndicator", (Boolean) o.getCounterparty1FederalEntityIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty2FederalEntityIndicator", (Boolean) o.getCounterparty2FederalEntityIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("customBasketIndicator", (Boolean) o.getCustomBasketIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("noaActionType", (String) o.getNoaActionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventType", (String) o.getEventType() != null ? 1 : 0, 0, 1), 
				checkCardinality("amendmentIndicator", (Boolean) o.getAmendmentIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventIdentifier", (String) o.getEventIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeCallAmountLeg1", (BigDecimal) o.getCdeCallAmountLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeCallAmountLeg2", (BigDecimal) o.getCdeCallAmountLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeCallCurrencyLeg1", (String) o.getCdeCallCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeCallCurrencyLeg2", (String) o.getCdeCallCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePutAmountLeg1", (BigDecimal) o.getCdePutAmountLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePutAmountLeg2", (BigDecimal) o.getCdePutAmountLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePutCurrencyLeg1", (String) o.getCdePutCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePutCurrencyLeg2", (String) o.getCdePutCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("leg2QuantityFrequency", (String) o.getLeg2QuantityFrequency() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyMultiplierLeg1", (BigDecimal) o.getQuantityFrequencyMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyMultiplierLeg2", (BigDecimal) o.getQuantityFrequencyMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeQuantityUnitOfMeasureLeg1", (String) o.getCdeQuantityUnitOfMeasureLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeQuantityUnitOfMeasureLeg2", (String) o.getCdeQuantityUnitOfMeasureLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageIndicator", (Boolean) o.getPackageIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePackageIdentifier", (String) o.getCdePackageIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePackageTransactionPrice", (BigDecimal) o.getCdePackageTransactionPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePackageTransactionPriceCurrency", (String) o.getCdePackageTransactionPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePackageTransactionPriceNotation", (String) o.getCdePackageTransactionPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePackageTransactionSpread", (BigDecimal) o.getCdePackageTransactionSpread() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePackageTransactionSpreadCurrency", (String) o.getCdePackageTransactionSpreadCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePackageTransactionSpreadNotation", (String) o.getCdePackageTransactionSpreadNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFixedRateDayCountConventionLeg1", (String) o.getCdeFixedRateDayCountConventionLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFixedRateDayCountConventionLeg2", (String) o.getCdeFixedRateDayCountConventionLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFloatingRateDayCountConventionLeg1", (String) o.getCdeFloatingRateDayCountConventionLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFloatingRateDayCountConventionLeg2", (String) o.getCdeFloatingRateDayCountConventionLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixingDateLeg1", (Date) o.getFixingDateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixingDateLeg2", (Date) o.getFixingDateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFixedRatePaymentFrequencyPeriodLeg1", (String) o.getCdeFixedRatePaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFixedRatePaymentFrequencyPeriodLeg2", (String) o.getCdeFixedRatePaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFloatingRatePaymentFrequencyPeriodLeg1", (String) o.getCdeFloatingRatePaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFloatingRatePaymentFrequencyPeriodLeg2", (String) o.getCdeFloatingRatePaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1", (BigDecimal) o.getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2", (BigDecimal) o.getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1", (BigDecimal) o.getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2", (BigDecimal) o.getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("postPricedSwapIndicator", (Boolean) o.getPostPricedSwapIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePriceCurrency", (String) o.getCdePriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePriceNotation", (String) o.getCdePriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeSpreadNotationLeg1", (String) o.getCdeSpreadNotationLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeSpreadNotationLeg2", (String) o.getCdeSpreadNotationLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeStrikePriceCurrency2", (String) o.getCdeStrikePriceCurrency2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeStrikePriceNotation", (String) o.getCdeStrikePriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFirstExerciseDate", (Date) o.getCdeFirstExerciseDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeFinalContractualSettlementDate", (Date) o.getCdeFinalContractualSettlementDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeSettlementLocationLeg1", (String) o.getCdeSettlementLocationLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeSettlementLocationLeg2", (String) o.getCdeSettlementLocationLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeEffectiveDate", (Date) o.getCdeEffectiveDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeExpirationDate", (Date) o.getCdeExpirationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdePlatformIdentifier", (String) o.getCdePlatformIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("primeBrokerageTransactionIndicator", (Boolean) o.getPrimeBrokerageTransactionIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("swapReportingJurisdiction", (String) o.getSwapReportingJurisdiction() != null ? 1 : 0, 0, 1), 
				checkCardinality("newSdrIdentifier", (String) o.getNewSdrIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("nextFloatingReferenceResetDateLeg1", (Date) o.getNextFloatingReferenceResetDateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("lastFloatingReferenceValueLeg1", (BigDecimal) o.getLastFloatingReferenceValueLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("lastFloatingReferenceResetDateLeg1", (Date) o.getLastFloatingReferenceResetDateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("nextFloatingReferenceResetDateLeg2", (Date) o.getNextFloatingReferenceResetDateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("lastFloatingReferenceValueLeg2", (BigDecimal) o.getLastFloatingReferenceValueLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("lastFloatingReferenceResetDateLeg2", (Date) o.getLastFloatingReferenceResetDateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeDelta", (BigDecimal) o.getCdeDelta() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollateralPortfolioCode", (String) o.getInitialMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollateralPortfolioCode", (String) o.getVariationMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("largeNotionalOffFacilitySwapElectionIndicator", (Boolean) o.getLargeNotionalOffFacilitySwapElectionIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("sefOrDcmAnonymousExecutionIndicator", (Boolean) o.getSefOrDcmAnonymousExecutionIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("blockTradeElectionIndicator", (Boolean) o.getBlockTradeElectionIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("sefOrDcmIndicator", (Boolean) o.getSefOrDcmIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("mandatoryClearingIndicator", (Boolean) o.getMandatoryClearingIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("sdMspIndicatorCounterparty1", (Boolean) o.getSdMspIndicatorCounterparty1() != null ? 1 : 0, 0, 1), 
				checkCardinality("sdMspIndicatorCounterparty2", (Boolean) o.getSdMspIndicatorCounterparty2() != null ? 1 : 0, 0, 1), 
				checkCardinality("physicalCommodityContractIndicator", (Boolean) o.getPhysicalCommodityContractIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("changeInNotionalAmount1", (BigDecimal) o.getChangeInNotionalAmount1() != null ? 1 : 0, 0, 1), 
				checkCardinality("changeInNotionalAmount2", (BigDecimal) o.getChangeInNotionalAmount2() != null ? 1 : 0, 0, 1), 
				checkCardinality("changeInLeg1NotionalQuantity", (BigDecimal) o.getChangeInLeg1NotionalQuantity() != null ? 1 : 0, 0, 1), 
				checkCardinality("changeInLeg2NotionalQuantity", (BigDecimal) o.getChangeInLeg2NotionalQuantity() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeCryptoAssetUnderlyingIndicatorLeg1", (Boolean) o.getCdeCryptoAssetUnderlyingIndicatorLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeCryptoAssetUnderlyingIndicatorLeg2", (Boolean) o.getCdeCryptoAssetUnderlyingIndicatorLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeCustomBasketCode", (String) o.getCdeCustomBasketCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlierIdOtherLeg1", (String) o.getUnderlierIdOtherLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlierIdOtherLeg2", (String) o.getUnderlierIdOtherLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlierIdOtherSourceLeg1", (String) o.getUnderlierIdOtherSourceLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlierIdOtherSourceLeg2", (String) o.getUnderlierIdOtherSourceLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeUnderlyingAssetTradingPlatformIdLeg1", (String) o.getCdeUnderlyingAssetTradingPlatformIdLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeUnderlyingAssetTradingPlatformIdLeg2", (String) o.getCdeUnderlyingAssetTradingPlatformIdLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeUnderlyingAssetPriceSourceLeg1", (String) o.getCdeUnderlyingAssetPriceSourceLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdeUnderlyingAssetPriceSourceLeg2", (String) o.getCdeUnderlyingAssetPriceSourceLeg2() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, HarmonizedData o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("HarmonizedData", ValidationResult.ValidationType.CARDINALITY, "HarmonizedData", path, "", res.getError());
				}
				return success("HarmonizedData", ValidationResult.ValidationType.CARDINALITY, "HarmonizedData", path, "");
			})
			.collect(toList());
	}

}
