# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.common.settlement.PriceQuantity import PriceQuantity

__all__ = ['FilterChangePriceQuantity']


@replaceable
def FilterChangePriceQuantity(priceQuantity: PriceQuantity | None, change: list[PriceQuantity] | None) -> PriceQuantity:
    """
    Filter the change PriceQuantity list to match on Observable if present.
    
    Parameters 
    ----------
    priceQuantity : PriceQuantity
    List of PriceQuantity to update.
    
    change : PriceQuantity
    List of new PriceQuantity to use where the units match.
    
    Returns
    -------
    filteredChange : PriceQuantity
    
    """
    self = inspect.currentframe()
    
    
    changeWithMatchingObservable = rosetta_filter(rosetta_resolve_attr(self, "change"), lambda item: (((not rosetta_attr_exists(rosetta_resolve_attr(item, "observable"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "priceQuantity"), "observable")))) or all_elements(rosetta_resolve_attr(item, "observable"), "=", rosetta_resolve_attr(rosetta_resolve_attr(self, "priceQuantity"), "observable"))))
    filteredChange = (rosetta_resolve_attr(self, "changeWithMatchingObservable") default rosetta_resolve_attr(self, "change"))
    
    
    return filteredChange

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
