# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CancellationEvent']


class CancellationEvent(BaseDataClass):
    """
    The adjusted dates for a specific cancellation date, including the adjusted exercise date and adjusted termination date.
    """
    adjustedExerciseDate: datetime.date = Field(..., description="The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.")
    """
    The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.
    """
    adjustedEarlyTerminationDate: datetime.date = Field(..., description="The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.")
    """
    The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.
    """

import cdm 
