# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ReturnTerms']


class ReturnTerms(BaseDataClass):
    """
    Specifies the type of return of a performance payout.
    """
    priceReturnTerms: Optional[cdm.product.asset.PriceReturnTerms.PriceReturnTerms] = Field(None, description="Return terms based upon the underlier's observed price.")
    """
    Return terms based upon the underlier's observed price.
    """
    dividendReturnTerms: Optional[cdm.product.asset.DividendReturnTerms.DividendReturnTerms] = Field(None, description="Return terms based upon dividend payments associated to the underlier.")
    """
    Return terms based upon dividend payments associated to the underlier.
    """
    varianceReturnTerms: Optional[cdm.product.asset.VarianceReturnTerms.VarianceReturnTerms] = Field(None, description="Return terms based upon the observed variance of the underlier's price.")
    """
    Return terms based upon the observed variance of the underlier's price.
    """
    volatilityReturnTerms: Optional[cdm.product.asset.VolatilityReturnTerms.VolatilityReturnTerms] = Field(None, description="Return terms based upon the observed volatility of the underlier's price.")
    """
    Return terms based upon the observed volatility of the underlier's price.
    """
    correlationReturnTerms: Optional[cdm.product.asset.CorrelationReturnTerms.CorrelationReturnTerms] = Field(None, description="Return terms based upon the observed correlation between the components of the underlying basket.")
    """
    Return terms based upon the observed correlation between the components of the underlying basket.
    """
    
    @rosetta_condition
    def condition_0_ReturnTermsExists(self):
        """
        Checks that the return type label matches the actual return terms structure of the product.
        """
        item = self
        def _then_fn1():
            return rosetta_check_one_of(self, rosetta_resolve_attr(self, "priceReturnTerms"))
        
        def _else_fn1():
            return ((((rosetta_check_one_of(self, rosetta_resolve_attr(self, "priceReturnTerms")) or rosetta_check_one_of(self, rosetta_resolve_attr(self, "dividendReturnTerms"))) or rosetta_check_one_of(self, rosetta_resolve_attr(self, "varianceReturnTerms"))) or rosetta_check_one_of(self, rosetta_resolve_attr(self, "volatilityReturnTerms"))) or rosetta_check_one_of(self, rosetta_resolve_attr(self, "correlationReturnTerms")))
        
        def _then_fn0():
            return rosetta_check_one_of(self, rosetta_resolve_attr(self, "priceReturnTerms"))
        
        def _else_fn0():
            return if_cond_fn(all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "priceReturnTerms"), "returnType"), "=", rosetta_resolve_attr(ReturnTypeEnum, "PRICE")), _then_fn1, _else_fn1)
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "priceReturnTerms"), "returnType"), "=", rosetta_resolve_attr(ReturnTypeEnum, "TOTAL")), _then_fn0, _else_fn0)

import cdm 
import cdm.product.asset.PriceReturnTerms
import cdm.product.asset.DividendReturnTerms
import cdm.product.asset.VarianceReturnTerms
import cdm.product.asset.VolatilityReturnTerms
import cdm.product.asset.CorrelationReturnTerms
from cdm.product.asset.ReturnTypeEnum import ReturnTypeEnum
