package drr.base.qualification.product.functions;

import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsTotalReturnSwapDebtUnderlier.IsTotalReturnSwapDebtUnderlierDefault.class)
public abstract class IsTotalReturnSwapDebtUnderlier implements RosettaFunction {

	/**
	* @param product 
	* @return result 
	*/
	public Boolean evaluate(Product product) {
		Boolean result = doEvaluate(product);
		
		return result;
	}

	protected abstract Boolean doEvaluate(Product product);

	protected abstract MapperS<? extends Product> performanceUnderlier(Product product);

	public static class IsTotalReturnSwapDebtUnderlierDefault extends IsTotalReturnSwapDebtUnderlier {
		@Override
		protected Boolean doEvaluate(Product product) {
			Boolean result = null;
			return assignOutput(result, product);
		}
		
		protected Boolean assignOutput(Boolean result, Product product) {
			final ComparisonResult ifThenElseResult;
			if (exists(performanceUnderlier(product)).getOrDefault(false)) {
				ifThenElseResult = exists(performanceUnderlier(product).<Loan>map("getLoan", _product -> _product.getLoan())).or(areEqual(performanceUnderlier(product).<Security>map("getSecurity", _product -> _product.getSecurity()).<SecurityTypeEnum>map("getSecurityType", security -> security.getSecurityType()), MapperS.of(SecurityTypeEnum.DEBT), CardinalityOperator.All));
			} else {
				ifThenElseResult = ComparisonResult.successEmptyOperand("");
			}
			result = onlyExists(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("interestRatePayout", "performancePayout")).and(ifThenElseResult).get();
			
			return result;
		}
		
		@Override
		protected MapperS<? extends Product> performanceUnderlier(Product product) {
			return MapperS.of(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier());
		}
	}
}
