package drr.enrichment.upi.functions;

import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FloatingRateIndex.FloatingRateIndexDefault.class)
public abstract class FloatingRateIndex implements RosettaFunction {

	/**
	* @param interestRatePayout 
	* @return floatingRateIndexName 
	*/
	public String evaluate(InterestRatePayout interestRatePayout) {
		String floatingRateIndexName = doEvaluate(interestRatePayout);
		
		return floatingRateIndexName;
	}

	protected abstract String doEvaluate(InterestRatePayout interestRatePayout);

	protected abstract MapperS<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndex(InterestRatePayout interestRatePayout);

	public static class FloatingRateIndexDefault extends FloatingRateIndex {
		@Override
		protected String doEvaluate(InterestRatePayout interestRatePayout) {
			String floatingRateIndexName = null;
			return assignOutput(floatingRateIndexName, interestRatePayout);
		}
		
		protected String assignOutput(String floatingRateIndexName, InterestRatePayout interestRatePayout) {
			floatingRateIndexName = floatingRateIndex(interestRatePayout).<FloatingRateIndexEnum>map("Type coercion", fieldWithMetaFloatingRateIndexEnum -> fieldWithMetaFloatingRateIndexEnum == null ? null : fieldWithMetaFloatingRateIndexEnum.getValue()).map("to-string", FloatingRateIndexEnum::toDisplayString).get();
			
			return floatingRateIndexName;
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndex(InterestRatePayout interestRatePayout) {
			if (exists(MapperS.of(interestRatePayout).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).getOrDefault(false)) {
				return MapperS.of(interestRatePayout).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption0 -> referenceWithMetaFloatingRateOption0 == null ? null : referenceWithMetaFloatingRateOption0.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
			}
			if (exists(MapperS.of(interestRatePayout).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())).getOrDefault(false)) {
				return MapperS.of(interestRatePayout).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", inflationRateSpecification -> inflationRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption1 -> referenceWithMetaFloatingRateOption1 == null ? null : referenceWithMetaFloatingRateOption1.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
			}
			return MapperS.<FieldWithMetaFloatingRateIndexEnum>ofNull();
		}
	}
}
