package drr.regulation.asic.rewrite.margin.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.margin.ASICMarginReport;
import drr.standards.iso.CollateralisationType3Code__1;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ASICMarginReportOnlyExistsValidator implements ValidatorWithArg<ASICMarginReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ASICMarginReport> ValidationResult<ASICMarginReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("uniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifier()))
				.put("uniqueTransactionIdentifierProprietary", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifierProprietary()))
				.put("reportingEntity", ExistenceChecker.isSet((String) o.getReportingEntity()))
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("smallScaleBuySideEntityIndicator", ExistenceChecker.isSet((String) o.getSmallScaleBuySideEntityIndicator()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("collateralTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getCollateralTimestamp()))
				.put("collateralisationCategory", ExistenceChecker.isSet((CollateralisationType3Code__1) o.getCollateralisationCategory()))
				.put("collateralPortfolioIndicator", ExistenceChecker.isSet((Boolean) o.getCollateralPortfolioIndicator()))
				.put("portfolioContainingNonReportedComponentIndicator", ExistenceChecker.isSet((Boolean) o.getPortfolioContainingNonReportedComponentIndicator()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("collateralPortfolioCodeVM", ExistenceChecker.isSet((String) o.getCollateralPortfolioCodeVM()))
				.put("initialMarginPostedByTheReportingEntityPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginPostedByTheReportingEntityPreHaircut()))
				.put("initialMarginPostedByTheReportingEntityPostHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginPostedByTheReportingEntityPostHaircut()))
				.put("currencyofInitialMarginPosted", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyofInitialMarginPosted()))
				.put("initialMarginCollectedByTheReportingEntityPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginCollectedByTheReportingEntityPreHaircut()))
				.put("initialMarginCollectedByTheReportingEntityPostHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginCollectedByTheReportingEntityPostHaircut()))
				.put("currencyofInitialMarginCollected", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyofInitialMarginCollected()))
				.put("variationMarginPostedByTheReportingEntityPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginPostedByTheReportingEntityPreHaircut()))
				.put("currencyOfVariationMarginPosted", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginPosted()))
				.put("variationMarginCollectedByTheReportingEntityPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginCollectedByTheReportingEntityPreHaircut()))
				.put("currencyOfVariationMarginCollected", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginCollected()))
				.put("actionType", ExistenceChecker.isSet((MarginActionEnum) o.getActionType()))
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("reportSubmittingEntityID", ExistenceChecker.isSet((String) o.getReportSubmittingEntityID()))
				.put("counterpartyIdentifierType", ExistenceChecker.isSet((Boolean) o.getCounterpartyIdentifierType()))
				.put("technicalRecordId", ExistenceChecker.isSet((String) o.getTechnicalRecordId()))
				.put("executionAgentOfCounterparty1", ExistenceChecker.isSet((String) o.getExecutionAgentOfCounterparty1()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ASICMarginReport", ValidationResult.ValidationType.ONLY_EXISTS, "ASICMarginReport", path, "");
		}
		return failure("ASICMarginReport", ValidationResult.ValidationType.ONLY_EXISTS, "ASICMarginReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
