package drr.regulation.cftc.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;


@ImplementedBy(AffiliatedCounterpartyForMarginAndCapitalIndicatorRule.AffiliatedCounterpartyForMarginAndCapitalIndicatorRuleDefault.class)
public abstract class AffiliatedCounterpartyForMarginAndCapitalIndicatorRule implements ReportFunction<CollateralReportInstruction, Void> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Void evaluate(CollateralReportInstruction input) {
		Void output = doEvaluate(input);
		
		return output;
	}

	protected abstract Void doEvaluate(CollateralReportInstruction input);

	public static class AffiliatedCounterpartyForMarginAndCapitalIndicatorRuleDefault extends AffiliatedCounterpartyForMarginAndCapitalIndicatorRule {
		@Override
		protected Void doEvaluate(CollateralReportInstruction input) {
			Void output = null;
			return assignOutput(output, input);
		}
		
		protected Void assignOutput(Void output, CollateralReportInstruction input) {
			output = null;
			
			return output;
		}
	}
}
