package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomyClassification;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommoditySwap;
import drr.base.qualification.product.functions.IsCommoditySwaption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ExtractCommodityClassificationLeg2.ExtractCommodityClassificationLeg2Default.class)
public abstract class ExtractCommodityClassificationLeg2 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsCommoditySwaption isCommoditySwaption;
	@Inject protected Qualify_Commodity_Forward qualify_Commodity_Forward;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @param taxonomySource 
	* @param ordinal 
	* @return commodityClassification 
	*/
	public String evaluate(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
		String commodityClassification = doEvaluate(product, taxonomySource, ordinal);
		
		return commodityClassification;
	}

	protected abstract String doEvaluate(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal);

	protected abstract MapperS<? extends ReferenceWithMetaCommodity> commodityUnderlier(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal);

	protected abstract MapperC<? extends ProductTaxonomy> taxonomy(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal);

	public static class ExtractCommodityClassificationLeg2Default extends ExtractCommodityClassificationLeg2 {
		@Override
		protected String doEvaluate(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			String commodityClassification = null;
			return assignOutput(commodityClassification, product, taxonomySource, ordinal);
		}
		
		protected String assignOutput(String commodityClassification, Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			final MapperC<TaxonomyClassification> thenArg = MapperS.of(taxonomy(product, taxonomySource, ordinal).get()).<TaxonomyValue>map("getValue", productTaxonomy -> productTaxonomy.getValue()).<TaxonomyClassification>mapC("getClassification", taxonomyValue -> taxonomyValue.getClassification())
				.filterItemNullSafe(item -> areEqual(item.<Integer>map("getOrdinal", taxonomyClassification -> taxonomyClassification.getOrdinal()), MapperS.of(ordinal), CardinalityOperator.All).get());
			commodityClassification = MapperS.of(thenArg.get()).<String>map("getValue", taxonomyClassification -> taxonomyClassification.getValue()).get();
			
			return commodityClassification;
		}
		
		@Override
		protected MapperS<? extends ReferenceWithMetaCommodity> commodityUnderlier(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			if (ComparisonResult.of(MapperS.of(isCommoditySwaption.evaluate(product))).and(exists(MapperS.of(commodityLeg2.evaluate(underlierForProduct.evaluate(product))).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()))).getOrDefault(false)) {
				return MapperS.of(commodityLeg2.evaluate(underlierForProduct.evaluate(product))).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity());
			}
			if (ComparisonResult.of(MapperS.of(isCommoditySwap.evaluate(product))).and(exists(MapperS.of(commodityLeg2.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()))).getOrDefault(false)) {
				return MapperS.of(commodityLeg2.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity());
			}
			final Boolean _boolean = qualify_Commodity_Forward.evaluate(economicTermsForProduct.evaluate(product));
			if ((_boolean == null ? false : _boolean)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity());
			}
			return MapperS.<ReferenceWithMetaCommodity>ofNull();
		}
		
		@Override
		protected MapperC<? extends ProductTaxonomy> taxonomy(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			return commodityUnderlier(product, taxonomySource, ordinal).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ProductTaxonomy>mapC("getProductTaxonomy", commodity -> commodity.getProductTaxonomy())
				.filterItemNullSafe(item -> areEqual(item.<TaxonomySourceEnum>map("getSource", productTaxonomy -> productTaxonomy.getSource()), MapperS.of(taxonomySource), CardinalityOperator.All).get());
		}
	}
}
