package drr.regulation.common.functions;

import cdm.base.staticdata.party.LegalEntity;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.ReferenceInformation;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.product.functions.IsCreditDefaultSwap;
import drr.base.qualification.product.functions.IsCreditSwaption;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.base.util.string.functions.StringContains;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ExtractReferenceEntity.ExtractReferenceEntityDefault.class)
public abstract class ExtractReferenceEntity implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected StringContains stringContains;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param reportableEvent 
	* @return referenceEntity 
	*/
	public String evaluate(ReportableEventBase reportableEvent) {
		String referenceEntity = doEvaluate(reportableEvent);
		
		return referenceEntity;
	}

	protected abstract String doEvaluate(ReportableEventBase reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEventBase reportableEvent);

	protected abstract MapperS<? extends LegalEntity> referenceEntityProduct(ReportableEventBase reportableEvent);

	protected abstract MapperS<? extends FieldWithMetaString> referenceEntityByScheme(ReportableEventBase reportableEvent);

	public static class ExtractReferenceEntityDefault extends ExtractReferenceEntity {
		@Override
		protected String doEvaluate(ReportableEventBase reportableEvent) {
			String referenceEntity = null;
			return assignOutput(referenceEntity, reportableEvent);
		}
		
		protected String assignOutput(String referenceEntity, ReportableEventBase reportableEvent) {
			final MapperC<FieldWithMetaString> thenArg;
			if (exists(referenceEntityByScheme(reportableEvent)).and(notEqual(referenceEntityByScheme(reportableEvent).<String>map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), MapperS.of(""), CardinalityOperator.Any)).getOrDefault(false)) {
				thenArg = MapperC.of(referenceEntityByScheme(reportableEvent));
			} else {
				thenArg = referenceEntityProduct(reportableEvent).<FieldWithMetaString>mapC("getEntityId", legalEntity -> legalEntity.getEntityId());
			}
			final FieldWithMetaString fieldWithMetaString1 = thenArg
				.last().get();
			if (fieldWithMetaString1 == null) {
				referenceEntity = null;
			} else {
				referenceEntity = fieldWithMetaString1.getValue();
			}
			
			return referenceEntity;
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEventBase reportableEvent) {
			return MapperS.of(productForEvent.evaluate(reportableEvent));
		}
		
		@Override
		protected MapperS<? extends LegalEntity> referenceEntityProduct(ReportableEventBase reportableEvent) {
			final Boolean boolean0 = isCreditSwaption.evaluate(product(reportableEvent).get());
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<LegalEntity>map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity());
			}
			final Boolean boolean1 = isCreditDefaultSwap.evaluate(product(reportableEvent).get());
			if ((boolean1 == null ? false : boolean1)) {
				return product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<LegalEntity>map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity());
			}
			return MapperS.<LegalEntity>ofNull();
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> referenceEntityByScheme(ReportableEventBase reportableEvent) {
			final MapperC<FieldWithMetaString> thenArg0 = referenceEntityProduct(reportableEvent).<FieldWithMetaString>mapC("getEntityId", legalEntity -> legalEntity.getEntityId());
			final MapperC<FieldWithMetaString> thenArg1 = thenArg0
				.filterItemNullSafe(item -> ComparisonResult.of(MapperS.of(stringContains.evaluate(item.map("getMeta", a->a.getMeta()).map("getScheme", a->a.getScheme()).get(), "http://www.fpml.org/coding-scheme/external/iso17442"))).or(ComparisonResult.of(MapperS.of(stringContains.evaluate(item.map("getMeta", a->a.getMeta()).map("getScheme", a->a.getScheme()).get(), "http://www.fpml.org/coding-scheme/external/iso3166")))).get());
			return thenArg1
				.first();
		}
	}
}
