package drr.regulation.common.functions;

import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(RateOption.RateOptionDefault.class)
public abstract class RateOption implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param interestRatePayout 
	* @return rateOption 
	*/
	public FloatingRateOption evaluate(InterestRatePayout interestRatePayout) {
		FloatingRateOption.FloatingRateOptionBuilder rateOptionBuilder = doEvaluate(interestRatePayout);
		
		final FloatingRateOption rateOption;
		if (rateOptionBuilder == null) {
			rateOption = null;
		} else {
			rateOption = rateOptionBuilder.build();
			objectValidator.validate(FloatingRateOption.class, rateOption);
		}
		
		return rateOption;
	}

	protected abstract FloatingRateOption.FloatingRateOptionBuilder doEvaluate(InterestRatePayout interestRatePayout);

	public static class RateOptionDefault extends RateOption {
		@Override
		protected FloatingRateOption.FloatingRateOptionBuilder doEvaluate(InterestRatePayout interestRatePayout) {
			FloatingRateOption.FloatingRateOptionBuilder rateOption = FloatingRateOption.builder();
			return assignOutput(rateOption, interestRatePayout);
		}
		
		protected FloatingRateOption.FloatingRateOptionBuilder assignOutput(FloatingRateOption.FloatingRateOptionBuilder rateOption, InterestRatePayout interestRatePayout) {
			if (exists(MapperS.of(interestRatePayout).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).getOrDefault(false)) {
				final ReferenceWithMetaFloatingRateOption referenceWithMetaFloatingRateOption0 = MapperS.of(interestRatePayout).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).get();
				if (referenceWithMetaFloatingRateOption0 == null) {
					rateOption = null;
				} else {
					rateOption = toBuilder(referenceWithMetaFloatingRateOption0.getValue());
				}
			} else if (exists(MapperS.of(interestRatePayout).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())).getOrDefault(false)) {
				final ReferenceWithMetaFloatingRateOption referenceWithMetaFloatingRateOption1 = MapperS.of(interestRatePayout).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", inflationRateSpecification -> inflationRateSpecification.getRateOption()).get();
				if (referenceWithMetaFloatingRateOption1 == null) {
					rateOption = null;
				} else {
					rateOption = toBuilder(referenceWithMetaFloatingRateOption1.getValue());
				}
			} else {
				rateOption = null;
			}
			
			return Optional.ofNullable(rateOption)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
