package drr.regulation.common.trade.party.functions;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.RelatedParty;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.util.party.functions.ExtractPartyFromRelatedPartyByRole;
import drr.base.util.party.functions.PartyLei;
import drr.regulation.common.PartyInformation;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ExecutionAgentCounterparty1_Common.ExecutionAgentCounterparty1_CommonDefault.class)
public abstract class ExecutionAgentCounterparty1_Common implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractPartyFromRelatedPartyByRole extractPartyFromRelatedPartyByRole;
	@Inject protected PartyLei partyLei;

	/**
	* @param partyInfo 
	* @param reportingParty 
	* @param counterparty 
	* @return agent 
	*/
	public String evaluate(PartyInformation partyInfo, Party reportingParty, Party counterparty) {
		String agent = doEvaluate(partyInfo, reportingParty, counterparty);
		
		return agent;
	}

	protected abstract String doEvaluate(PartyInformation partyInfo, Party reportingParty, Party counterparty);

	public static class ExecutionAgentCounterparty1_CommonDefault extends ExecutionAgentCounterparty1_Common {
		@Override
		protected String doEvaluate(PartyInformation partyInfo, Party reportingParty, Party counterparty) {
			String agent = null;
			return assignOutput(agent, partyInfo, reportingParty, counterparty);
		}
		
		protected String assignOutput(String agent, PartyInformation partyInfo, Party reportingParty, Party counterparty) {
			final MapperS<PartyInformation> thenArg0 = MapperS.of(partyInfo)
				.filterSingleNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), MapperS.of(reportingParty), CardinalityOperator.All).get());
			final MapperS<Party> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(item.<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.EXECUTION_AGENT)));
			if (exists(thenArg1).asMapper().getOrDefault(false)) {
				final MapperS<PartyInformation> thenArg2 = MapperS.of(partyInfo)
					.filterSingleNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), MapperS.of(reportingParty), CardinalityOperator.All).get());
				final MapperS<Party> thenArg3 = thenArg2
					.mapSingleToItem(item -> MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(item.<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.EXECUTION_AGENT)));
				agent = thenArg3
					.mapSingleToItem(item -> MapperS.of(partyLei.evaluate(item.<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).getMulti()))).get();
			} else {
				final MapperS<PartyInformation> thenArg4 = MapperS.of(partyInfo)
					.filterSingleNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), MapperS.of(counterparty), CardinalityOperator.All).get());
				final MapperS<Party> thenArg5 = thenArg4
					.mapSingleToItem(item -> MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(item.<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.EXECUTION_AGENT)));
				if (exists(thenArg5).asMapper().getOrDefault(false)) {
					final MapperS<PartyInformation> thenArg6 = MapperS.of(partyInfo)
						.filterSingleNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), MapperS.of(counterparty), CardinalityOperator.All).get());
					final MapperS<Party> thenArg7 = thenArg6
						.mapSingleToItem(item -> MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(item.<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.EXECUTION_AGENT)));
					agent = thenArg7
						.mapSingleToItem(item -> MapperS.of(partyLei.evaluate(item.<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).getMulti()))).get();
				} else {
					agent = "NOAP";
				}
			}
			
			return agent;
		}
	}
}
