package drr.regulation.common.trade.party.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportingSide;
import drr.regulation.common.CFTCFinancialEntityClassificationEnum;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SECPartyInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.party.functions.ExtractRegimeInformation;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Counterparty2FinancialEntityIndicatorRule.Counterparty2FinancialEntityIndicatorRuleDefault.class)
public abstract class Counterparty2FinancialEntityIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractRegimeInformation extractRegimeInformation;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class Counterparty2FinancialEntityIndicatorRuleDefault extends Counterparty2FinancialEntityIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperC<ReportingRegime> thenArg = MapperS.of(input)
				.mapSingleToList(item -> {
					final ReferenceWithMetaParty referenceWithMetaParty = item.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingCounterparty", reportingSide -> reportingSide.getReportingCounterparty()).get();
					return MapperC.<ReportingRegime>of(extractRegimeInformation.evaluate(item.get(), (referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue())));
				});
			final MapperS<Boolean> ifThenElseResult;
			if (exists(thenArg.<SECPartyInformation>map("getSecPartyInformation", reportingRegime -> reportingRegime.getSecPartyInformation()).<CFTCFinancialEntityClassificationEnum>map("getFinancialEntity", sECPartyInformation -> sECPartyInformation.getFinancialEntity())).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(true);
			} else {
				ifThenElseResult = MapperS.of(false);
			}
			output = ifThenElseResult.get();
			
			return output;
		}
	}
}
