package drr.regulation.csa.rewrite.valuation.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.csa.rewrite.valuation.CSAValuationReport;
import drr.regulation.csa.rewrite.valuation.labels.CSAValuationLabelProvider;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.csa.rewrite.valuation", body="CSA", corpusList={"Valuation"})
@RuneLabelProvider(labelProvider=CSAValuationLabelProvider.class)
@ImplementedBy(CSAValuationReportFunction.CSAValuationReportFunctionDefault.class)
public abstract class CSAValuationReportFunction implements ReportFunction<ValuationReportInstruction, CSAValuationReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierSourceRule counterparty2IdentifierSourceRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected DTCC_Comment1Rule dTCC_Comment1Rule;
	@Inject protected DTCC_MessageIDRule dTCC_MessageIDRule;
	@Inject protected DTCC_MessageTypeRule dTCC_MessageTypeRule;
	@Inject protected DTCC_PrimaryAssetClassRule dTCC_PrimaryAssetClassRule;
	@Inject protected DTCC_SubmittedForPartyRule dTCC_SubmittedForPartyRule;
	@Inject protected DTCC_SubmittingPartyIDTypeRule dTCC_SubmittingPartyIDTypeRule;
	@Inject protected DTCC_TradeParty1ExecutionAgentIDRule dTCC_TradeParty1ExecutionAgentIDRule;
	@Inject protected DTCC_TradeParty1ExecutionAgentIDTypeRule dTCC_TradeParty1ExecutionAgentIDTypeRule;
	@Inject protected DTCC_TradeParty1IDTypeRule dTCC_TradeParty1IDTypeRule;
	@Inject protected DTCC_TradeParty1ReportingDestinationRule dTCC_TradeParty1ReportingDestinationRule;
	@Inject protected DTCC_TradeParty1TransactionIDRule dTCC_TradeParty1TransactionIDRule;
	@Inject protected DTCC_TradeParty2ExecutionAgentIDRule dTCC_TradeParty2ExecutionAgentIDRule;
	@Inject protected DTCC_TradeParty2ExecutionAgentIDTypeRule dTCC_TradeParty2ExecutionAgentIDTypeRule;
	@Inject protected DTCC_TradeParty2ReportingDestinationRule dTCC_TradeParty2ReportingDestinationRule;
	@Inject protected DTCC_USIIDPrefixRule dTCC_USIIDPrefixRule;
	@Inject protected DTCC_USIIDRule dTCC_USIIDRule;
	@Inject protected DTCC_VersionRule dTCC_VersionRule;
	@Inject protected DeltaRule deltaRule;
	@Inject protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
	@Inject protected LastFloatingReferenceResetDateLeg1Rule lastFloatingReferenceResetDateLeg1Rule;
	@Inject protected LastFloatingReferenceResetDateLeg2Rule lastFloatingReferenceResetDateLeg2Rule;
	@Inject protected LastFloatingReferenceValueLeg1Rule lastFloatingReferenceValueLeg1Rule;
	@Inject protected LastFloatingReferenceValueLeg2Rule lastFloatingReferenceValueLeg2Rule;
	@Inject protected NextFloatingReferenceResetDateLeg1Rule nextFloatingReferenceResetDateLeg1Rule;
	@Inject protected NextFloatingReferenceResetDateLeg2Rule nextFloatingReferenceResetDateLeg2Rule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SubmitterIdentifierRule submitterIdentifierRule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected ValuationAmountRule valuationAmountRule;
	@Inject protected ValuationCurrencyRule valuationCurrencyRule;
	@Inject protected ValuationMethodRule valuationMethodRule;
	@Inject protected ValuationTimestampRule valuationTimestampRule;
	@Inject protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CSAValuationReport evaluate(ValuationReportInstruction input) {
		CSAValuationReport.CSAValuationReportBuilder outputBuilder = doEvaluate(input);
		
		final CSAValuationReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CSAValuationReport.class, output);
		}
		
		return output;
	}

	protected abstract CSAValuationReport.CSAValuationReportBuilder doEvaluate(ValuationReportInstruction input);

	public static class CSAValuationReportFunctionDefault extends CSAValuationReportFunction {
		@Override
		protected CSAValuationReport.CSAValuationReportBuilder doEvaluate(ValuationReportInstruction input) {
			CSAValuationReport.CSAValuationReportBuilder output = CSAValuationReport.builder();
			return assignOutput(output, input);
		}
		
		protected CSAValuationReport.CSAValuationReportBuilder assignOutput(CSAValuationReport.CSAValuationReportBuilder output, ValuationReportInstruction input) {
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierSource(counterparty2IdentifierSourceRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setSubmitterIdentifier(submitterIdentifierRule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setValuationAmount(valuationAmountRule.evaluate(input));
			
			output
				.setValuationCurrency(valuationCurrencyRule.evaluate(input));
			
			output
				.setValuationMethod(valuationMethodRule.evaluate(input));
			
			output
				.setValuationTimestamp(valuationTimestampRule.evaluate(input));
			
			output
				.setNextFloatingReferenceResetDateLeg1(nextFloatingReferenceResetDateLeg1Rule.evaluate(input));
			
			output
				.setNextFloatingReferenceResetDateLeg2(nextFloatingReferenceResetDateLeg2Rule.evaluate(input));
			
			output
				.setLastFloatingReferenceValueLeg1(lastFloatingReferenceValueLeg1Rule.evaluate(input));
			
			output
				.setLastFloatingReferenceValueLeg2(lastFloatingReferenceValueLeg2Rule.evaluate(input));
			
			output
				.setLastFloatingReferenceResetDateLeg1(lastFloatingReferenceResetDateLeg1Rule.evaluate(input));
			
			output
				.setLastFloatingReferenceResetDateLeg2(lastFloatingReferenceResetDateLeg2Rule.evaluate(input));
			
			output
				.setDelta(deltaRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setTradeParty1IDType(dTCC_TradeParty1IDTypeRule.evaluate(input));
			
			output
				.setSubmittingPartyIDType(dTCC_SubmittingPartyIDTypeRule.evaluate(input));
			
			output
				.setUsiID(dTCC_USIIDRule.evaluate(input));
			
			output
				.setUsiIDPrefix(null);
			
			output
				.setSubmittedForParty(dTCC_SubmittedForPartyRule.evaluate(input));
			
			output
				.setTradeParty1ReportingDestination(dTCC_TradeParty1ReportingDestinationRule.evaluate(input));
			
			output
				.setTradeParty2ReportingDestination(dTCC_TradeParty2ReportingDestinationRule.evaluate(input));
			
			output
				.setPrimaryAssetClass(dTCC_PrimaryAssetClassRule.evaluate(input));
			
			output
				.setComment1(null);
			
			output
				.setMessageID(dTCC_MessageIDRule.evaluate(input));
			
			output
				.setMessageType(dTCC_MessageTypeRule.evaluate(input));
			
			output
				.setTradeParty2ExecutionAgentID(dTCC_TradeParty2ExecutionAgentIDRule.evaluate(input));
			
			output
				.setTradeParty2ExecutionAgentIDType(dTCC_TradeParty2ExecutionAgentIDTypeRule.evaluate(input));
			
			output
				.setTradeParty1ExecutionAgentID(dTCC_TradeParty1ExecutionAgentIDRule.evaluate(input));
			
			output
				.setTradeParty1ExecutionAgentIDType(dTCC_TradeParty1ExecutionAgentIDTypeRule.evaluate(input));
			
			output
				.setTradeParty1TransactionID(dTCC_TradeParty1TransactionIDRule.evaluate(input));
			
			output
				.setVersion(dTCC_VersionRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
