package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.qualification.event.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 7.0.0-dev.73
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2044_02")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2044_02.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2044_02 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2044_02";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if expirationDate exists then (expirationDate >= (executionTimestamp -> date) and expirationDate >= effectiveDate)";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2044_02 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<ActionTypeEnum>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (exists(MapperS.of(eSMAEMIRTransactionReport).<Date>map("getExpirationDate", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getExpirationDate())).getOrDefault(false)) {
						return greaterThanEquals(MapperS.of(eSMAEMIRTransactionReport).<Date>map("getExpirationDate", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getExpirationDate()), MapperS.of(eSMAEMIRTransactionReport).<ZonedDateTime>map("getExecutionTimestamp", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getExecutionTimestamp()).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())), CardinalityOperator.All).and(greaterThanEquals(MapperS.of(eSMAEMIRTransactionReport).<Date>map("getExpirationDate", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getExpirationDate()), MapperS.of(eSMAEMIRTransactionReport).<Date>map("getEffectiveDate", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEffectiveDate()), CardinalityOperator.All));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2044_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
