package drr.regulation.fca.ukemir.refit.margin;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.fca.ukemir.refit.margin.meta.FCAUKEMIRMarginReportMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 7.0.0-dev.73
 */
@RosettaDataType(value="FCAUKEMIRMarginReport", builder=FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilderImpl.class, version="7.0.0-dev.73")
@RuneDataType(value="FCAUKEMIRMarginReport", model="drr", builder=FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilderImpl.class, version="7.0.0-dev.73")
public interface FCAUKEMIRMarginReport extends RosettaModelObject {

	FCAUKEMIRMarginReportMeta metaData = new FCAUKEMIRMarginReportMeta();

	/*********************** Getter Methods  ***********************/
	PartiesToTheDerivative getPartiesToTheDerivative();
	CollateralReport getCollateral();

	/*********************** Build Methods  ***********************/
	FCAUKEMIRMarginReport build();
	
	FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder toBuilder();
	
	static FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder builder() {
		return new FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends FCAUKEMIRMarginReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends FCAUKEMIRMarginReport> getType() {
		return FCAUKEMIRMarginReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("partiesToTheDerivative"), processor, PartiesToTheDerivative.class, getPartiesToTheDerivative());
		processRosetta(path.newSubPath("collateral"), processor, CollateralReport.class, getCollateral());
	}
	

	/*********************** Builder Interface  ***********************/
	interface FCAUKEMIRMarginReportBuilder extends FCAUKEMIRMarginReport, RosettaModelObjectBuilder {
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder getOrCreatePartiesToTheDerivative();
		@Override
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder getPartiesToTheDerivative();
		CollateralReport.CollateralReportBuilder getOrCreateCollateral();
		@Override
		CollateralReport.CollateralReportBuilder getCollateral();
		FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder setPartiesToTheDerivative(PartiesToTheDerivative partiesToTheDerivative);
		FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder setCollateral(CollateralReport collateral);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("partiesToTheDerivative"), processor, PartiesToTheDerivative.PartiesToTheDerivativeBuilder.class, getPartiesToTheDerivative());
			processRosetta(path.newSubPath("collateral"), processor, CollateralReport.CollateralReportBuilder.class, getCollateral());
		}
		

		FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder prune();
	}

	/*********************** Immutable Implementation of FCAUKEMIRMarginReport  ***********************/
	class FCAUKEMIRMarginReportImpl implements FCAUKEMIRMarginReport {
		private final PartiesToTheDerivative partiesToTheDerivative;
		private final CollateralReport collateral;
		
		protected FCAUKEMIRMarginReportImpl(FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder builder) {
			this.partiesToTheDerivative = ofNullable(builder.getPartiesToTheDerivative()).map(f->f.build()).orElse(null);
			this.collateral = ofNullable(builder.getCollateral()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="partiesToTheDerivative", isRequired=true)
		@RuneAttribute(value="partiesToTheDerivative", isRequired=true)
		public PartiesToTheDerivative getPartiesToTheDerivative() {
			return partiesToTheDerivative;
		}
		
		@Override
		@RosettaAttribute(value="collateral", isRequired=true)
		@RuneAttribute(value="collateral", isRequired=true)
		public CollateralReport getCollateral() {
			return collateral;
		}
		
		@Override
		public FCAUKEMIRMarginReport build() {
			return this;
		}
		
		@Override
		public FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder toBuilder() {
			FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder builder) {
			ofNullable(getPartiesToTheDerivative()).ifPresent(builder::setPartiesToTheDerivative);
			ofNullable(getCollateral()).ifPresent(builder::setCollateral);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FCAUKEMIRMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(partiesToTheDerivative, _that.getPartiesToTheDerivative())) return false;
			if (!Objects.equals(collateral, _that.getCollateral())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (partiesToTheDerivative != null ? partiesToTheDerivative.hashCode() : 0);
			_result = 31 * _result + (collateral != null ? collateral.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FCAUKEMIRMarginReport {" +
				"partiesToTheDerivative=" + this.partiesToTheDerivative + ", " +
				"collateral=" + this.collateral +
			'}';
		}
	}

	/*********************** Builder Implementation of FCAUKEMIRMarginReport  ***********************/
	class FCAUKEMIRMarginReportBuilderImpl implements FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder {
	
		protected PartiesToTheDerivative.PartiesToTheDerivativeBuilder partiesToTheDerivative;
		protected CollateralReport.CollateralReportBuilder collateral;
		
		@Override
		@RosettaAttribute(value="partiesToTheDerivative", isRequired=true)
		@RuneAttribute(value="partiesToTheDerivative", isRequired=true)
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder getPartiesToTheDerivative() {
			return partiesToTheDerivative;
		}
		
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder getOrCreatePartiesToTheDerivative() {
			PartiesToTheDerivative.PartiesToTheDerivativeBuilder result;
			if (partiesToTheDerivative!=null) {
				result = partiesToTheDerivative;
			}
			else {
				result = partiesToTheDerivative = PartiesToTheDerivative.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute(value="collateral", isRequired=true)
		@RuneAttribute(value="collateral", isRequired=true)
		public CollateralReport.CollateralReportBuilder getCollateral() {
			return collateral;
		}
		
		@Override
		public CollateralReport.CollateralReportBuilder getOrCreateCollateral() {
			CollateralReport.CollateralReportBuilder result;
			if (collateral!=null) {
				result = collateral;
			}
			else {
				result = collateral = CollateralReport.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute(value="partiesToTheDerivative", isRequired=true)
		@RuneAttribute(value="partiesToTheDerivative", isRequired=true)
		@Override
		public FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder setPartiesToTheDerivative(PartiesToTheDerivative _partiesToTheDerivative) {
			this.partiesToTheDerivative = _partiesToTheDerivative == null ? null : _partiesToTheDerivative.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="collateral", isRequired=true)
		@RuneAttribute(value="collateral", isRequired=true)
		@Override
		public FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder setCollateral(CollateralReport _collateral) {
			this.collateral = _collateral == null ? null : _collateral.toBuilder();
			return this;
		}
		
		@Override
		public FCAUKEMIRMarginReport build() {
			return new FCAUKEMIRMarginReport.FCAUKEMIRMarginReportImpl(this);
		}
		
		@Override
		public FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder prune() {
			if (partiesToTheDerivative!=null && !partiesToTheDerivative.prune().hasData()) partiesToTheDerivative = null;
			if (collateral!=null && !collateral.prune().hasData()) collateral = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPartiesToTheDerivative()!=null && getPartiesToTheDerivative().hasData()) return true;
			if (getCollateral()!=null && getCollateral().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder o = (FCAUKEMIRMarginReport.FCAUKEMIRMarginReportBuilder) other;
			
			merger.mergeRosetta(getPartiesToTheDerivative(), o.getPartiesToTheDerivative(), this::setPartiesToTheDerivative);
			merger.mergeRosetta(getCollateral(), o.getCollateral(), this::setCollateral);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FCAUKEMIRMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(partiesToTheDerivative, _that.getPartiesToTheDerivative())) return false;
			if (!Objects.equals(collateral, _that.getCollateral())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (partiesToTheDerivative != null ? partiesToTheDerivative.hashCode() : 0);
			_result = 31 * _result + (collateral != null ? collateral.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FCAUKEMIRMarginReportBuilder {" +
				"partiesToTheDerivative=" + this.partiesToTheDerivative + ", " +
				"collateral=" + this.collateral +
			'}';
		}
	}
}
