package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.event.functions.IsAllowableAction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iso.IndexEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IndicatorOfTheUnderlyingIndexRule.IndicatorOfTheUnderlyingIndexRuleDefault.class)
public abstract class IndicatorOfTheUnderlyingIndexRule implements ReportFunction<TransactionReportInstruction, IndexEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.emir.reports.IndicatorOfTheUnderlyingIndexRule indicatorOfTheUnderlyingIndexRule;
	@Inject protected IsAllowableAction isAllowableAction;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public IndexEnum evaluate(TransactionReportInstruction input) {
		IndexEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract IndexEnum doEvaluate(TransactionReportInstruction input);

	public static class IndicatorOfTheUnderlyingIndexRuleDefault extends IndicatorOfTheUnderlyingIndexRule {
		@Override
		protected IndexEnum doEvaluate(TransactionReportInstruction input) {
			IndexEnum output = null;
			return assignOutput(output, input);
		}
		
		protected IndexEnum assignOutput(IndexEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<IndexEnum> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(indicatorOfTheUnderlyingIndexRule.evaluate(item.get())));
			output = thenArg1
				.mapSingleToItem(item -> {
					if (areEqual(MapperC.<IndexEnum>of(MapperS.of(IndexEnum.CORA), MapperS.of(IndexEnum.HKIO), MapperS.of(IndexEnum.TORF), MapperS.of(IndexEnum.SIBO), MapperS.of(IndexEnum.SSOR), MapperS.of(IndexEnum.SORA)), item, CardinalityOperator.Any).getOrDefault(false)) {
						return MapperS.<IndexEnum>ofNull();
					}
					return item;
				}).get();
			
			return output;
		}
	}
}
