package drr.regulation.hkma.rewrite.valuation.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.util.party.PartyIdentifierFormat2Enum;
import drr.regulation.common.HKTRPartyScheme;
import drr.regulation.common.UTIProprietarySchemeNameEnum;
import drr.regulation.hkma.rewrite.valuation.HKMAValuationReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class HKMAValuationReportValidator implements Validator<HKMAValuationReport> {

	private List<ComparisonResult> getComparisonResults(HKMAValuationReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2Name", (String) o.getCounterparty2Name() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2IdentifierTypeIndicator", (Boolean) o.getCounterparty2IdentifierTypeIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("valuationAmount", (BigDecimal) o.getValuationAmount() != null ? 1 : 0, 1, 1), 
				checkCardinality("valuationCurrency", (ISOCurrencyCodeEnum) o.getValuationCurrency() != null ? 1 : 0, 1, 1), 
				checkCardinality("valuationTimestamp", (ZonedDateTime) o.getValuationTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("valuationMethod", (ValuationType1Code) o.getValuationMethod() != null ? 1 : 0, 1, 1), 
				checkCardinality("delta", (BigDecimal) o.getDelta() != null ? 1 : 0, 0, 1), 
				checkCardinality("actionType", (ActionTypeEnum) o.getActionType() != null ? 1 : 0, 1, 1), 
				checkCardinality("uniqueTransactionIdentifier", (String) o.getUniqueTransactionIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("uniqueTransactionIdentifierProprietary", (String) o.getUniqueTransactionIdentifierProprietary() != null ? 1 : 0, 1, 1), 
				checkCardinality("submitterIdentifier", (String) o.getSubmitterIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("entityResponsibleForReporting", (String) o.getEntityResponsibleForReporting() != null ? 1 : 0, 0, 1), 
				checkCardinality("numberRecords", (BigDecimal) o.getNumberRecords() != null ? 1 : 0, 1, 1), 
				checkCardinality("technicalRecordId", (String) o.getTechnicalRecordId() != null ? 1 : 0, 1, 1), 
				checkCardinality("remarks", (String) o.getRemarks() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty2IdentifierFormat", (PartyIdentifierFormat2Enum) o.getCounterparty2IdentifierFormat() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty2SchemeName", (HKTRPartyScheme) o.getCounterparty2SchemeName() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueTransactionIdentifierProprietarySchemeName", (UTIProprietarySchemeNameEnum) o.getUniqueTransactionIdentifierProprietarySchemeName() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAValuationReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("HKMAValuationReport", ValidationResult.ValidationType.CARDINALITY, "HKMAValuationReport", path, "", res.getError());
				}
				return success("HKMAValuationReport", ValidationResult.ValidationType.CARDINALITY, "HKMAValuationReport", path, "");
			})
			.collect(toList());
	}

}
