package drr.regulation.jfsa.rewrite.trade.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class JFSATradeLabelProvider extends GraphBasedLabelProvider {
	public JFSATradeLabelProvider() {
		super(new LabelNode());
		
		startNode.addLabel(Arrays.asList("effectiveDate"), "1 Effective Date");
		startNode.addLabel(Arrays.asList("earlyTerminationDate"), "3 Early termination date");
		startNode.addLabel(Arrays.asList("reportingTimestamp"), "4 Reporting timestamp");
		startNode.addLabel(Arrays.asList("executionTimestamp"), "5 Execution timestamp");
		startNode.addLabel(Arrays.asList("expirationDate"), "2 Expiration date");
		startNode.addLabel(Arrays.asList("counterparty1"), "7 Counterparty 1");
		startNode.addLabel(Arrays.asList("counterparty2"), "8 Counterparty 2");
		startNode.addLabel(Arrays.asList("counterparty2IdentifierType"), "9 Counterparty 2 identifier type");
		startNode.addLabel(Arrays.asList("cleared"), "15 Cleared");
		startNode.addLabel(Arrays.asList("centralCounterparty"), "16 Central counterparty");
		startNode.addLabel(Arrays.asList("clearingMember"), "17 Clearing member");
		startNode.addLabel(Arrays.asList("confirmed"), "19 Confirmed");
		startNode.addLabel(Arrays.asList("callAmount"), "88 Call amount");
		startNode.addLabel(Arrays.asList("putAmount"), "89 Put Amount");
		startNode.addLabel(Arrays.asList("callCurrency"), "91 Call currency");
		startNode.addLabel(Arrays.asList("putCurrency"), "92 Put currency");
		startNode.addLabel(Arrays.asList("delta"), "43 Delta");
		startNode.addLabel(Arrays.asList("priceSchedule", "price", "monetary"), "68/70-$ 70 Price in effect between the unadjusted effective and end date");
		startNode.addLabel(Arrays.asList("priceSchedule", "price", "decimal"), "68/70-$ 70 Price in effect between the unadjusted effective and end date");
		startNode.addLabel(Arrays.asList("priceSchedule", "effectiveDate"), "68/70-$ 68 Price schedules - Unadjusted effective date of the price");
		startNode.addLabel(Arrays.asList("priceSchedule", "endDate"), "68/70-$ 69 Price schedules - Unadjusted end date of the price");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "price", "monetary"), "78/80-$ 80 Strike price in effect between the unadjusted effective and end date");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "price", "decimal"), "78/80-$ 80 Strike price in effect between the unadjusted effective and end date");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "effectiveDate"), "78/80-$ 78 Effective date of the strike price");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "endDate"), "78/80-$ 79 End date of the strike price");
		startNode.addLabel(Arrays.asList("price", "decimal"), "64 Price");
		startNode.addLabel(Arrays.asList("price", "monetary"), "64 Price");
		startNode.addLabel(Arrays.asList("priceNotation"), "66 Price notation");
		startNode.addLabel(Arrays.asList("priceCurrency"), "65 Price currency");
		startNode.addLabel(Arrays.asList("packageTransactionPrice", "decimal"), "133 Package Transaction Price");
		startNode.addLabel(Arrays.asList("packageTransactionPrice", "monetary"), "133 Package Transaction Price");
		startNode.addLabel(Arrays.asList("packageTransactionPriceNotation"), "135 Package Transaction Price Notation");
		startNode.addLabel(Arrays.asList("packageTransactionPriceCurrency"), "134 Package transaction price currency");
		startNode.addLabel(Arrays.asList("packageTransactionSpread", "decimal"), "136 Package transaction spread");
		startNode.addLabel(Arrays.asList("packageTransactionSpread", "monetary"), "136 Package transaction spread");
		startNode.addLabel(Arrays.asList("packageTransactionSpread", "basis"), "136 Package transaction spread");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadNotation"), "138 Package transaction spread notation");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadCurrency"), "137 Package transaction spread currency");
		startNode.addLabel(Arrays.asList("packageIdentifier"), "132 Package identifier");
		startNode.addLabel(Arrays.asList("strikePrice"), "75 Strike Price");
		startNode.addLabel(Arrays.asList("strikePrice", "decimal"), "75 Strike Price");
		startNode.addLabel(Arrays.asList("strikePrice", "monetary"), "75 Strike Price");
		startNode.addLabel(Arrays.asList("strikePriceNotation"), "77 Strike price notation");
		startNode.addLabel(Arrays.asList("strikePriceCurrency"), "76 Strike price currency");
		startNode.addLabel(Arrays.asList("priceUnitOfMeasure"), "67 Price unit of measure");
		startNode.addLabel(Arrays.asList("optionPremiumAmount"), "81 Option premium amount");
		startNode.addLabel(Arrays.asList("optionPremiumCurrency"), "82 Option premium currency");
		startNode.addLabel(Arrays.asList("optionPremiumPaymentDate"), "83 Option premium payment date");
		startNode.addLabel(Arrays.asList("exchangeRate"), "85 Exchange rate");
		startNode.addLabel(Arrays.asList("exchangeRateBasis"), "86 Exchange rate basis");
		startNode.addLabel(Arrays.asList("cdSIndexAttachmentPoint"), "124 CDS index attachment point");
		startNode.addLabel(Arrays.asList("cdSIndexDetachmentPoint"), "125 CDS index detachment point");
		startNode.addLabel(Arrays.asList("collateralPortfolioIndicator"), "44 Collateral Portfolio Indicator");
		startNode.addLabel(Arrays.asList("firstExerciseDate"), "84 First exercise date");
		startNode.addLabel(Arrays.asList("finalContractualSettlementDate"), "20 Final contractual settlement date");
		startNode.addLabel(Arrays.asList("priorUTI"), "26 Prior UTI");
		startNode.addLabel(Arrays.asList("direction1"), "10 Direction 1");
		startNode.addLabel(Arrays.asList("valuationAmount"), "39 Valuation amount");
		startNode.addLabel(Arrays.asList("valuationCurrency"), "40 Valuation currency");
		startNode.addLabel(Arrays.asList("valuationMethod"), "42 Valuation method");
		startNode.addLabel(Arrays.asList("valuationTimestamp"), "41 Valuation Timestamp");
		startNode.addLabel(Arrays.asList("customBasketCode"), "126 Custom basket code");
		startNode.addLabel(Arrays.asList("basketConstituents", "identifier"), "127 Identifier of the basket's constituents");
		startNode.addLabel(Arrays.asList("basketConstituents", "source"), "128 Basket constituent identifier source");
		startNode.addLabel(Arrays.asList("otherPayment", "amount"), "33/38-$ 33 Other payment amount");
		startNode.addLabel(Arrays.asList("otherPayment", "paymentType"), "33/38-$ 34 Other payment type");
		startNode.addLabel(Arrays.asList("otherPayment", "currency"), "33/38-$ 35 Other payment currency");
		startNode.addLabel(Arrays.asList("otherPayment", "date"), "33/38-$ 36 Other payment date");
		startNode.addLabel(Arrays.asList("otherPayment", "payer"), "33/38-$ 37 Other Payment Payer");
		startNode.addLabel(Arrays.asList("otherPayment", "payerFormat"), "Other Payment Payer Format (non-reportable)");
		startNode.addLabel(Arrays.asList("otherPayment", "receiver"), "33/38-$ 38 Other Payment Receiver");
		startNode.addLabel(Arrays.asList("otherPayment", "receiverFormat"), "Other Payment Receiver Format (non-reportable)");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRateDayCountConvention"), "27 Fixed rate day count convention-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateDayCountConvention"), "27 Floating rate day count convention of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "28 Fixed rate payment frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "28 Floating rate payment frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "29 Fixed rate payment frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "29 Floating rate payment frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyPeriod"), "31 Floating rate reset frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "32 Floating rate reset frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateIndicator"), "115 Indicator of the floating rate-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "nameOfTheFloatingRate"), "116 Name of the Floating Rate of Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateReferencePeriod"), "117 Floating rate reference period - time period-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateReferencePeriodMultiplier"), "118 Floating rate reference period - multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmount"), "87 Notional Amount 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "value"), "94/96-$ 94 Notional amount in effect on associated effective date of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "effectiveDate"), "94/96-$ 95 unadjusted effective date of the notional amount of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "endDate"), "94/96-$ 96 End date of the notional amount-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "totalNotionalQuantity"), "97 Total notional quantity-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "effectiveDate"), "98/100-$ 98 Notional quantity schedules - Unadjusted date on which thesociated notional quantity becomes effective of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "endDate"), "98/100-$ 99 Notional quantity schedules - Unadjusted end date of the notional quantity of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "value"), "98/100-$ 100 Notional quantity which becomes effective on thesociated unadjusted effective date-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "fixingDate"), "30 Fixing date-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "fixedRate"), "71 Fixed rate-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalCurrency"), "90 Notional currency-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "settlementCurrency"), "21 Settlement Currency-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spread", "monetary"), "72 Spread-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spread", "decimal"), "72 Spread-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spread", "basis"), "72 Spread-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spreadNotation"), "74 Spread notation-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spreadCurrency"), "73 Spread currency-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "quantityUnitOfMeasure"), "93 Quantity unit of measure-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "direction2"), "11 Direction 2-Leg 1");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRateDayCountConvention"), "27 Fixed rate day count convention-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateDayCountConvention"), "27 Floating rate day count convention of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "28 Fixed rate payment frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "28 Floating rate payment frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "29 Fixed rate payment frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "29 Floating rate payment frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyPeriod"), "31 Floating rate reset frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "32 Floating rate reset frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateIndicator"), "115 Indicator of the floating rate-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "nameOfTheFloatingRate"), "116 Name of the Floating Rate of Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateReferencePeriod"), "117 Floating rate reference period - time period-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateReferencePeriodMultiplier"), "118 Floating rate reference period - multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmount"), "87 Notional Amount 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "value"), "94/96-$ 94 Notional amount in effect on associated effective date of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "effectiveDate"), "94/96-$ 95 unadjusted effective date of the notional amount of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "endDate"), "94/96-$ 96 End date of the notional amount-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "totalNotionalQuantity"), "97 Total notional quantity-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "effectiveDate"), "98/100-$ 98 Notional quantity schedules - Unadjusted date on which thesociated notional quantity becomes effective of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "endDate"), "98/100-$ 99 Notional quantity schedules - Unadjusted end date of the notional quantity of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "value"), "98/100-$ 100 Notional quantity which becomes effective on thesociated unadjusted effective date-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "fixingDate"), "30 Fixing date-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "fixedRate"), "71 Fixed rate-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalCurrency"), "90 Notional currency-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "settlementCurrency"), "21 Settlement Currency-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread", "monetary"), "72 Spread-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread", "decimal"), "72 Spread-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread", "basis"), "72 Spread-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spreadNotation"), "74 Spread notation-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spreadCurrency"), "73 Spread currency-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "quantityUnitOfMeasure"), "93 Quantity unit of measure-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "direction2"), "11 Direction 2-Leg 2");
		startNode.addLabel(Arrays.asList("cryptoAssetUnderlyingIndicator"), "119 Derivative based on crypto-assets");
		startNode.addLabel(Arrays.asList("actionType"), "101 Action type");
		startNode.addLabel(Arrays.asList("eventType"), "102 Event type");
		startNode.addLabel(Arrays.asList("eventIdentifier"), "103 Event identifier");
		startNode.addLabel(Arrays.asList("eventTimestamp"), "104 Event timestamp");
		startNode.addLabel(Arrays.asList("confirmationTimestamp"), "[Internal] Confirmation Timestamp (DTCC)");
		startNode.addLabel(Arrays.asList("platformIdentifier"), "18 Platform Identifier");
		startNode.addLabel(Arrays.asList("deliveryType"), "108 Delivery Type");
		startNode.addLabel(Arrays.asList("reportSubmittingEntityID"), "12 Submitter identifier");
		startNode.addLabel(Arrays.asList("entityResponsibleForReporting"), "6 Entity responsible for reporting");
		startNode.addLabel(Arrays.asList("contractType"), "129 Contract Type");
		startNode.addLabel(Arrays.asList("assetClass"), "109 Asset Class");
		startNode.addLabel(Arrays.asList("optionType"), "131 Option type");
		startNode.addLabel(Arrays.asList("optionStyle"), "130 Option style");
		startNode.addLabel(Arrays.asList("embeddedOptionType"), "106 Embedded option type");
		startNode.addLabel(Arrays.asList("underlyingIdentification"), "111 Underlying identification");
		startNode.addLabel(Arrays.asList("underlyingIdentificationType"), "110 Underlying identification type");
		startNode.addLabel(Arrays.asList("nameOfTheUnderlyingIndex"), "113 Name of the underlying index");
		startNode.addLabel(Arrays.asList("maturityDateOfTheUnderlying"), "120 Maturity date of the underlying");
		startNode.addLabel(Arrays.asList("priorUTIProprietary"), "26 Prior UTI (Proprietary)");
		startNode.addLabel(Arrays.asList("clearingAccountOrigin"), "22 Clearing account origin");
		startNode.addLabel(Arrays.asList("clearingReceiptTimestamp"), "24 Clearing receipt timestamp");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifier"), "25 Unique transaction identifier (UTI)");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifierProprietary"), "25 Unique transaction identifier (UTI Proprietary)");
		startNode.addLabel(Arrays.asList("uniqueProductIdentifier"), "107 UPI");
		startNode.addLabel(Arrays.asList("originalSwapUTI"), "23 Original Swap UTI");
		startNode.addLabel(Arrays.asList("originalSwapSDRIdentifier"), "14 Original swap SDR identifier");
		startNode.addLabel(Arrays.asList("newSDRIdentifier"), "13 New SDR identifier");
		startNode.addLabel(Arrays.asList("technicalRecordId"), "[Internal] Technical Record Id (ISO)");
		startNode.addLabel(Arrays.asList("referenceEntity"), "114 Reference entity");
		startNode.addLabel(Arrays.asList("seniority"), "121 Seniority");
		startNode.addLabel(Arrays.asList("series"), "122 Series");
		startNode.addLabel(Arrays.asList("indexFactor"), "105 Index factor");
		startNode.addLabel(Arrays.asList("seriesVersion"), "123 Version");
		startNode.addLabel(Arrays.asList("barrier", "_single", "notation"), "187 Single barrier price notation");
		startNode.addLabel(Arrays.asList("barrier", "upper", "notation"), "188 Upper barrier price notation");
		startNode.addLabel(Arrays.asList("barrier", "lower", "notation"), "189 Lower barrier price notation");
		startNode.addLabel(Arrays.asList("barrier", "_single", "price", "monetary"), "190 Single barrier price");
		startNode.addLabel(Arrays.asList("barrier", "_single", "price", "decimal"), "190 Single barrier price");
		startNode.addLabel(Arrays.asList("barrier", "lower", "price", "monetary"), "192 Lower barrier price");
		startNode.addLabel(Arrays.asList("barrier", "lower", "price", "decimal"), "192 Lower barrier price");
		startNode.addLabel(Arrays.asList("barrier", "upper", "price", "monetary"), "194 Upper barrier price");
		startNode.addLabel(Arrays.asList("barrier", "upper", "price", "decimal"), "194 Upper barrier price");
		startNode.addLabel(Arrays.asList("barrier", "_single", "currency"), "196 Single barrier price currency");
		startNode.addLabel(Arrays.asList("barrier", "upper", "currency"), "197 Upper barrier price currency");
		startNode.addLabel(Arrays.asList("barrier", "lower", "currency"), "198 Lower barrier price currency");
		startNode.addLabel(Arrays.asList("initialMarginCollateralPortfolioCode"), "62 Initial margin collateral portfolio code");
		startNode.addLabel(Arrays.asList("variationMarginCollateralPortfolioCode"), "63 Variation margin collateral portfolio code");
		startNode.addLabel(Arrays.asList("nonReportable", "enrichment"), "Enrichment Data");
		startNode.addLabel(Arrays.asList("nonReportable", "preUpiData"), "Upi Pre-Enrichment Data");
		startNode.addLabel(Arrays.asList("nonReportable", "postUpiData"), "Upi Post-Enrichment Data");
		startNode.addLabel(Arrays.asList("originalSwapUTIProprietary"), "23 Original Swap UTI (Proprietary)");
		startNode.addLabel(Arrays.asList("underlyingIndexIndicator"), "112 Indicator of the underlying index");
	}
}
