package drr.regulation.jfsa.rewrite.valuation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.trade.party.functions.Counterparty_Validation;
import drr.regulation.jfsa.rewrite.valuation.JFSAValuationReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 7.0.0-dev.73
 */
@RosettaDataRule("JFSAValuationReportDTCC_JFSA_VR_0007_01")
@ImplementedBy(JFSAValuationReportDTCC_JFSA_VR_0007_01.Default.class)
public interface JFSAValuationReportDTCC_JFSA_VR_0007_01 extends Validator<JFSAValuationReport> {
	
	String NAME = "JFSAValuationReportDTCC_JFSA_VR_0007_01";
	String DEFINITION = "common.party.Counterparty_Validation( actionType, counterparty2IdentifierType, counterparty1, counterparty2 )";
	
	class Default implements JFSAValuationReportDTCC_JFSA_VR_0007_01 {
	
		@Inject protected Counterparty_Validation counterparty_Validation;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSAValuationReport jFSAValuationReport) {
			ComparisonResult result = executeDataRule(jFSAValuationReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSAValuationReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSAValuationReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSAValuationReport jFSAValuationReport) {
			try {
				return ComparisonResult.of(MapperS.of(counterparty_Validation.evaluate(MapperS.of(jFSAValuationReport).<ActionTypeEnum>map("getActionType", _jFSAValuationReport -> _jFSAValuationReport.getActionType()).get(), MapperS.of(jFSAValuationReport).<Boolean>map("getCounterparty2IdentifierType", _jFSAValuationReport -> _jFSAValuationReport.getCounterparty2IdentifierType()).get(), MapperS.of(jFSAValuationReport).<String>map("getCounterparty1", _jFSAValuationReport -> _jFSAValuationReport.getCounterparty1()).get(), MapperS.of(jFSAValuationReport).<String>map("getCounterparty2", _jFSAValuationReport -> _jFSAValuationReport.getCounterparty2()).get())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSAValuationReportDTCC_JFSA_VR_0007_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSAValuationReport jFSAValuationReport) {
			return Collections.emptyList();
		}
	}
}
